/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class GetClosestRowBeforeTracker {
    private final KeyValue targetkey;
    private final long oldestts;
    private KeyValue candidate = null;
    private final KeyValue.KVComparator kvcomparator;
    private final boolean metaregion;
    private final int rowoffset;
    private final int tablenamePlusDelimiterLength;
    private final NavigableMap<KeyValue, NavigableSet<KeyValue>> deletes;

    GetClosestRowBeforeTracker(KeyValue.KVComparator c, KeyValue kv, long ttl, boolean metaregion) {
        this.metaregion = metaregion;
        this.targetkey = kv;
        this.rowoffset = kv.getRowOffset();
        int l = -1;
        if (metaregion) {
            l = KeyValue.getDelimiter(kv.getBuffer(), this.rowoffset, kv.getRowLength(), 44) - this.rowoffset;
        }
        this.tablenamePlusDelimiterLength = metaregion ? l + 1 : -1;
        this.oldestts = System.currentTimeMillis() - ttl;
        this.kvcomparator = c;
        KeyValue.RowOnlyComparator rc = new KeyValue.RowOnlyComparator(this.kvcomparator);
        this.deletes = new TreeMap<KeyValue, NavigableSet<KeyValue>>(rc);
    }

    boolean isExpired(KeyValue kv) {
        return HStore.isExpired(kv, this.oldestts);
    }

    private void addDelete(KeyValue kv) {
        TreeSet<Cell> rowdeletes = (TreeSet<Cell>)this.deletes.get(kv);
        if (rowdeletes == null) {
            rowdeletes = new TreeSet<Cell>(this.kvcomparator);
            this.deletes.put(kv, rowdeletes);
        }
        rowdeletes.add(kv);
    }

    private boolean addCandidate(KeyValue kv) {
        if (!this.isDeleted(kv) && this.isBetterCandidate(kv)) {
            this.candidate = kv;
            return true;
        }
        return false;
    }

    boolean isBetterCandidate(KeyValue contender) {
        return this.candidate == null || this.kvcomparator.compareRows(this.candidate, contender) < 0 && this.kvcomparator.compareRows(contender, this.targetkey) <= 0;
    }

    private boolean isDeleted(KeyValue kv) {
        if (this.deletes.isEmpty()) {
            return false;
        }
        NavigableSet rowdeletes = (NavigableSet)this.deletes.get(kv);
        if (rowdeletes == null || rowdeletes.isEmpty()) {
            return false;
        }
        return this.isDeleted(kv, rowdeletes);
    }

    public boolean isDeleted(KeyValue kv, NavigableSet<KeyValue> ds) {
        if (this.deletes == null || this.deletes.isEmpty()) {
            return false;
        }
        for (KeyValue d : ds) {
            long kvts = kv.getTimestamp();
            long dts = d.getTimestamp();
            if (d.isDeleteFamily()) {
                if (kvts > dts) continue;
                return true;
            }
            int ret = Bytes.compareTo(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), d.getBuffer(), d.getQualifierOffset(), d.getQualifierLength());
            if (ret <= -1) continue;
            if (ret >= 1) break;
            if (kvts > dts) {
                return false;
            }
            switch (KeyValue.Type.codeToType(d.getType())) {
                case Delete: {
                    return kvts == dts;
                }
                case DeleteColumn: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean handleDeletes(KeyValue kv) {
        this.addDelete(kv);
        boolean deleted = false;
        if (!this.hasCandidate()) {
            return deleted;
        }
        if (this.isDeleted(this.candidate)) {
            this.candidate = null;
            deleted = true;
        }
        return deleted;
    }

    boolean handle(KeyValue kv) {
        if (kv.isDelete()) {
            this.handleDeletes(kv);
            return false;
        }
        return this.addCandidate(kv);
    }

    public boolean hasCandidate() {
        return this.candidate != null;
    }

    public KeyValue getCandidate() {
        return this.candidate;
    }

    public KeyValue getTargetKey() {
        return this.targetkey;
    }

    boolean isTooFar(KeyValue kv, KeyValue firstOnRow) {
        return this.kvcomparator.compareRows(kv, firstOnRow) > 0;
    }

    boolean isTargetTable(KeyValue kv) {
        if (!this.metaregion) {
            return true;
        }
        return Bytes.compareTo(this.targetkey.getBuffer(), this.rowoffset, this.tablenamePlusDelimiterLength, kv.getBuffer(), kv.getRowOffset(), this.tablenamePlusDelimiterLength) == 0;
    }
}

