/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsRegionServer {
    private MetricsRegionServerSource serverSource;
    private MetricsRegionServerWrapper regionServerWrapper;

    public MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper) {
        this(regionServerWrapper, CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createServer(regionServerWrapper));
    }

    MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, MetricsRegionServerSource serverSource) {
        this.regionServerWrapper = regionServerWrapper;
        this.serverSource = serverSource;
    }

    public MetricsRegionServerSource getMetricsSource() {
        return this.serverSource;
    }

    public MetricsRegionServerWrapper getRegionServerWrapper() {
        return this.regionServerWrapper;
    }

    public void updatePut(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowPut();
        }
        this.serverSource.updatePut(t);
    }

    public void updateDelete(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowDelete();
        }
        this.serverSource.updateDelete(t);
    }

    public void updateGet(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowGet();
        }
        this.serverSource.updateGet(t);
    }

    public void updateIncrement(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowIncrement();
        }
        this.serverSource.updateIncrement(t);
    }

    public void updateAppend(long t) {
        if (t > 1000L) {
            this.serverSource.incrSlowAppend();
        }
        this.serverSource.updateAppend(t);
    }

    public void updateReplay(long t) {
        this.serverSource.updateReplay(t);
    }
}

