/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableHistogram;

public class MetricsRegionSourceImpl
implements MetricsRegionSource {
    private final MetricsRegionWrapper regionWrapper;
    private boolean closed = false;
    private MetricsRegionAggregateSourceImpl agg;
    private DynamicMetricsRegistry registry;
    private static final Log LOG = LogFactory.getLog(MetricsRegionSourceImpl.class);
    private String regionNamePrefix;
    private String regionPutKey;
    private String regionDeleteKey;
    private String regionGetKey;
    private String regionIncrementKey;
    private String regionAppendKey;
    private String regionScanNextKey;
    private MetricMutableCounterLong regionPut;
    private MetricMutableCounterLong regionDelete;
    private MetricMutableCounterLong regionIncrement;
    private MetricMutableCounterLong regionAppend;
    private MetricMutableHistogram regionGet;
    private MetricMutableHistogram regionScanNext;

    public MetricsRegionSourceImpl(MetricsRegionWrapper regionWrapper, MetricsRegionAggregateSourceImpl aggregate) {
        this.regionWrapper = regionWrapper;
        this.agg = aggregate;
        this.agg.register(this);
        LOG.debug("Creating new MetricsRegionSourceImpl for table " + regionWrapper.getTableName() + " " + regionWrapper.getRegionName());
        this.registry = this.agg.getMetricsRegistry();
        this.regionNamePrefix = "namespace_" + regionWrapper.getNamespace() + "_table_" + regionWrapper.getTableName() + "_region_" + regionWrapper.getRegionName() + "_metric_";
        String suffix = "Count";
        this.regionPutKey = this.regionNamePrefix + "mutate" + suffix;
        this.regionPut = this.registry.getLongCounter(this.regionPutKey, 0L);
        this.regionDeleteKey = this.regionNamePrefix + "delete" + suffix;
        this.regionDelete = this.registry.getLongCounter(this.regionDeleteKey, 0L);
        this.regionIncrementKey = this.regionNamePrefix + "increment" + suffix;
        this.regionIncrement = this.registry.getLongCounter(this.regionIncrementKey, 0L);
        this.regionAppendKey = this.regionNamePrefix + "append" + suffix;
        this.regionAppend = this.registry.getLongCounter(this.regionAppendKey, 0L);
        this.regionGetKey = this.regionNamePrefix + "get";
        this.regionGet = this.registry.newHistogram(this.regionGetKey);
        this.regionScanNextKey = this.regionNamePrefix + "scanNext";
        this.regionScanNext = this.registry.newHistogram(this.regionScanNextKey);
    }

    @Override
    public void close() {
        this.closed = true;
        this.agg.deregister(this);
        LOG.trace("Removing region Metrics: " + this.regionWrapper.getRegionName());
        this.registry.removeMetric(this.regionPutKey);
        this.registry.removeMetric(this.regionDeleteKey);
        this.registry.removeMetric(this.regionIncrementKey);
        this.registry.removeMetric(this.regionAppendKey);
        this.registry.removeMetric(this.regionGetKey);
        this.registry.removeMetric(this.regionScanNextKey);
        JmxCacheBuster.clearJmxCache();
    }

    @Override
    public void updatePut() {
        this.regionPut.incr();
    }

    @Override
    public void updateDelete() {
        this.regionDelete.incr();
    }

    @Override
    public void updateGet(long getSize) {
        this.regionGet.add(getSize);
    }

    @Override
    public void updateScan(long scanSize) {
        this.regionScanNext.add(scanSize);
    }

    @Override
    public void updateIncrement() {
        this.regionIncrement.incr();
    }

    @Override
    public void updateAppend() {
        this.regionAppend.incr();
    }

    @Override
    public MetricsRegionAggregateSource getAggregateSource() {
        return this.agg;
    }

    @Override
    public int compareTo(MetricsRegionSource source) {
        if (!(source instanceof MetricsRegionSourceImpl)) {
            return -1;
        }
        MetricsRegionSourceImpl impl = (MetricsRegionSourceImpl)source;
        return this.regionWrapper.getRegionName().compareTo(impl.regionWrapper.getRegionName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetricsRegionSourceImpl)) {
            return false;
        }
        return this.compareTo((MetricsRegionSourceImpl)obj) == 0;
    }

    public int hashCode() {
        return this.regionWrapper.getRegionName().hashCode();
    }

    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed) {
            return;
        }
        mrb.addGauge(this.regionNamePrefix + "storeCount", "Number of Stores", this.regionWrapper.getNumStores());
        mrb.addGauge(this.regionNamePrefix + "storeFileCount", "Number of Store Files", this.regionWrapper.getNumStoreFiles());
        mrb.addGauge(this.regionNamePrefix + "memStoreSize", "Size of the memstore", this.regionWrapper.getMemstoreSize());
        mrb.addGauge(this.regionNamePrefix + "storeFileSize", "Size of storefiles being served.", this.regionWrapper.getStoreFileSize());
        mrb.addCounter(this.regionNamePrefix + "readRequestCount", "Number of read requests this region server has answered.", this.regionWrapper.getReadRequestCount());
        mrb.addCounter(this.regionNamePrefix + "writeRequestCount", "Number of mutation requests this region server has answered.", this.regionWrapper.getWriteRequestCount());
        mrb.addCounter(this.regionNamePrefix + "compactionsCompletedCount", "Number of compactions that have completed.", this.regionWrapper.getNumCompactionsCompleted());
        mrb.addCounter(this.regionNamePrefix + "numBytesCompactedCount", "Sum of filesize on all files entering a finished, successful or aborted, compaction", this.regionWrapper.getNumBytesCompacted());
        mrb.addCounter(this.regionNamePrefix + "numFilesCompactedCount", "Number of files that were input for finished, successful or aborted, compactions", this.regionWrapper.getNumFilesCompacted());
    }
}

