/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.BaseRowProcessor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;

class MultiRowMutationProcessor
extends BaseRowProcessor<MultiRowMutationProtos.MultiRowMutationProcessorRequest, MultiRowMutationProtos.MultiRowMutationProcessorResponse> {
    Collection<byte[]> rowsToLock;
    Collection<Mutation> mutations;

    MultiRowMutationProcessor(Collection<Mutation> mutations, Collection<byte[]> rowsToLock) {
        this.rowsToLock = rowsToLock;
        this.mutations = mutations;
    }

    @Override
    public Collection<byte[]> getRowsToLock() {
        return this.rowsToLock;
    }

    @Override
    public boolean readOnly() {
        return false;
    }

    @Override
    public MultiRowMutationProtos.MultiRowMutationProcessorResponse getResult() {
        return MultiRowMutationProtos.MultiRowMutationProcessorResponse.getDefaultInstance();
    }

    @Override
    public void process(long now, HRegion region, List<KeyValue> mutationKvs, WALEdit walEdit) throws IOException {
        byte[] byteNow = Bytes.toBytes(now);
        for (Mutation m : this.mutations) {
            if (m instanceof Put) {
                NavigableMap<byte[], List<Cell>> familyMap = m.getFamilyCellMap();
                region.checkFamilies(familyMap.keySet());
                region.checkTimestamps(familyMap, now);
                region.updateKVTimestamps(familyMap.values(), byteNow);
            } else if (m instanceof Delete) {
                Delete d = (Delete)m;
                region.prepareDelete(d);
                region.prepareDeleteTimestamps(d.getFamilyCellMap(), byteNow);
            } else {
                throw new DoNotRetryIOException("Action must be Put or Delete. But was: " + m.getClass().getName());
            }
            for (List cells : m.getFamilyCellMap().values()) {
                boolean writeToWAL = m.getDurability() != Durability.SKIP_WAL;
                for (Cell cell : cells) {
                    KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                    mutationKvs.add(kv);
                    if (!writeToWAL) continue;
                    walEdit.add(kv);
                }
            }
        }
    }

    @Override
    public void preProcess(HRegion region, WALEdit walEdit) throws IOException {
        RegionCoprocessorHost coprocessorHost = region.getCoprocessorHost();
        if (coprocessorHost != null) {
            for (Mutation m : this.mutations) {
                if (m instanceof Put) {
                    if (!coprocessorHost.prePut((Put)m, walEdit, m.getDurability())) continue;
                    return;
                }
                if (!(m instanceof Delete)) continue;
                Delete d = (Delete)m;
                region.prepareDelete(d);
                if (!coprocessorHost.preDelete(d, walEdit, d.getDurability())) continue;
                return;
            }
        }
    }

    @Override
    public void postProcess(HRegion region, WALEdit walEdit) throws IOException {
        RegionCoprocessorHost coprocessorHost = region.getCoprocessorHost();
        if (coprocessorHost != null) {
            for (Mutation m : this.mutations) {
                if (m instanceof Put) {
                    coprocessorHost.postPut((Put)m, walEdit, m.getDurability());
                    continue;
                }
                if (!(m instanceof Delete)) continue;
                coprocessorHost.postDelete((Delete)m, walEdit, m.getDurability());
            }
        }
    }

    @Override
    public MultiRowMutationProtos.MultiRowMutationProcessorRequest getRequestData() {
        return MultiRowMutationProtos.MultiRowMutationProcessorRequest.getDefaultInstance();
    }

    @Override
    public void initialize(MultiRowMutationProtos.MultiRowMutationProcessorRequest msg) {
    }

    @Override
    public Durability useDurability() {
        Durability durability = Durability.USE_DEFAULT;
        for (Mutation m : this.mutations) {
            if (m.getDurability().ordinal() <= durability.ordinal()) continue;
            durability = m.getDurability();
        }
        return durability;
    }
}

