/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;

@InterfaceAudience.Private
public class ReversedKeyValueHeap
extends KeyValueHeap {
    public ReversedKeyValueHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) throws IOException {
        super(scanners, new ReversedKVScannerComparator(comparator));
    }

    @Override
    public boolean seek(KeyValue seekKey) throws IOException {
        throw new IllegalStateException("seek cannot be called on ReversedKeyValueHeap");
    }

    @Override
    public boolean reseek(KeyValue seekKey) throws IOException {
        throw new IllegalStateException("reseek cannot be called on ReversedKeyValueHeap");
    }

    @Override
    public boolean requestSeek(KeyValue key, boolean forward, boolean useBloom) throws IOException {
        throw new IllegalStateException("requestSeek cannot be called on ReversedKeyValueHeap");
    }

    @Override
    public boolean seekToPreviousRow(KeyValue seekKey) throws IOException {
        KeyValueScanner scanner;
        if (this.current == null) {
            return false;
        }
        this.heap.add(this.current);
        this.current = null;
        while ((scanner = (KeyValueScanner)this.heap.poll()) != null) {
            KeyValue topKey = scanner.peek();
            if (this.comparator.getComparator().compareRows(topKey.getBuffer(), topKey.getRowOffset(), topKey.getRowLength(), seekKey.getBuffer(), seekKey.getRowOffset(), seekKey.getRowLength()) < 0) {
                this.heap.add(scanner);
                this.current = this.pollRealKV();
                return this.current != null;
            }
            if (!scanner.seekToPreviousRow(seekKey)) {
                scanner.close();
                continue;
            }
            this.heap.add(scanner);
        }
        return false;
    }

    @Override
    public boolean backwardSeek(KeyValue seekKey) throws IOException {
        KeyValueScanner scanner;
        if (this.current == null) {
            return false;
        }
        this.heap.add(this.current);
        this.current = null;
        while ((scanner = (KeyValueScanner)this.heap.poll()) != null) {
            KeyValue topKey = scanner.peek();
            if (this.comparator.getComparator().matchingRows(seekKey, topKey) && this.comparator.getComparator().compare(seekKey, topKey) <= 0 || this.comparator.getComparator().compareRows(seekKey, topKey) > 0) {
                this.heap.add(scanner);
                this.current = this.pollRealKV();
                return this.current != null;
            }
            if (!scanner.backwardSeek(seekKey)) {
                scanner.close();
                continue;
            }
            this.heap.add(scanner);
        }
        return false;
    }

    @Override
    public KeyValue next() throws IOException {
        if (this.current == null) {
            return null;
        }
        KeyValue kvReturn = this.current.next();
        KeyValue kvNext = this.current.peek();
        if (kvNext == null || this.comparator.kvComparator.compareRows(kvNext, kvReturn) > 0) {
            if (this.current.seekToPreviousRow(kvReturn)) {
                this.heap.add(this.current);
            } else {
                this.current.close();
            }
            this.current = this.pollRealKV();
        } else {
            KeyValueScanner topScanner = (KeyValueScanner)this.heap.peek();
            if (topScanner != null && this.comparator.compare(this.current, topScanner) > 0) {
                this.heap.add(this.current);
                this.current = this.pollRealKV();
            }
        }
        return kvReturn;
    }

    @Override
    public boolean seekToLastRow() throws IOException {
        throw new NotImplementedException("Not implemented");
    }

    private static class ReversedKVScannerComparator
    extends KeyValueHeap.KVScannerComparator {
        public ReversedKVScannerComparator(KeyValue.KVComparator kvComparator) {
            super(kvComparator);
        }

        @Override
        public int compare(KeyValueScanner left, KeyValueScanner right) {
            int rowComparison = this.compareRows(left.peek(), right.peek());
            if (rowComparison != 0) {
                return -rowComparison;
            }
            return super.compare(left, right);
        }

        public int compareRows(KeyValue left, KeyValue right) {
            return this.kvComparator.compareRows(left, right);
        }
    }
}

