/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class SplitTransaction {
    private static final Log LOG = LogFactory.getLog(SplitTransaction.class);
    private final HRegion parent;
    private HRegionInfo hri_a;
    private HRegionInfo hri_b;
    private long fileSplitTimeout = 30000L;
    private int znodeVersion = -1;
    private final byte[] splitrow;
    private final List<JournalEntry> journal = new ArrayList<JournalEntry>();
    private static IOException closedByOtherException = new IOException("Failed to close region: already closed by another thread");

    public SplitTransaction(HRegion r, byte[] splitrow) {
        this.parent = r;
        this.splitrow = splitrow;
    }

    public boolean prepare() {
        if (!this.parent.isSplittable()) {
            return false;
        }
        if (this.splitrow == null) {
            return false;
        }
        HRegionInfo hri = this.parent.getRegionInfo();
        this.parent.prepareToSplit();
        byte[] startKey = hri.getStartKey();
        byte[] endKey = hri.getEndKey();
        if (Bytes.equals(startKey, this.splitrow) || !this.parent.getRegionInfo().containsRow(this.splitrow)) {
            LOG.info("Split row is not inside region key range or is equal to startkey: " + Bytes.toStringBinary(this.splitrow));
            return false;
        }
        long rid = SplitTransaction.getDaughterRegionIdTimestamp(hri);
        this.hri_a = new HRegionInfo(hri.getTable(), startKey, this.splitrow, false, rid);
        this.hri_b = new HRegionInfo(hri.getTable(), this.splitrow, endKey, false, rid);
        return true;
    }

    private static long getDaughterRegionIdTimestamp(HRegionInfo hri) {
        long rid = EnvironmentEdgeManager.currentTimeMillis();
        if (rid < hri.getRegionId()) {
            LOG.warn("Clock skew; parent regions id is " + hri.getRegionId() + " but current time here is " + rid);
            rid = hri.getRegionId() + 1L;
        }
        return rid;
    }

    PairOfSameType<HRegion> createDaughters(Server server, RegionServerServices services) throws IOException {
        LOG.info("Starting split of region " + this.parent);
        if (server != null && server.isStopped() || services != null && services.isStopping()) {
            throw new IOException("Server is stopped or stopping");
        }
        assert (!this.parent.lock.writeLock().isHeldByCurrentThread()) : "Unsafe to hold write lock while performing RPCs";
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().preSplit();
        }
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().preSplit(this.splitrow);
        }
        boolean testing = server == null ? true : server.getConfiguration().getBoolean("hbase.testing.nocluster", false);
        this.fileSplitTimeout = testing ? this.fileSplitTimeout : server.getConfiguration().getLong("hbase.regionserver.fileSplitTimeout", this.fileSplitTimeout);
        PairOfSameType<HRegion> daughterRegions = this.stepsBeforePONR(server, services, testing);
        ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        if (this.parent.getCoprocessorHost() != null) {
            if (this.parent.getCoprocessorHost().preSplitBeforePONR(this.splitrow, metaEntries)) {
                throw new IOException("Coprocessor bypassing region " + this.parent.getRegionNameAsString() + " split.");
            }
            try {
                for (Mutation p : metaEntries) {
                    HRegionInfo.parseRegionName(p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error("Row key of mutation from coprossor is not parsable as region name.Mutations from coprocessor should only for hbase:meta table.");
                throw e;
            }
        }
        this.journal.add(JournalEntry.PONR);
        if (!testing) {
            if (metaEntries == null || metaEntries.isEmpty()) {
                MetaEditor.splitRegion(server.getCatalogTracker(), this.parent.getRegionInfo(), daughterRegions.getFirst().getRegionInfo(), daughterRegions.getSecond().getRegionInfo(), server.getServerName());
            } else {
                this.offlineParentInMetaAndputMetaEntries(server.getCatalogTracker(), this.parent.getRegionInfo(), daughterRegions.getFirst().getRegionInfo(), daughterRegions.getSecond().getRegionInfo(), server.getServerName(), metaEntries);
            }
        }
        return daughterRegions;
    }

    public PairOfSameType<HRegion> stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
        if (server != null && server.getZooKeeper() != null) {
            try {
                SplitTransaction.createNodeSplitting(server.getZooKeeper(), this.parent.getRegionInfo(), server.getServerName(), this.hri_a, this.hri_b);
            }
            catch (KeeperException e) {
                throw new IOException("Failed creating PENDING_SPLIT znode on " + this.parent.getRegionNameAsString(), e);
            }
        }
        this.journal.add(JournalEntry.SET_SPLITTING_IN_ZK);
        if (server != null && server.getZooKeeper() != null) {
            this.znodeVersion = this.getZKNode(server, services);
        }
        this.parent.getRegionFileSystem().createSplitsDir();
        this.journal.add(JournalEntry.CREATE_SPLIT_DIR);
        Map<byte[], List<StoreFile>> hstoreFilesToSplit = null;
        Exception exceptionToThrow = null;
        try {
            hstoreFilesToSplit = this.parent.close(false);
        }
        catch (Exception e) {
            exceptionToThrow = e;
        }
        if (exceptionToThrow == null && hstoreFilesToSplit == null) {
            exceptionToThrow = closedByOtherException;
        }
        if (exceptionToThrow != closedByOtherException) {
            this.journal.add(JournalEntry.CLOSED_PARENT_REGION);
        }
        if (exceptionToThrow != null) {
            if (exceptionToThrow instanceof IOException) {
                throw (IOException)exceptionToThrow;
            }
            throw new IOException(exceptionToThrow);
        }
        if (!testing) {
            services.removeFromOnlineRegions(this.parent, null);
        }
        this.journal.add(JournalEntry.OFFLINED_PARENT);
        this.splitStoreFiles(hstoreFilesToSplit);
        this.journal.add(JournalEntry.STARTED_REGION_A_CREATION);
        HRegion a = this.parent.createDaughterRegionFromSplits(this.hri_a);
        this.journal.add(JournalEntry.STARTED_REGION_B_CREATION);
        HRegion b = this.parent.createDaughterRegionFromSplits(this.hri_b);
        return new PairOfSameType<HRegion>(a, b);
    }

    void openDaughters(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
        boolean stopping;
        boolean stopped = server != null && server.isStopped();
        boolean bl = stopping = services != null && services.isStopping();
        if (stopped || stopping) {
            LOG.info("Not opening daughters " + b.getRegionInfo().getRegionNameAsString() + " and " + a.getRegionInfo().getRegionNameAsString() + " because stopping=" + stopping + ", stopped=" + stopped);
        } else {
            DaughterOpener aOpener = new DaughterOpener(server, a);
            DaughterOpener bOpener = new DaughterOpener(server, b);
            aOpener.start();
            bOpener.start();
            try {
                aOpener.join();
                bOpener.join();
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            if (aOpener.getException() != null) {
                throw new IOException("Failed " + aOpener.getName(), aOpener.getException());
            }
            if (bOpener.getException() != null) {
                throw new IOException("Failed " + bOpener.getName(), bOpener.getException());
            }
            if (services != null) {
                try {
                    services.postOpenDeployTasks(b, server.getCatalogTracker());
                    services.addToOnlineRegions(b);
                    services.postOpenDeployTasks(a, server.getCatalogTracker());
                    services.addToOnlineRegions(a);
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
            }
        }
    }

    void transitionZKNode(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
        if (server != null && server.getZooKeeper() != null) {
            try {
                this.znodeVersion = SplitTransaction.transitionSplittingNode(server.getZooKeeper(), this.parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo(), server.getServerName(), this.znodeVersion, EventType.RS_ZK_REGION_SPLITTING, EventType.RS_ZK_REGION_SPLIT);
                int spins = 0;
                do {
                    if (spins % 10 == 0) {
                        LOG.debug("Still waiting on the master to process the split for " + this.parent.getRegionInfo().getEncodedName());
                    }
                    Thread.sleep(100L);
                    this.znodeVersion = SplitTransaction.transitionSplittingNode(server.getZooKeeper(), this.parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo(), server.getServerName(), this.znodeVersion, EventType.RS_ZK_REGION_SPLIT, EventType.RS_ZK_REGION_SPLIT);
                    ++spins;
                } while (this.znodeVersion != -1 && !server.isStopped() && !services.isStopping());
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException("Failed telling master about split", e);
            }
        }
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().postSplit(a, b);
        }
    }

    private int getZKNode(Server server, RegionServerServices services) throws IOException {
        try {
            int spins = 0;
            Stat stat = new Stat();
            ZooKeeperWatcher zkw = server.getZooKeeper();
            ServerName expectedServer = server.getServerName();
            String node = this.parent.getRegionInfo().getEncodedName();
            while (!server.isStopped() && !services.isStopping()) {
                if (spins % 5 == 0) {
                    LOG.debug("Still waiting for master to process the pending_split for " + node);
                    SplitTransaction.transitionSplittingNode(zkw, this.parent.getRegionInfo(), this.hri_a, this.hri_b, expectedServer, -1, EventType.RS_ZK_REQUEST_REGION_SPLIT, EventType.RS_ZK_REQUEST_REGION_SPLIT);
                }
                Thread.sleep(100L);
                ++spins;
                byte[] data = ZKAssign.getDataNoWatch(zkw, node, stat);
                if (data == null) {
                    throw new IOException("Data is null, splitting node " + node + " no longer exists");
                }
                RegionTransition rt = RegionTransition.parseFrom(data);
                EventType et = rt.getEventType();
                if (et == EventType.RS_ZK_REGION_SPLITTING) {
                    ServerName serverName = rt.getServerName();
                    if (!serverName.equals(expectedServer)) {
                        throw new IOException("Splitting node " + node + " is for " + serverName + ", not us " + expectedServer);
                    }
                    byte[] payloadOfSplitting = rt.getPayload();
                    List<HRegionInfo> splittingRegions = HRegionInfo.parseDelimitedFrom(payloadOfSplitting, 0, payloadOfSplitting.length);
                    assert (splittingRegions.size() == 2);
                    HRegionInfo a = splittingRegions.get(0);
                    HRegionInfo b = splittingRegions.get(1);
                    if (!this.hri_a.equals(a) || !this.hri_b.equals(b)) {
                        throw new IOException("Splitting node " + node + " is for " + a + ", " + b + ", not expected daughters: " + this.hri_a + ", " + this.hri_b);
                    }
                    return stat.getVersion();
                }
                if (et == EventType.RS_ZK_REQUEST_REGION_SPLIT) continue;
                throw new IOException("Splitting node " + node + " moved out of splitting to " + (Object)((Object)et));
            }
            throw new IOException("Server is " + (services.isStopping() ? "stopping" : "stopped"));
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Failed getting SPLITTING znode on " + this.parent.getRegionNameAsString(), e);
        }
    }

    public PairOfSameType<HRegion> execute(Server server, RegionServerServices services) throws IOException {
        PairOfSameType<HRegion> regions = this.createDaughters(server, services);
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().preSplitAfterPONR();
        }
        return this.stepsAfterPONR(server, services, regions);
    }

    public PairOfSameType<HRegion> stepsAfterPONR(Server server, RegionServerServices services, PairOfSameType<HRegion> regions) throws IOException {
        this.openDaughters(server, services, regions.getFirst(), regions.getSecond());
        this.transitionZKNode(server, services, regions.getFirst(), regions.getSecond());
        return regions;
    }

    private void offlineParentInMetaAndputMetaEntries(CatalogTracker catalogTracker, HRegionInfo parent, HRegionInfo splitA, HRegionInfo splitB, ServerName serverName, List<Mutation> metaEntries) throws IOException {
        List<Mutation> mutations = metaEntries;
        HRegionInfo copyOfParent = new HRegionInfo(parent);
        copyOfParent.setOffline(true);
        copyOfParent.setSplit(true);
        Put putParent = MetaEditor.makePutFromRegionInfo(copyOfParent);
        MetaEditor.addDaughtersToPut(putParent, splitA, splitB);
        mutations.add(putParent);
        Put putA = MetaEditor.makePutFromRegionInfo(splitA);
        Put putB = MetaEditor.makePutFromRegionInfo(splitB);
        this.addLocation(putA, serverName, 1L);
        this.addLocation(putB, serverName, 1L);
        mutations.add(putA);
        mutations.add(putB);
        MetaEditor.mutateMetaTable(catalogTracker, mutations);
    }

    public Put addLocation(Put p, ServerName sn, long openSeqNum) {
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes(sn.getHostAndPort()));
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes(sn.getStartcode()));
        p.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER, Bytes.toBytes(openSeqNum));
        return p;
    }

    void openDaughterRegion(Server server, HRegion daughter) throws IOException, KeeperException {
        HRegionInfo hri = daughter.getRegionInfo();
        LoggingProgressable reporter = server == null ? null : new LoggingProgressable(hri, server.getConfiguration().getLong("hbase.regionserver.split.daughter.open.log.interval", 10000L));
        daughter.openHRegion(reporter);
    }

    private void splitStoreFiles(Map<byte[], List<StoreFile>> hstoreFilesToSplit) throws IOException {
        if (hstoreFilesToSplit == null) {
            throw new IOException("Close returned empty list of StoreFiles");
        }
        int nbFiles = hstoreFilesToSplit.size();
        if (nbFiles == 0) {
            return;
        }
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setNameFormat("StoreFileSplitter-%1$d");
        ThreadFactory factory = builder.build();
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(nbFiles, factory);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(nbFiles);
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesToSplit.entrySet()) {
            for (StoreFile sf : entry.getValue()) {
                StoreFileSplitter sfs = new StoreFileSplitter(entry.getKey(), sf);
                futures.add(threadPool.submit(sfs));
            }
        }
        threadPool.shutdown();
        try {
            boolean stillRunning;
            boolean bl = stillRunning = !threadPool.awaitTermination(this.fileSplitTimeout, TimeUnit.MILLISECONDS);
            if (stillRunning) {
                threadPool.shutdownNow();
                while (!threadPool.isTerminated()) {
                    Thread.sleep(50L);
                }
                throw new IOException("Took too long to split the files and create the references, aborting split");
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    private void splitStoreFile(byte[] family, StoreFile sf) throws IOException {
        HRegionFileSystem fs = this.parent.getRegionFileSystem();
        String familyName = Bytes.toString(family);
        fs.splitStoreFile(this.hri_a, familyName, sf, this.splitrow, false);
        fs.splitStoreFile(this.hri_b, familyName, sf, this.splitrow, true);
    }

    public boolean rollback(Server server, RegionServerServices services) throws IOException {
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().preRollBackSplit();
        }
        boolean result = true;
        ListIterator<JournalEntry> iterator = this.journal.listIterator(this.journal.size());
        block11: while (iterator.hasPrevious()) {
            JournalEntry je = iterator.previous();
            switch (je) {
                case SET_SPLITTING_IN_ZK: {
                    if (server == null || server.getZooKeeper() == null) continue block11;
                    SplitTransaction.cleanZK(server, this.parent.getRegionInfo());
                    continue block11;
                }
                case CREATE_SPLIT_DIR: {
                    this.parent.writestate.writesEnabled = true;
                    this.parent.getRegionFileSystem().cleanupSplitsDir();
                    continue block11;
                }
                case CLOSED_PARENT_REGION: {
                    try {
                        this.parent.initialize();
                        continue block11;
                    }
                    catch (IOException e) {
                        LOG.error("Failed rollbacking CLOSED_PARENT_REGION of region " + this.parent.getRegionNameAsString(), e);
                        throw new RuntimeException(e);
                    }
                }
                case STARTED_REGION_A_CREATION: {
                    this.parent.getRegionFileSystem().cleanupDaughterRegion(this.hri_a);
                    continue block11;
                }
                case STARTED_REGION_B_CREATION: {
                    this.parent.getRegionFileSystem().cleanupDaughterRegion(this.hri_b);
                    continue block11;
                }
                case OFFLINED_PARENT: {
                    if (services == null) continue block11;
                    services.addToOnlineRegions(this.parent);
                    continue block11;
                }
                case PONR: {
                    return false;
                }
            }
            throw new RuntimeException("Unhandled journal entry: " + (Object)((Object)je));
        }
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().postRollBackSplit();
        }
        return result;
    }

    HRegionInfo getFirstDaughter() {
        return this.hri_a;
    }

    HRegionInfo getSecondDaughter() {
        return this.hri_b;
    }

    private static void cleanZK(Server server, HRegionInfo hri) {
        try {
            if (!ZKAssign.deleteNode(server.getZooKeeper(), hri.getEncodedName(), EventType.RS_ZK_REQUEST_REGION_SPLIT, server.getServerName())) {
                ZKAssign.deleteNode(server.getZooKeeper(), hri.getEncodedName(), EventType.RS_ZK_REGION_SPLITTING, server.getServerName());
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info("Failed cleanup zk node of " + hri.getRegionNameAsString(), e);
        }
        catch (KeeperException e) {
            server.abort("Failed cleanup of " + hri.getRegionNameAsString(), e);
        }
    }

    public static void createNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, HRegionInfo a, HRegionInfo b) throws KeeperException, IOException {
        LOG.debug(zkw.prefix("Creating ephemeral node for " + region.getEncodedName() + " in PENDING_SPLIT state"));
        byte[] payload = HRegionInfo.toDelimitedByteArray(a, b);
        RegionTransition rt = RegionTransition.createRegionTransition(EventType.RS_ZK_REQUEST_REGION_SPLIT, region.getRegionName(), serverName, payload);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        if (!ZKUtil.createEphemeralNodeAndWatch(zkw, node, rt.toByteArray())) {
            throw new IOException("Failed create of ephemeral " + node);
        }
    }

    public static int transitionSplittingNode(ZooKeeperWatcher zkw, HRegionInfo parent, HRegionInfo a, HRegionInfo b, ServerName serverName, int znodeVersion, EventType beginState, EventType endState) throws KeeperException, IOException {
        byte[] payload = HRegionInfo.toDelimitedByteArray(a, b);
        return ZKAssign.transitionNode(zkw, parent, serverName, beginState, endState, znodeVersion, payload);
    }

    class StoreFileSplitter
    implements Callable<Void> {
        private final byte[] family;
        private final StoreFile sf;

        public StoreFileSplitter(byte[] family, StoreFile sf) {
            this.sf = sf;
            this.family = family;
        }

        @Override
        public Void call() throws IOException {
            SplitTransaction.this.splitStoreFile(this.family, this.sf);
            return null;
        }
    }

    static class LoggingProgressable
    implements CancelableProgressable {
        private final HRegionInfo hri;
        private long lastLog = -1L;
        private final long interval;

        LoggingProgressable(HRegionInfo hri, long interval) {
            this.hri = hri;
            this.interval = interval;
        }

        @Override
        public boolean progress() {
            long now = System.currentTimeMillis();
            if (now - this.lastLog > this.interval) {
                LOG.info("Opening " + this.hri.getRegionNameAsString());
                this.lastLog = now;
            }
            return true;
        }
    }

    class DaughterOpener
    extends HasThread {
        private final Server server;
        private final HRegion r;
        private Throwable t;

        DaughterOpener(Server s, HRegion r) {
            super((s == null ? "null-services" : s.getServerName()) + "-daughterOpener=" + r.getRegionInfo().getEncodedName());
            this.t = null;
            this.setDaemon(true);
            this.server = s;
            this.r = r;
        }

        Throwable getException() {
            return this.t;
        }

        @Override
        public void run() {
            try {
                SplitTransaction.this.openDaughterRegion(this.server, this.r);
            }
            catch (Throwable t) {
                this.t = t;
            }
        }
    }

    static enum JournalEntry {
        SET_SPLITTING_IN_ZK,
        CREATE_SPLIT_DIR,
        CLOSED_PARENT_REGION,
        OFFLINED_PARENT,
        STARTED_REGION_A_CREATION,
        STARTED_REGION_B_CREATION,
        PONR;

    }
}

