/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class StatefulStoreMockMaker {
    public CompactionContext selectCompaction() {
        return null;
    }

    public void cancelCompaction(Object originalContext) {
    }

    public int getPriority() {
        return 0;
    }

    public Store createStoreMock(String name) throws Exception {
        Store store = (Store)Mockito.mock(Store.class, (String)name);
        Mockito.when((Object)store.requestCompaction(Mockito.anyInt(), (CompactionRequest)Mockito.isNull(CompactionRequest.class))).then((Answer)new SelectAnswer());
        Mockito.when((Object)store.getCompactPriority()).then((Answer)new PriorityAnswer());
        ((Store)Mockito.doAnswer((Answer)new CancelAnswer()).when((Object)store)).cancelRequestedCompaction((CompactionContext)Mockito.any(CompactionContext.class));
        return store;
    }

    private class CancelAnswer
    implements Answer<Object> {
        private CancelAnswer() {
        }

        public CompactionContext answer(InvocationOnMock invocation) throws Throwable {
            StatefulStoreMockMaker.this.cancelCompaction(invocation.getArguments()[0]);
            return null;
        }
    }

    private class PriorityAnswer
    implements Answer<Integer> {
        private PriorityAnswer() {
        }

        public Integer answer(InvocationOnMock invocation) throws Throwable {
            return StatefulStoreMockMaker.this.getPriority();
        }
    }

    private class SelectAnswer
    implements Answer<CompactionContext> {
        private SelectAnswer() {
        }

        public CompactionContext answer(InvocationOnMock invocation) throws Throwable {
            return StatefulStoreMockMaker.this.selectCompaction();
        }
    }
}

