/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestAtomicOperation {
    static final Log LOG = LogFactory.getLog(TestAtomicOperation.class);
    @Rule
    public TestName name = new TestName();
    HRegion region = null;
    private HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    static byte[] tableName;
    static final byte[] qual1;
    static final byte[] qual2;
    static final byte[] qual3;
    static final byte[] value1;
    static final byte[] value2;
    static final byte[] row;
    static final byte[] row2;
    private static CountDownLatch latch;
    private static volatile TestStep testStep;
    private final String family = "f1";

    @Before
    public void setup() {
        tableName = Bytes.toBytes(this.name.getMethodName());
    }

    @Test
    public void testAppend() throws IOException {
        this.initHRegion(tableName, this.name.getMethodName(), new byte[][]{HBaseTestingUtility.fam1});
        String v1 = "Ultimate Answer to the Ultimate Question of Life, The Universe, and Everything";
        String v2 = " is... 42.";
        Append a = new Append(row);
        a.setReturnResults(false);
        a.add(HBaseTestingUtility.fam1, qual1, Bytes.toBytes(v1));
        a.add(HBaseTestingUtility.fam1, qual2, Bytes.toBytes(v2));
        Assert.assertNull((Object)this.region.append(a));
        a = new Append(row);
        a.add(HBaseTestingUtility.fam1, qual1, Bytes.toBytes(v2));
        a.add(HBaseTestingUtility.fam1, qual2, Bytes.toBytes(v1));
        Result result = this.region.append(a);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo(Bytes.toBytes(v1 + v2), result.getValue(HBaseTestingUtility.fam1, qual1)));
        Assert.assertEquals((long)0L, (long)Bytes.compareTo(Bytes.toBytes(v2 + v1), result.getValue(HBaseTestingUtility.fam1, qual2)));
    }

    @Test
    public void testIncrementMultiThreads() throws IOException {
        int i;
        LOG.info("Starting test testIncrementMultiThreads");
        this.initHRegion(tableName, this.name.getMethodName(), new int[]{1, 3}, (byte[][])new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2});
        int numThreads = 100;
        int incrementsPerThread = 1000;
        Incrementer[] all = new Incrementer[numThreads];
        int expectedTotal = 0;
        for (i = 0; i < numThreads; ++i) {
            all[i] = new Incrementer(this.region, i, i, incrementsPerThread);
            expectedTotal += i * incrementsPerThread;
        }
        for (i = 0; i < numThreads; ++i) {
            all[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.assertICV(row, HBaseTestingUtility.fam1, qual1, expectedTotal);
        this.assertICV(row, HBaseTestingUtility.fam1, qual2, expectedTotal * 2);
        this.assertICV(row, HBaseTestingUtility.fam2, qual3, expectedTotal * 3);
        LOG.info("testIncrementMultiThreads successfully verified that total is " + expectedTotal);
    }

    private void assertICV(byte[] row, byte[] familiy, byte[] qualifier, long amount) throws IOException {
        Get get = new Get(row);
        get.addColumn(familiy, qualifier);
        Result result = this.region.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        Cell kv = result.rawCells()[0];
        long r = Bytes.toLong(CellUtil.cloneValue(kv));
        Assert.assertEquals((long)amount, (long)r);
    }

    private void initHRegion(byte[] tableName, String callingMethod, byte[] ... families) throws IOException {
        this.initHRegion(tableName, callingMethod, (int[])null, families);
    }

    private void initHRegion(byte[] tableName, String callingMethod, int[] maxVersions, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(tableName));
        int i = 0;
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setMaxVersions(maxVersions != null ? maxVersions[i++] : 1);
            htd.addFamily(hcd);
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.region = this.TEST_UTIL.createLocalHRegion(info, htd);
    }

    @Test
    public void testAppendMultiThreads() throws IOException {
        int i;
        LOG.info("Starting test testAppendMultiThreads");
        this.initHRegion(tableName, this.name.getMethodName(), new int[]{1, 3}, (byte[][])new byte[][]{HBaseTestingUtility.fam1, HBaseTestingUtility.fam2});
        int numThreads = 100;
        int opsPerThread = 100;
        AtomicOperation[] all = new AtomicOperation[numThreads];
        final byte[] val = new byte[]{1};
        AtomicInteger failures = new AtomicInteger(0);
        for (i = 0; i < numThreads; ++i) {
            all[i] = new AtomicOperation(this.region, opsPerThread, null, failures){

                @Override
                public void run() {
                    for (int i = 0; i < this.numOps; ++i) {
                        try {
                            Append a = new Append(row);
                            a.add(HBaseTestingUtility.fam1, qual1, val);
                            a.add(HBaseTestingUtility.fam1, qual2, val);
                            a.add(HBaseTestingUtility.fam2, qual3, val);
                            this.region.append(a);
                            Get g = new Get(row);
                            Result result = this.region.get(g);
                            Assert.assertEquals((long)result.getValue(HBaseTestingUtility.fam1, qual1).length, (long)result.getValue(HBaseTestingUtility.fam1, qual2).length);
                            Assert.assertEquals((long)result.getValue(HBaseTestingUtility.fam1, qual1).length, (long)result.getValue(HBaseTestingUtility.fam2, qual3).length);
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.failures.incrementAndGet();
                            Assert.fail();
                        }
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            all[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)0L, (long)failures.get());
        Get g = new Get(row);
        Result result = this.region.get(g);
        Assert.assertEquals((long)result.getValue(HBaseTestingUtility.fam1, qual1).length, (long)10000L);
        Assert.assertEquals((long)result.getValue(HBaseTestingUtility.fam1, qual2).length, (long)10000L);
        Assert.assertEquals((long)result.getValue(HBaseTestingUtility.fam2, qual3).length, (long)10000L);
    }

    @Test
    public void testRowMutationMultiThreads() throws IOException {
        int i;
        LOG.info("Starting test testRowMutationMultiThreads");
        this.initHRegion(tableName, this.name.getMethodName(), new byte[][]{HBaseTestingUtility.fam1});
        int numThreads = 10;
        int opsPerThread = 500;
        AtomicOperation[] all = new AtomicOperation[numThreads];
        AtomicLong timeStamps = new AtomicLong(0L);
        AtomicInteger failures = new AtomicInteger(0);
        for (i = 0; i < numThreads; ++i) {
            all[i] = new AtomicOperation(this.region, opsPerThread, timeStamps, failures){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean op = true;
                    for (int i = 0; i < this.numOps; ++i) {
                        try {
                            if (i % 10 == 0) {
                                HRegion hRegion = this.region;
                                synchronized (hRegion) {
                                    LOG.debug("flushing");
                                    this.region.flushcache();
                                    if (i % 100 == 0) {
                                        this.region.compactStores();
                                    }
                                }
                            }
                            long ts = this.timeStamps.incrementAndGet();
                            RowMutations rm = new RowMutations(row);
                            if (op) {
                                Put p = new Put(row, ts);
                                p.add(HBaseTestingUtility.fam1, qual1, value1);
                                rm.add(p);
                                Delete d = new Delete(row);
                                d.deleteColumns(HBaseTestingUtility.fam1, qual2, ts);
                                rm.add(d);
                            } else {
                                Delete d = new Delete(row);
                                d.deleteColumns(HBaseTestingUtility.fam1, qual1, ts);
                                rm.add(d);
                                Put p = new Put(row, ts);
                                p.add(HBaseTestingUtility.fam1, qual2, value2);
                                rm.add(p);
                            }
                            this.region.mutateRow(rm);
                            op ^= true;
                            Get g = new Get(row);
                            Result r = this.region.get(g);
                            if (r.size() == 1) continue;
                            LOG.debug(r);
                            this.failures.incrementAndGet();
                            Assert.fail();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.failures.incrementAndGet();
                            Assert.fail();
                        }
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            all[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)0L, (long)failures.get());
    }

    @Test
    public void testMultiRowMutationMultiThreads() throws IOException {
        int i;
        LOG.info("Starting test testMultiRowMutationMultiThreads");
        this.initHRegion(tableName, this.name.getMethodName(), new byte[][]{HBaseTestingUtility.fam1});
        int numThreads = 10;
        int opsPerThread = 500;
        AtomicOperation[] all = new AtomicOperation[numThreads];
        AtomicLong timeStamps = new AtomicLong(0L);
        AtomicInteger failures = new AtomicInteger(0);
        final List rowsToLock = Arrays.asList(row, row2);
        for (i = 0; i < numThreads; ++i) {
            all[i] = new AtomicOperation(this.region, opsPerThread, timeStamps, failures){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean op = true;
                    for (int i = 0; i < this.numOps; ++i) {
                        try {
                            if (i % 10 == 0) {
                                HRegion hRegion = this.region;
                                synchronized (hRegion) {
                                    LOG.debug("flushing");
                                    this.region.flushcache();
                                    if (i % 100 == 0) {
                                        this.region.compactStores();
                                    }
                                }
                            }
                            long ts = this.timeStamps.incrementAndGet();
                            ArrayList<Mutation> mrm = new ArrayList<Mutation>();
                            if (op) {
                                Put p = new Put(row2, ts);
                                p.add(HBaseTestingUtility.fam1, qual1, value1);
                                mrm.add(p);
                                Delete d = new Delete(row);
                                d.deleteColumns(HBaseTestingUtility.fam1, qual1, ts);
                                mrm.add(d);
                            } else {
                                Delete d = new Delete(row2);
                                d.deleteColumns(HBaseTestingUtility.fam1, qual1, ts);
                                mrm.add(d);
                                Put p = new Put(row, ts);
                                p.add(HBaseTestingUtility.fam1, qual1, value2);
                                mrm.add(p);
                            }
                            this.region.mutateRowsWithLocks(mrm, rowsToLock);
                            op ^= true;
                            Scan s = new Scan(row);
                            RegionScanner rs = this.region.getScanner(s);
                            ArrayList<Cell> r = new ArrayList<Cell>();
                            while (rs.next(r)) {
                            }
                            rs.close();
                            if (r.size() == 1) continue;
                            LOG.debug(r);
                            this.failures.incrementAndGet();
                            Assert.fail();
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.failures.incrementAndGet();
                            Assert.fail();
                        }
                    }
                }
            };
        }
        for (i = 0; i < numThreads; ++i) {
            all[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                all[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)0L, (long)failures.get());
    }

    @Test
    public void testPutAndCheckAndPutInParallel() throws Exception {
        String tableName = "testPutAndCheckAndPut";
        Configuration conf = this.TEST_UTIL.getConfiguration();
        conf.setClass("hbase.hregion.impl", MockHRegion.class, HeapSize.class);
        MockHRegion region = (MockHRegion)this.TEST_UTIL.createLocalHRegion(Bytes.toBytes("testPutAndCheckAndPut"), null, null, "testPutAndCheckAndPut", conf, false, Durability.SYNC_WAL, null, new byte[][]{Bytes.toBytes("f1")});
        Mutation[] puts = new Put[1];
        Put put = new Put(Bytes.toBytes("r1"));
        put.add(Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("10"));
        puts[0] = put;
        region.batchMutate(puts);
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
        ctx.addThread(new PutThread(ctx, region));
        ctx.addThread(new CheckAndPutThread(ctx, region));
        ctx.startThreads();
        while (testStep != TestStep.CHECKANDPUT_COMPLETED) {
            Thread.sleep(100L);
        }
        ctx.stop();
        Scan s = new Scan();
        RegionScanner scanner = region.getScanner(s);
        ArrayList<Cell> results = new ArrayList<Cell>();
        scanner.next(results, 2);
        for (Cell keyValue : results) {
            Assert.assertEquals((Object)"50", (Object)Bytes.toString(CellUtil.cloneValue(keyValue)));
        }
    }

    static {
        qual1 = Bytes.toBytes("qual1");
        qual2 = Bytes.toBytes("qual2");
        qual3 = Bytes.toBytes("qual3");
        value1 = Bytes.toBytes("value1");
        value2 = Bytes.toBytes("value2");
        row = Bytes.toBytes("rowA");
        row2 = Bytes.toBytes("rowB");
        latch = new CountDownLatch(1);
        testStep = TestStep.INIT;
    }

    public static class MockHRegion
    extends HRegion {
        public MockHRegion(Path tableDir, HLog log, FileSystem fs, Configuration conf, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, conf, regionInfo, htd, rsServices);
        }

        @Override
        public HRegion.RowLock getRowLock(byte[] row, boolean waitForLock) throws IOException {
            if (testStep == TestStep.CHECKANDPUT_STARTED) {
                latch.countDown();
            }
            return new WrappedRowLock(super.getRowLock(row, waitForLock));
        }

        public class WrappedRowLock
        extends HRegion.RowLock {
            private WrappedRowLock(HRegion.RowLock rowLock) {
                super(rowLock.context);
            }

            @Override
            public void release() {
                if (testStep == TestStep.INIT) {
                    super.release();
                    return;
                }
                if (testStep == TestStep.PUT_STARTED) {
                    try {
                        testStep = TestStep.PUT_COMPLETED;
                        super.release();
                        latch.await();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else if (testStep == TestStep.CHECKANDPUT_STARTED) {
                    super.release();
                }
            }
        }
    }

    private class CheckAndPutThread
    extends MultithreadedTestUtil.TestThread {
        private MockHRegion region;

        CheckAndPutThread(MultithreadedTestUtil.TestContext ctx, MockHRegion region) {
            super(ctx);
            this.region = region;
        }

        @Override
        public void doWork() throws Exception {
            Put[] puts = new Put[1];
            Put put = new Put(Bytes.toBytes("r1"));
            put.add(Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("11"));
            puts[0] = put;
            while (testStep != TestStep.PUT_COMPLETED) {
                Thread.sleep(100L);
            }
            testStep = TestStep.CHECKANDPUT_STARTED;
            this.region.checkAndMutate(Bytes.toBytes("r1"), Bytes.toBytes("f1"), Bytes.toBytes("q1"), CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("10")), put, true);
            testStep = TestStep.CHECKANDPUT_COMPLETED;
        }
    }

    private class PutThread
    extends MultithreadedTestUtil.TestThread {
        private MockHRegion region;

        PutThread(MultithreadedTestUtil.TestContext ctx, MockHRegion region) {
            super(ctx);
            this.region = region;
        }

        @Override
        public void doWork() throws Exception {
            Mutation[] puts = new Put[1];
            Put put = new Put(Bytes.toBytes("r1"));
            put.add(Bytes.toBytes("f1"), Bytes.toBytes("q1"), Bytes.toBytes("50"));
            puts[0] = put;
            testStep = TestStep.PUT_STARTED;
            this.region.batchMutate(puts);
        }
    }

    private static enum TestStep {
        INIT,
        PUT_STARTED,
        PUT_COMPLETED,
        CHECKANDPUT_STARTED,
        CHECKANDPUT_COMPLETED;

    }

    public static class AtomicOperation
    extends Thread {
        protected final HRegion region;
        protected final int numOps;
        protected final AtomicLong timeStamps;
        protected final AtomicInteger failures;
        protected final Random r = new Random();

        public AtomicOperation(HRegion region, int numOps, AtomicLong timeStamps, AtomicInteger failures) {
            this.region = region;
            this.numOps = numOps;
            this.timeStamps = timeStamps;
            this.failures = failures;
        }
    }

    public static class Incrementer
    extends Thread {
        private final HRegion region;
        private final int numIncrements;
        private final int amount;

        public Incrementer(HRegion region, int threadNumber, int amount, int numIncrements) {
            this.region = region;
            this.numIncrements = numIncrements;
            this.amount = amount;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numIncrements; ++i) {
                try {
                    Increment inc = new Increment(row);
                    inc.addColumn(HBaseTestingUtility.fam1, qual1, this.amount);
                    inc.addColumn(HBaseTestingUtility.fam1, qual2, this.amount * 2);
                    inc.addColumn(HBaseTestingUtility.fam2, qual3, this.amount * 3);
                    this.region.increment(inc);
                    Get g = new Get(row);
                    Result result = this.region.get(g);
                    Assert.assertEquals((long)(Bytes.toLong(result.getValue(HBaseTestingUtility.fam1, qual1)) * 2L), (long)Bytes.toLong(result.getValue(HBaseTestingUtility.fam1, qual2)));
                    Assert.assertEquals((long)(Bytes.toLong(result.getValue(HBaseTestingUtility.fam1, qual1)) * 3L), (long)Bytes.toLong(result.getValue(HBaseTestingUtility.fam2, qual3)));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

