/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestDefaultStoreEngine {
    @Test
    public void testCustomParts() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.defaultengine.compactor.class", DummyCompactor.class.getName());
        conf.set("hbase.hstore.defaultengine.compactionpolicy.class", DummyCompactionPolicy.class.getName());
        conf.set("hbase.hstore.defaultengine.storeflusher.class", DummyStoreFlusher.class.getName());
        Store mockStore = (Store)Mockito.mock(Store.class);
        StoreEngine<?, ?, ?, ?> se = StoreEngine.create(mockStore, conf, new KeyValue.KVComparator());
        Assert.assertTrue((boolean)(se instanceof DefaultStoreEngine));
        Assert.assertTrue((boolean)(se.getCompactionPolicy() instanceof DummyCompactionPolicy));
        Assert.assertTrue((boolean)(se.getStoreFlusher() instanceof DummyStoreFlusher));
        Assert.assertTrue((boolean)(se.getCompactor() instanceof DummyCompactor));
    }

    public static class DummyCompactionPolicy
    extends RatioBasedCompactionPolicy {
        public DummyCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
            super(conf, storeConfigInfo);
        }
    }

    public static class DummyCompactor
    extends DefaultCompactor {
        public DummyCompactor(Configuration conf, Store store) {
            super(conf, store);
        }
    }

    public static class DummyStoreFlusher
    extends DefaultStoreFlusher {
        public DummyStoreFlusher(Configuration conf, Store store) {
            super(conf, store);
        }
    }
}

