/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestEndToEndSplitTransaction {
    private static final Log LOG = LogFactory.getLog(TestEndToEndSplitTransaction.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 5);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMasterOpsWhileSplitting() throws Exception {
        TableName tableName = TableName.valueOf("TestSplit");
        byte[] familyName = Bytes.toBytes("fam");
        HTable ht = TEST_UTIL.createTable(tableName, familyName);
        TEST_UTIL.loadTable(ht, familyName, false);
        ht.close();
        HRegionServer server = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        byte[] firstRow = Bytes.toBytes("aaa");
        byte[] splitRow = Bytes.toBytes("lll");
        byte[] lastRow = Bytes.toBytes("zzz");
        HConnection con = HConnectionManager.getConnection(TEST_UTIL.getConfiguration());
        byte[] regionName = con.locateRegion(tableName, splitRow).getRegionInfo().getRegionName();
        HRegion region = server.getRegion(regionName);
        SplitTransaction split = new SplitTransaction(region, splitRow);
        split.prepare();
        PairOfSameType<HRegion> regions = split.createDaughters(server, server);
        Assert.assertFalse((boolean)this.test(con, tableName, firstRow, server));
        Assert.assertFalse((boolean)this.test(con, tableName, lastRow, server));
        split.openDaughters(server, null, regions.getFirst(), regions.getSecond());
        Assert.assertFalse((boolean)this.test(con, tableName, firstRow, server));
        Assert.assertFalse((boolean)this.test(con, tableName, lastRow, server));
        server.postOpenDeployTasks(regions.getSecond(), server.getCatalogTracker());
        server.addToOnlineRegions(regions.getSecond());
        Assert.assertFalse((boolean)this.test(con, tableName, firstRow, server));
        Assert.assertTrue((boolean)this.test(con, tableName, lastRow, server));
        server.postOpenDeployTasks(regions.getFirst(), server.getCatalogTracker());
        server.addToOnlineRegions(regions.getFirst());
        Assert.assertTrue((boolean)this.test(con, tableName, firstRow, server));
        Assert.assertTrue((boolean)this.test(con, tableName, lastRow, server));
        split.transitionZKNode(server, server, regions.getFirst(), regions.getSecond());
        Assert.assertTrue((boolean)this.test(con, tableName, firstRow, server));
        Assert.assertTrue((boolean)this.test(con, tableName, lastRow, server));
    }

    private boolean test(HConnection con, TableName tableName, byte[] row, HRegionServer server) {
        try {
            byte[] regionName = con.relocateRegion(tableName, row).getRegionInfo().getRegionName();
            ProtobufUtil.get(server, regionName, new Get(row));
            ClientProtos.ScanRequest scanRequest = RequestConverter.buildScanRequest(regionName, new Scan(row), 1, true);
            try {
                server.scan(new PayloadCarryingRpcController(), scanRequest);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }
        catch (IOException x) {
            return false;
        }
        return true;
    }

    @Test
    public void testFromClientSideWhileSplitting() throws Throwable {
        LOG.info("Starting testFromClientSideWhileSplitting");
        TableName TABLENAME = TableName.valueOf("testFromClientSideWhileSplitting");
        byte[] FAMILY = Bytes.toBytes("family");
        HTable table = TEST_UTIL.createTable(TABLENAME, FAMILY);
        StoppableImplementation stopper = new StoppableImplementation();
        RegionSplitter regionSplitter = new RegionSplitter(table);
        RegionChecker regionChecker = new RegionChecker(conf, stopper, TABLENAME);
        regionChecker.start();
        regionSplitter.start();
        regionSplitter.join();
        stopper.stop(null);
        if (regionChecker.ex != null) {
            throw regionChecker.ex;
        }
        if (regionSplitter.ex != null) {
            throw regionSplitter.ex;
        }
        regionChecker.verify();
    }

    public static void log(String msg) {
        LOG.info(msg);
    }

    public static void flushAndBlockUntilDone(HBaseAdmin admin, HRegionServer rs, byte[] regionName) throws IOException, InterruptedException {
        TestEndToEndSplitTransaction.log("flushing region: " + Bytes.toStringBinary(regionName));
        admin.flush(regionName);
        TestEndToEndSplitTransaction.log("blocking until flush is complete: " + Bytes.toStringBinary(regionName));
        Threads.sleepWithoutInterrupt(500L);
        while (rs.cacheFlusher.getFlushQueueSize() > 0) {
            Threads.sleep(50L);
        }
    }

    public static void compactAndBlockUntilDone(HBaseAdmin admin, HRegionServer rs, byte[] regionName) throws IOException, InterruptedException {
        TestEndToEndSplitTransaction.log("Compacting region: " + Bytes.toStringBinary(regionName));
        admin.majorCompact(regionName);
        TestEndToEndSplitTransaction.log("blocking until compaction is complete: " + Bytes.toStringBinary(regionName));
        Threads.sleepWithoutInterrupt(500L);
        while (rs.compactSplitThread.getCompactionQueueSize() > 0) {
            Threads.sleep(50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockUntilRegionSplit(Configuration conf, long timeout, byte[] regionName, boolean waitForDaughters) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        TestEndToEndSplitTransaction.log("blocking until region is split:" + Bytes.toStringBinary(regionName));
        HRegionInfo daughterA = null;
        HRegionInfo daughterB = null;
        HTable metaTable = new HTable(conf, TableName.META_TABLE_NAME);
        try {
            Result result;
            while (System.currentTimeMillis() - start < timeout && (result = TestEndToEndSplitTransaction.getRegionRow(metaTable, regionName)) != null) {
                HRegionInfo region = HRegionInfo.getHRegionInfo(result);
                if (region.isSplitParent()) {
                    TestEndToEndSplitTransaction.log("found parent region: " + region.toString());
                    PairOfSameType<HRegionInfo> pair = HRegionInfo.getDaughterRegions(result);
                    daughterA = pair.getFirst();
                    daughterB = pair.getSecond();
                    break;
                }
                Threads.sleep(100L);
            }
            if (waitForDaughters) {
                long rem = timeout - (System.currentTimeMillis() - start);
                TestEndToEndSplitTransaction.blockUntilRegionIsInMeta(metaTable, rem, daughterA);
                rem = timeout - (System.currentTimeMillis() - start);
                TestEndToEndSplitTransaction.blockUntilRegionIsInMeta(metaTable, rem, daughterB);
                rem = timeout - (System.currentTimeMillis() - start);
                TestEndToEndSplitTransaction.blockUntilRegionIsOpened(conf, rem, daughterA);
                rem = timeout - (System.currentTimeMillis() - start);
                TestEndToEndSplitTransaction.blockUntilRegionIsOpened(conf, rem, daughterB);
            }
        }
        finally {
            IOUtils.closeQuietly(metaTable);
        }
    }

    public static Result getRegionRow(HTable metaTable, byte[] regionName) throws IOException {
        Get get = new Get(regionName);
        return metaTable.get(get);
    }

    public static void blockUntilRegionIsInMeta(HTable metaTable, long timeout, HRegionInfo hri) throws IOException, InterruptedException {
        TestEndToEndSplitTransaction.log("blocking until region is in META: " + hri.getRegionNameAsString());
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            HRegionInfo info;
            Result result = TestEndToEndSplitTransaction.getRegionRow(metaTable, hri.getRegionName());
            if (result != null && (info = HRegionInfo.getHRegionInfo(result)) != null && !info.isOffline()) {
                TestEndToEndSplitTransaction.log("found region in META: " + hri.getRegionNameAsString());
                break;
            }
            Threads.sleep(10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockUntilRegionIsOpened(Configuration conf, long timeout, HRegionInfo hri) throws IOException, InterruptedException {
        TestEndToEndSplitTransaction.log("blocking until region is opened for reading:" + hri.getRegionNameAsString());
        long start = System.currentTimeMillis();
        HTable table = new HTable(conf, hri.getTable());
        try {
            byte[] row = hri.getStartKey();
            if (row == null || row.length <= 0) {
                row = new byte[]{48};
            }
            Get get = new Get(row);
            while (System.currentTimeMillis() - start < timeout) {
                try {
                    table.get(get);
                    break;
                }
                catch (IOException ex) {
                    Threads.sleep(10L);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(table);
        }
    }

    static class RegionChecker
    extends Chore {
        Configuration conf;
        TableName tableName;
        Throwable ex;

        RegionChecker(Configuration conf, Stoppable stopper, TableName tableName) {
            super("RegionChecker", 10, stopper);
            this.conf = conf;
            this.tableName = tableName;
            this.setDaemon(true);
        }

        void verifyRegionsUsingMetaScanner() throws Exception {
            NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(this.conf, null, this.tableName, false);
            this.verifyTableRegions(regions.keySet());
            List<HRegionInfo> regionList = MetaScanner.listAllRegions(this.conf, false);
            this.verifyTableRegions(Sets.newTreeSet(regionList));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void verifyRegionsUsingHTable() throws IOException {
            HTable table = null;
            try {
                table = new HTable(this.conf, this.tableName);
                Pair<byte[][], byte[][]> keys = table.getStartEndKeys();
                this.verifyStartEndKeys(keys);
                NavigableMap<HRegionInfo, ServerName> regions = table.getRegionLocations();
                this.verifyTableRegions(regions.keySet());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(table);
                throw throwable;
            }
            IOUtils.closeQuietly(table);
        }

        void verify() throws Exception {
            this.verifyRegionsUsingMetaScanner();
            this.verifyRegionsUsingHTable();
        }

        void verifyTableRegions(Set<HRegionInfo> regions) {
            TestEndToEndSplitTransaction.log("Verifying " + regions.size() + " regions");
            byte[][] startKeys = new byte[regions.size()][];
            byte[][] endKeys = new byte[regions.size()][];
            int i = 0;
            for (HRegionInfo region : regions) {
                startKeys[i] = region.getStartKey();
                endKeys[i] = region.getEndKey();
                ++i;
            }
            Pair<byte[][], byte[][]> keys = new Pair<byte[][], byte[][]>(startKeys, endKeys);
            this.verifyStartEndKeys(keys);
        }

        void verifyStartEndKeys(Pair<byte[][], byte[][]> keys) {
            byte[][] startKeys = keys.getFirst();
            byte[][] endKeys = keys.getSecond();
            Assert.assertEquals((long)startKeys.length, (long)endKeys.length);
            Assert.assertTrue((String)"Found 0 regions for the table", (startKeys.length > 0 ? 1 : 0) != 0);
            Assert.assertArrayEquals((String)"Start key for the first region is not byte[0]", (byte[])HConstants.EMPTY_START_ROW, (byte[])startKeys[0]);
            byte[] prevEndKey = HConstants.EMPTY_START_ROW;
            for (int i = 0; i < startKeys.length; ++i) {
                Assert.assertArrayEquals((String)("Hole in hbase:meta is detected. prevEndKey=" + Bytes.toStringBinary(prevEndKey) + " ,regionStartKey=" + Bytes.toStringBinary(startKeys[i])), (byte[])prevEndKey, (byte[])startKeys[i]);
                prevEndKey = endKeys[i];
            }
            Assert.assertArrayEquals((String)"End key for the last region is not byte[0]", (byte[])HConstants.EMPTY_END_ROW, (byte[])endKeys[endKeys.length - 1]);
        }

        @Override
        protected void chore() {
            try {
                this.verify();
            }
            catch (Throwable ex) {
                this.ex = ex;
                this.stopper.stop("caught exception");
            }
        }
    }

    static class RegionSplitter
    extends Thread {
        Throwable ex;
        HTable table;
        TableName tableName;
        byte[] family;
        HBaseAdmin admin;
        HRegionServer rs;

        RegionSplitter(HTable table) throws IOException {
            this.table = table;
            this.tableName = table.getName();
            this.family = table.getTableDescriptor().getFamiliesKeys().iterator().next();
            this.admin = TEST_UTIL.getHBaseAdmin();
            this.rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        }

        @Override
        public void run() {
            try {
                Random random = new Random();
                for (int i = 0; i < 5; ++i) {
                    NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(conf, null, this.tableName, false);
                    if (regions.size() == 0) continue;
                    int regionIndex = random.nextInt(regions.size());
                    HRegionInfo region = (HRegionInfo)Iterators.get(regions.keySet().iterator(), regionIndex);
                    int start = 0;
                    int end = Integer.MAX_VALUE;
                    if (region.getStartKey().length > 0) {
                        start = Bytes.toInt(region.getStartKey());
                    }
                    if (region.getEndKey().length > 0) {
                        end = Bytes.toInt(region.getEndKey());
                    }
                    int mid = start + (end - start) / 2;
                    byte[] splitPoint = Bytes.toBytes(mid);
                    this.addData(start);
                    this.addData(mid);
                    TestEndToEndSplitTransaction.flushAndBlockUntilDone(this.admin, this.rs, region.getRegionName());
                    TestEndToEndSplitTransaction.compactAndBlockUntilDone(this.admin, this.rs, region.getRegionName());
                    TestEndToEndSplitTransaction.log("Initiating region split for:" + region.getRegionNameAsString());
                    try {
                        this.admin.split(region.getRegionName(), splitPoint);
                        TestEndToEndSplitTransaction.blockUntilRegionSplit(conf, 50000L, region.getRegionName(), true);
                        continue;
                    }
                    catch (NotServingRegionException ex) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable ex) {
                this.ex = ex;
            }
        }

        void addData(int start) throws IOException {
            for (int i = start; i < start + 100; ++i) {
                Put put = new Put(Bytes.toBytes(i));
                put.add(this.family, this.family, Bytes.toBytes(i));
                this.table.put(put);
            }
            this.table.flushCommits();
        }
    }
}

