/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHRegionFileSystem {
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestHRegionFileSystem.class);

    @Test
    public void testOnDiskRegionCreation() throws IOException {
        Path rootDir = TEST_UTIL.getDataTestDirOnTestFS("testOnDiskRegionCreation");
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HRegionInfo hri = new HRegionInfo(TableName.valueOf("TestTable"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem(conf, fs, FSUtils.getTableDir(rootDir, hri.getTable()), hri);
        Path regionDir = regionFs.getRegionDir();
        Assert.assertTrue((String)"The region folder should be created", (boolean)fs.exists(regionDir));
        HRegionInfo hriVerify = HRegionFileSystem.loadRegionInfoFileContent(fs, regionDir);
        Assert.assertEquals((Object)hri, (Object)hriVerify);
        regionFs = HRegionFileSystem.openRegionFromFileSystem(conf, fs, FSUtils.getTableDir(rootDir, hri.getTable()), hri, false);
        Assert.assertEquals((Object)regionDir, (Object)regionFs.getRegionDir());
        HRegionFileSystem.deleteRegionFromFileSystem(conf, fs, FSUtils.getTableDir(rootDir, hri.getTable()), hri);
        Assert.assertFalse((String)"The region folder should be removed", (boolean)fs.exists(regionDir));
        fs.delete(rootDir, true);
    }

    @Test
    public void testNonIdempotentOpsWithRetries() throws IOException {
        Path rootDir = TEST_UTIL.getDataTestDirOnTestFS("testOnDiskRegionCreation");
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        HRegionInfo hri = new HRegionInfo(TableName.valueOf("TestTable"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem(conf, fs, rootDir, hri);
        Assert.assertTrue((boolean)fs.exists(regionFs.getRegionDir()));
        regionFs = new HRegionFileSystem(conf, new MockFileSystemForCreate(), null, null);
        boolean result = regionFs.createDir(new Path("/foo/bar"));
        Assert.assertTrue((String)"Couldn't create the directory", (boolean)result);
        regionFs = new HRegionFileSystem(conf, new MockFileSystem(), null, null);
        result = regionFs.rename(new Path("/foo/bar"), new Path("/foo/bar2"));
        Assert.assertTrue((String)"Couldn't rename the directory", (boolean)result);
        regionFs = new HRegionFileSystem(conf, new MockFileSystem(), null, null);
        result = regionFs.deleteDir(new Path("/foo/bar"));
        Assert.assertTrue((String)"Couldn't delete the directory", (boolean)result);
        fs.delete(rootDir, true);
    }

    @Test
    public void testTempAndCommit() throws IOException {
        Path rootDir = TEST_UTIL.getDataTestDirOnTestFS("testTempAndCommit");
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        String familyName = "cf";
        HRegionInfo hri = new HRegionInfo(TableName.valueOf("TestTable"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem(conf, fs, rootDir, hri);
        Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(familyName);
        Assert.assertEquals((long)0L, (long)(storeFiles != null ? (long)storeFiles.size() : 0L));
        Path buildPath = regionFs.createTempName();
        fs.createNewFile(buildPath);
        storeFiles = regionFs.getStoreFiles(familyName);
        Assert.assertEquals((long)0L, (long)(storeFiles != null ? (long)storeFiles.size() : 0L));
        Path dstPath = regionFs.commitStoreFile(familyName, buildPath);
        storeFiles = regionFs.getStoreFiles(familyName);
        Assert.assertEquals((long)0L, (long)(storeFiles != null ? (long)storeFiles.size() : 0L));
        Assert.assertFalse((boolean)fs.exists(buildPath));
        fs.delete(rootDir, true);
    }

    static class MockFileSystem
    extends FileSystem {
        int retryCount = 0;
        static final int successRetryCount = 3;

        @Override
        public FSDataOutputStream append(Path arg0, int arg1, Progressable arg2) throws IOException {
            throw new IOException("");
        }

        @Override
        public FSDataOutputStream create(Path arg0, FsPermission arg1, boolean arg2, int arg3, short arg4, long arg5, Progressable arg6) throws IOException {
            LOG.debug("Create, " + this.retryCount);
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return null;
        }

        @Override
        public boolean delete(Path arg0) throws IOException {
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return true;
        }

        @Override
        public boolean delete(Path arg0, boolean arg1) throws IOException {
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return true;
        }

        @Override
        public FileStatus getFileStatus(Path arg0) throws IOException {
            FileStatus fs = new FileStatus();
            return fs;
        }

        @Override
        public boolean exists(Path path) {
            return true;
        }

        @Override
        public URI getUri() {
            throw new RuntimeException("Something bad happen");
        }

        @Override
        public Path getWorkingDirectory() {
            throw new RuntimeException("Something bad happen");
        }

        @Override
        public FileStatus[] listStatus(Path arg0) throws IOException {
            throw new IOException("Something bad happen");
        }

        @Override
        public boolean mkdirs(Path arg0, FsPermission arg1) throws IOException {
            LOG.debug("mkdirs, " + this.retryCount);
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return true;
        }

        @Override
        public FSDataInputStream open(Path arg0, int arg1) throws IOException {
            throw new IOException("Something bad happen");
        }

        @Override
        public boolean rename(Path arg0, Path arg1) throws IOException {
            LOG.debug("rename, " + this.retryCount);
            if (this.retryCount++ < 3) {
                throw new IOException("Something bad happen");
            }
            return true;
        }

        @Override
        public void setWorkingDirectory(Path arg0) {
            throw new RuntimeException("Something bad happen");
        }
    }

    static class MockFileSystemForCreate
    extends MockFileSystem {
        MockFileSystemForCreate() {
        }

        @Override
        public boolean exists(Path path) {
            return false;
        }
    }
}

