/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHRegionInfo {
    @Test
    public void testPb() throws DeserializationException {
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        byte[] bytes = hri.toByteArray();
        HRegionInfo pbhri = HRegionInfo.parseFrom(bytes);
        Assert.assertTrue((boolean)hri.equals(pbhri));
    }

    @Test
    public void testReadAndWriteHRegionInfoFile() throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        Path basedir = htu.getDataTestDir();
        HRegion r = HRegion.createHRegion(hri, basedir, htu.getConfiguration(), HTableDescriptor.META_TABLEDESC);
        long modtime = this.getModTime(r);
        HRegion.closeHRegion(r);
        Thread.sleep(1001L);
        r = HRegion.openHRegion(basedir, hri, HTableDescriptor.META_TABLEDESC, null, htu.getConfiguration());
        long modtime2 = this.getModTime(r);
        Assert.assertEquals((long)modtime, (long)modtime2);
        HRegionInfo deserializedHri = HRegionFileSystem.loadRegionInfoFileContent(r.getRegionFileSystem().getFileSystem(), r.getRegionFileSystem().getRegionDir());
        Assert.assertTrue((boolean)hri.equals(deserializedHri));
    }

    long getModTime(HRegion r) throws IOException {
        FileStatus[] statuses = r.getRegionFileSystem().getFileSystem().listStatus(new Path(r.getRegionFileSystem().getRegionDir(), ".regioninfo"));
        Assert.assertTrue((statuses != null && statuses.length == 1 ? 1 : 0) != 0);
        return statuses[0].getModificationTime();
    }

    @Test
    public void testCreateHRegionInfoName() throws Exception {
        String tableName = "tablename";
        TableName tn = TableName.valueOf(tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes(startKey);
        String id = "id";
        byte[] name = HRegionInfo.createRegionName(tn, sk, id, false);
        String nameStr = Bytes.toString(name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        String md5HashInHex = MD5Hash.getMD5AsHex(name);
        Assert.assertEquals((long)32L, (long)md5HashInHex.length());
        name = HRegionInfo.createRegionName(tn, sk, id, true);
        nameStr = Bytes.toString(name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "." + md5HashInHex + "."), (Object)nameStr);
    }

    @Test
    public void testContainsRange() {
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf("testtable"));
        HRegionInfo hri = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes("a"), Bytes.toBytes("g"));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes("a"), Bytes.toBytes("a")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes("b"), Bytes.toBytes("c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes("a"), Bytes.toBytes("c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes("c"), Bytes.toBytes("c")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes("a"), Bytes.toBytes("g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes("g"), Bytes.toBytes("g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes("z"), Bytes.toBytes("z")));
        try {
            hri.containsRange(Bytes.toBytes("z"), Bytes.toBytes("a"));
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLastRegionCompare() {
        HRegionInfo hric;
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf("testtable"));
        HRegionInfo hrip = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes("a"), new byte[0]);
        Assert.assertTrue((hrip.compareTo(hric = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes("a"), Bytes.toBytes("b"))) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaTables() {
        Assert.assertTrue((boolean)HRegionInfo.FIRST_META_REGIONINFO.isMetaTable());
    }

    @Test
    public void testComparator() {
        HRegionInfo newer;
        byte[] empty;
        TableName tablename = TableName.valueOf("comparatorTablename");
        HRegionInfo older = new HRegionInfo(tablename, empty = new byte[0], empty, false, 0L);
        Assert.assertTrue((older.compareTo(newer = new HRegionInfo(tablename, empty, empty, false, 1L)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((newer.compareTo(older) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((older.compareTo(older) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((newer.compareTo(newer) == 0 ? 1 : 0) != 0);
    }
}

