/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mortbay.log.Log;

@Category(value={MediumTests.class})
public class TestHRegionOnCluster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDataCorrectnessReplayingRecoveredEdits() throws Exception {
        boolean NUM_MASTERS = true;
        int NUM_RS = 3;
        TEST_UTIL.startMiniCluster(1, 3);
        try {
            byte[] TABLENAME = Bytes.toBytes("testDataCorrectnessReplayingRecoveredEdits");
            byte[] FAMILY = Bytes.toBytes("family");
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            HMaster master = cluster.getMaster();
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(TABLENAME));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            HBaseAdmin hbaseAdmin = TEST_UTIL.getHBaseAdmin();
            hbaseAdmin.createTable(desc);
            Assert.assertTrue((boolean)hbaseAdmin.isTableAvailable(TABLENAME));
            Log.info((String)("Loading r1 to v1 into " + Bytes.toString(TABLENAME)));
            HTable table = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
            this.putDataAndVerify(table, "r1", FAMILY, "v1", 1);
            TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
            HRegionInfo regionInfo = table.getRegionLocation("r1").getRegionInfo();
            int originServerNum = cluster.getServerWith(regionInfo.getRegionName());
            HRegionServer originServer = cluster.getRegionServer(originServerNum);
            int targetServerNum = (originServerNum + 1) % 3;
            HRegionServer targetServer = cluster.getRegionServer(targetServerNum);
            Assert.assertFalse((boolean)originServer.equals(targetServer));
            TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
            Log.info((String)("Moving " + regionInfo.getEncodedName() + " to " + targetServer.getServerName()));
            hbaseAdmin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes(targetServer.getServerName().getServerName()));
            do {
                Thread.sleep(1L);
            } while (cluster.getServerWith(regionInfo.getRegionName()) == originServerNum);
            Log.info((String)("Loading r2 to v2 into " + Bytes.toString(TABLENAME)));
            this.putDataAndVerify(table, "r2", FAMILY, "v2", 2);
            TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
            Log.info((String)("Moving " + regionInfo.getEncodedName() + " to " + originServer.getServerName()));
            hbaseAdmin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes(originServer.getServerName().getServerName()));
            do {
                Thread.sleep(1L);
            } while (cluster.getServerWith(regionInfo.getRegionName()) == targetServerNum);
            Log.info((String)("Loading r3 to v3 into " + Bytes.toString(TABLENAME)));
            this.putDataAndVerify(table, "r3", FAMILY, "v3", 3);
            Log.info((String)("Killing target server " + targetServer.getServerName()));
            targetServer.kill();
            cluster.getRegionServerThreads().get(targetServerNum).join();
            while (master.getServerManager().areDeadServersInProgress()) {
                Thread.sleep(5L);
            }
            Log.info((String)("Killing origin server " + targetServer.getServerName()));
            originServer.kill();
            cluster.getRegionServerThreads().get(originServerNum).join();
            Log.info((String)("Loading r4 to v4 into " + Bytes.toString(TABLENAME)));
            this.putDataAndVerify(table, "r4", FAMILY, "v4", 4);
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    private void putDataAndVerify(HTable table, String row, byte[] family, String value, int verifyNum) throws IOException {
        Result r;
        System.out.println("=========Putting data :" + row);
        Put put = new Put(Bytes.toBytes(row));
        put.add(family, Bytes.toBytes("q1"), Bytes.toBytes(value));
        table.put(put);
        ResultScanner resultScanner = table.getScanner(new Scan());
        ArrayList<Result> results = new ArrayList<Result>();
        while ((r = resultScanner.next()) != null) {
            results.add(r);
        }
        resultScanner.close();
        if (results.size() != verifyNum) {
            System.out.println(results);
        }
        Assert.assertEquals((long)verifyNum, (long)results.size());
    }
}

