/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyValueHeap
extends HBaseTestCase {
    private static final boolean PRINT = false;
    List<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
    private byte[] row1;
    private byte[] fam1;
    private byte[] col1;
    private byte[] data;
    private byte[] row2;
    private byte[] fam2;
    private byte[] col2;
    private byte[] col3;
    private byte[] col4;
    private byte[] col5;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.data = Bytes.toBytes("data");
        this.row1 = Bytes.toBytes("row1");
        this.fam1 = Bytes.toBytes("fam1");
        this.col1 = Bytes.toBytes("col1");
        this.row2 = Bytes.toBytes("row2");
        this.fam2 = Bytes.toBytes("fam2");
        this.col2 = Bytes.toBytes("col2");
        this.col3 = Bytes.toBytes("col3");
        this.col4 = Bytes.toBytes("col4");
        this.col5 = Bytes.toBytes("col5");
    }

    public void testSorted() throws IOException {
        int i;
        ArrayList<KeyValue> l1 = new ArrayList<KeyValue>();
        l1.add(new KeyValue(this.row1, this.fam1, this.col5, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l1));
        ArrayList<KeyValue> l2 = new ArrayList<KeyValue>();
        l2.add(new KeyValue(this.row1, this.fam1, this.col1, this.data));
        l2.add(new KeyValue(this.row1, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l2));
        ArrayList<KeyValue> l3 = new ArrayList<KeyValue>();
        l3.add(new KeyValue(this.row1, this.fam1, this.col3, this.data));
        l3.add(new KeyValue(this.row1, this.fam1, this.col4, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        l3.add(new KeyValue(this.row2, this.fam1, this.col3, this.data));
        this.scanners.add(new Scanner(l3));
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue(this.row1, this.fam1, this.col1, this.data));
        expected.add(new KeyValue(this.row1, this.fam1, this.col2, this.data));
        expected.add(new KeyValue(this.row1, this.fam1, this.col3, this.data));
        expected.add(new KeyValue(this.row1, this.fam1, this.col4, this.data));
        expected.add(new KeyValue(this.row1, this.fam1, this.col5, this.data));
        expected.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        expected.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        expected.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        expected.add(new KeyValue(this.row2, this.fam1, this.col2, this.data));
        expected.add(new KeyValue(this.row2, this.fam1, this.col3, this.data));
        KeyValueHeap kvh = new KeyValueHeap(this.scanners, KeyValue.COMPARATOR);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        while (kvh.peek() != null) {
            actual.add(kvh.next());
        }
        TestKeyValueHeap.assertEquals((int)expected.size(), (int)actual.size());
        for (i = 0; i < expected.size(); ++i) {
            TestKeyValueHeap.assertEquals(expected.get(i), actual.get(i));
        }
        for (i = 0; i < actual.size() - 1; ++i) {
            int ret = KeyValue.COMPARATOR.compare((Cell)actual.get(i), (Cell)actual.get(i + 1));
            TestKeyValueHeap.assertTrue((ret < 0 ? 1 : 0) != 0);
        }
    }

    public void testSeek() throws IOException {
        ArrayList<KeyValue> l1 = new ArrayList<KeyValue>();
        l1.add(new KeyValue(this.row1, this.fam1, this.col5, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l1));
        ArrayList<KeyValue> l2 = new ArrayList<KeyValue>();
        l2.add(new KeyValue(this.row1, this.fam1, this.col1, this.data));
        l2.add(new KeyValue(this.row1, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l2));
        ArrayList<KeyValue> l3 = new ArrayList<KeyValue>();
        l3.add(new KeyValue(this.row1, this.fam1, this.col3, this.data));
        l3.add(new KeyValue(this.row1, this.fam1, this.col4, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        l3.add(new KeyValue(this.row2, this.fam1, this.col3, this.data));
        this.scanners.add(new Scanner(l3));
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        KeyValueHeap kvh = new KeyValueHeap(this.scanners, KeyValue.COMPARATOR);
        KeyValue seekKv = new KeyValue(this.row2, this.fam1, null, null);
        kvh.seek(seekKv);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        actual.add(kvh.peek());
        TestKeyValueHeap.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestKeyValueHeap.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScannerLeak() throws IOException {
        ArrayList<KeyValue> l1 = new ArrayList<KeyValue>();
        l1.add(new KeyValue(this.row1, this.fam1, this.col5, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        l1.add(new KeyValue(this.row2, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l1));
        ArrayList<KeyValue> l2 = new ArrayList<KeyValue>();
        l2.add(new KeyValue(this.row1, this.fam1, this.col1, this.data));
        l2.add(new KeyValue(this.row1, this.fam1, this.col2, this.data));
        this.scanners.add(new Scanner(l2));
        ArrayList<KeyValue> l3 = new ArrayList<KeyValue>();
        l3.add(new KeyValue(this.row1, this.fam1, this.col3, this.data));
        l3.add(new KeyValue(this.row1, this.fam1, this.col4, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col1, this.data));
        l3.add(new KeyValue(this.row1, this.fam2, this.col2, this.data));
        l3.add(new KeyValue(this.row2, this.fam1, this.col3, this.data));
        this.scanners.add(new Scanner(l3));
        ArrayList<KeyValue> l4 = new ArrayList<KeyValue>();
        this.scanners.add(new Scanner(l4));
        KeyValueHeap kvh = new KeyValueHeap(this.scanners, KeyValue.COMPARATOR);
        while (kvh.next() != null) {
        }
        for (KeyValueScanner scanner : this.scanners) {
            TestKeyValueHeap.assertTrue((boolean)((Scanner)scanner).isClosed());
        }
    }

    private static class Scanner
    extends CollectionBackedScanner {
        private Iterator<KeyValue> iter;
        private KeyValue current;
        private boolean closed = false;

        public Scanner(List<KeyValue> list) {
            super(list);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

