/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Message;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestQosFunction {
    @Test
    public void testPriority() {
        HRegionServer hrs = (HRegionServer)Mockito.mock(HRegionServer.class);
        AnnotationReadingPriorityFunction qosFunction = new AnnotationReadingPriorityFunction(hrs);
        this.checkMethod("ReplicateWALEntry", 5, qosFunction);
        this.checkMethod("OpenRegion", 100, qosFunction);
        this.checkMethod("Multi", 0, qosFunction, ClientProtos.MultiRequest.getDefaultInstance());
    }

    private void checkMethod(String methodName, int expected, AnnotationReadingPriorityFunction qosf) {
        this.checkMethod(methodName, expected, qosf, null);
    }

    private void checkMethod(String methodName, int expected, AnnotationReadingPriorityFunction qosf, Message param) {
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        builder.setMethodName(methodName);
        Assert.assertEquals((String)methodName, (long)expected, (long)qosf.getPriority(builder.build(), param));
    }
}

