/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestQueryMatcher
extends HBaseTestCase {
    private static final boolean PRINT = false;
    private byte[] row1;
    private byte[] row2;
    private byte[] row3;
    private byte[] fam1;
    private byte[] fam2;
    private byte[] col1;
    private byte[] col2;
    private byte[] col3;
    private byte[] col4;
    private byte[] col5;
    private byte[] data;
    private Get get;
    long ttl = Long.MAX_VALUE;
    KeyValue.KVComparator rowComparator;
    private Scan scan;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.row1 = Bytes.toBytes("row1");
        this.row2 = Bytes.toBytes("row2");
        this.row3 = Bytes.toBytes("row3");
        this.fam1 = Bytes.toBytes("fam1");
        this.fam2 = Bytes.toBytes("fam2");
        this.col1 = Bytes.toBytes("col1");
        this.col2 = Bytes.toBytes("col2");
        this.col3 = Bytes.toBytes("col3");
        this.col4 = Bytes.toBytes("col4");
        this.col5 = Bytes.toBytes("col5");
        this.data = Bytes.toBytes("data");
        this.get = new Get(this.row1);
        this.get.addFamily(this.fam1);
        this.get.addColumn(this.fam2, this.col2);
        this.get.addColumn(this.fam2, this.col4);
        this.get.addColumn(this.fam2, this.col5);
        this.scan = new Scan(this.get);
        this.rowComparator = KeyValue.COMPARATOR;
    }

    private void _testMatch_ExplicitColumns(Scan scan, List<ScanQueryMatcher.MatchCode> expected) throws IOException {
        ScanQueryMatcher qm = new ScanQueryMatcher(scan, new ScanInfo(this.fam2, 0, 1, this.ttl, false, 0L, this.rowComparator), this.get.getFamilyMap().get(this.fam2), EnvironmentEdgeManager.currentTimeMillis() - this.ttl);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setRow(k.getBuffer(), k.getRowOffset(), k.getRowLength());
        for (KeyValue kv : memstore) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestQueryMatcher.assertEquals((Object)((Object)expected.get(i)), actual.get(i));
        }
    }

    public void testMatch_ExplicitColumns() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        this._testMatch_ExplicitColumns(this.scan, expected);
    }

    public void testMatch_ExplicitColumnsWithLookAhead() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.SKIP);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SKIP);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        Scan s = new Scan(this.scan);
        s.setAttribute("_look_ahead_", Bytes.toBytes(2));
        this._testMatch_ExplicitColumns(s, expected);
    }

    public void testMatch_Wildcard() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new ScanInfo(this.fam2, 0, 1, this.ttl, false, 0L, this.rowComparator), null, EnvironmentEdgeManager.currentTimeMillis() - this.ttl);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, 1L, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>();
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setRow(k.getBuffer(), k.getRowOffset(), k.getRowLength());
        for (KeyValue kv : memstore) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestQueryMatcher.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testMatch_ExpiredExplicit() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new ScanInfo(this.fam2, 0, 1, testTTL, false, 0L, this.rowComparator), this.get.getFamilyMap().get(this.fam2), now - testTTL);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setRow(k.getBuffer(), k.getRowOffset(), k.getRowLength());
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)((Object)expected[i]), actual.get(i));
        }
    }

    public void testMatch_ExpiredWildcard() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, new ScanInfo(this.fam2, 0, 1, testTTL, false, 0L, this.rowComparator), null, now - testTTL);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setRow(k.getBuffer(), k.getRowOffset(), k.getRowLength());
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match(kv));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)((Object)expected[i]), actual.get(i));
        }
    }

    public void testMatch_PartialRangeDropDeletes() throws Exception {
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row2, this.row2, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1, this.row2}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row2, this.row3, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row1, this.row3, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(HConstants.EMPTY_START_ROW, this.row3, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, HConstants.EMPTY_END_ROW, new byte[][]{this.row1, this.row2, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, new byte[][]{this.row1, this.row2, this.row3, this.row3}, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP, ScanQueryMatcher.MatchCode.SKIP);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row3, this.row3}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
        this.testDropDeletes(this.row2, this.row3, new byte[][]{this.row1, this.row1}, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE);
    }

    private void testDropDeletes(byte[] from, byte[] to, byte[][] rows, ScanQueryMatcher.MatchCode ... expected) throws IOException {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ScanInfo scanInfo = new ScanInfo(this.fam2, 0, 1, this.ttl, false, -1L, this.rowComparator);
        NavigableSet<byte[]> cols = this.get.getFamilyMap().get(this.fam2);
        ScanQueryMatcher qm = new ScanQueryMatcher(this.scan, scanInfo, cols, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, from, to);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(rows.length);
        byte[] prevRow = null;
        for (byte[] row : rows) {
            if (prevRow == null || !Bytes.equals(prevRow, row)) {
                qm.setRow(row, 0, (short)row.length);
                prevRow = row;
            }
            actual.add(qm.match(new KeyValue(row, this.fam2, null, now, KeyValue.Type.Delete)));
        }
        TestQueryMatcher.assertEquals((int)expected.length, (int)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            TestQueryMatcher.assertEquals((Object)((Object)expected[i]), actual.get(i));
        }
    }
}

