/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerMetrics {
    private static final Log LOG = LogFactory.getLog(TestRegionServerMetrics.class);
    private static MetricsAssertHelper metricsHelper;
    private static MiniHBaseCluster cluster;
    private static HRegionServer rs;
    private static Configuration conf;
    private static HBaseTestingUtility TEST_UTIL;
    private static MetricsRegionServer metricsRegionServer;
    private static MetricsRegionServerSource serverSource;

    @BeforeClass
    public static void startCluster() throws Exception {
        metricsHelper = CompatibilityFactory.getInstance(MetricsAssertHelper.class);
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        conf.getLong("hbase.splitlog.max.resubmit", 0L);
        conf.setInt("zookeeper.recovery.retry", 0);
        conf.setInt("hbase.regionserver.info.port", -1);
        TEST_UTIL.startMiniCluster(1, 1);
        cluster = TEST_UTIL.getHBaseCluster();
        cluster.waitForActiveAndReadyMaster();
        while (cluster.getLiveRegionServerThreads().size() < 1) {
            Threads.sleep(100L);
        }
        rs = cluster.getRegionServer(0);
        metricsRegionServer = rs.getMetrics();
        serverSource = metricsRegionServer.getMetricsSource();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test(timeout=300000L)
    public void testRegionCount() throws Exception {
        String regionMetricsKey = "regionCount";
        long regions = metricsHelper.getGaugeLong(regionMetricsKey, serverSource);
        TEST_UTIL.createTable(Bytes.toBytes("table"), Bytes.toBytes("cf"));
        metricsHelper.assertGaugeGt(regionMetricsKey, regions, (BaseSource)serverSource);
    }

    @Test
    public void testLocalFiles() throws Exception {
        metricsHelper.assertGauge("percentFilesLocal", 0L, (BaseSource)serverSource);
    }

    @Test
    public void testRequestCount() throws Exception {
        String tableNameString = "testRequestCount";
        byte[] tName = Bytes.toBytes(tableNameString);
        byte[] cfName = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] initValue = Bytes.toBytes("Value");
        byte[] nextValue = Bytes.toBytes("NEXT VAL");
        TEST_UTIL.createTable(tName, cfName);
        new HTable(conf, tName).close();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long requests = metricsHelper.getCounter("totalRequestCount", serverSource);
        long readRequests = metricsHelper.getCounter("readRequestCount", serverSource);
        long writeRequests = metricsHelper.getCounter("writeRequestCount", serverSource);
        HTable table = new HTable(conf, tName);
        Put p = new Put(row);
        p.add(cfName, qualifier, initValue);
        for (int i = 0; i < 30; ++i) {
            table.put(p);
        }
        table.flushCommits();
        Get g = new Get(row);
        for (int i = 0; i < 10; ++i) {
            table.get(g);
        }
        for (HRegionInfo i : table.getRegionLocations().keySet()) {
            MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
            String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
            metricsHelper.assertCounter(prefix + "_getNumOps", 10L, agg);
            metricsHelper.assertCounter(prefix + "_mutateCount", 30L, agg);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounterGt("totalRequestCount", requests + 39L, serverSource);
        metricsHelper.assertCounterGt("readRequestCount", readRequests + 9L, serverSource);
        metricsHelper.assertCounterGt("writeRequestCount", writeRequests + 29L, serverSource);
        table.close();
    }

    @Test
    public void testMutationsWithoutWal() throws Exception {
        byte[] tableName = Bytes.toBytes("testMutationsWithoutWal");
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("Value");
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        p.setDurability(Durability.SKIP_WAL);
        t.put(p);
        t.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertGauge("mutationsWithoutWALCount", 1L, (BaseSource)serverSource);
        long minLength = row.length + cf.length + qualifier.length + val.length;
        metricsHelper.assertGaugeGt("mutationsWithoutWALSize", minLength, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testStoreCount() throws Exception {
        byte[] tableName = Bytes.toBytes("testStoreCount");
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("Value");
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long stores = metricsHelper.getGaugeLong("storeCount", serverSource);
        long storeFiles = metricsHelper.getGaugeLong("storeFileCount", serverSource);
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        t.flushCommits();
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertGauge("storeCount", stores + 1L, (BaseSource)serverSource);
        metricsHelper.assertGauge("storeFileCount", storeFiles + 1L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testCheckAndPutCount() throws Exception {
        String tableNameString = "testCheckAndPutCount";
        byte[] tableName = Bytes.toBytes(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] valOne = Bytes.toBytes("Value");
        byte[] valTwo = Bytes.toBytes("ValueTwo");
        byte[] valThree = Bytes.toBytes("ValueThree");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, valOne);
        t.put(p);
        t.flushCommits();
        Put pTwo = new Put(row);
        pTwo.add(cf, qualifier, valTwo);
        t.checkAndPut(row, cf, qualifier, valOne, pTwo);
        t.flushCommits();
        Put pThree = new Put(row);
        pThree.add(cf, qualifier, valThree);
        t.checkAndPut(row, cf, qualifier, valOne, pThree);
        t.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("checkMutateFailedCount", 1L, serverSource);
        metricsHelper.assertCounter("checkMutatePassedCount", 1L, serverSource);
        t.close();
    }

    @Test
    public void testIncrement() throws Exception {
        String tableNameString = "testIncrement";
        byte[] tableName = Bytes.toBytes(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes(0L);
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        t.flushCommits();
        for (int count = 0; count < 13; ++count) {
            Increment inc = new Increment(row);
            inc.addColumn(cf, qualifier, 100L);
            t.increment(inc);
        }
        t.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("incrementNumOps", 13L, serverSource);
        t.close();
    }

    @Test
    public void testAppend() throws Exception {
        String tableNameString = "testAppend";
        byte[] tableName = Bytes.toBytes(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] row = Bytes.toBytes("rk");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("One");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        t.flushCommits();
        for (int count = 0; count < 73; ++count) {
            Append append = new Append(row);
            append.add(cf, qualifier, Bytes.toBytes(",Test"));
            t.append(append);
        }
        t.flushCommits();
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("appendNumOps", 73L, serverSource);
        t.close();
    }

    @Test
    public void testScanNext() throws IOException {
        String tableNameString = "testScanNext";
        byte[] tableName = Bytes.toBytes(tableNameString);
        byte[] cf = Bytes.toBytes("d");
        byte[] qualifier = Bytes.toBytes("qual");
        byte[] val = Bytes.toBytes("One");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        t.setAutoFlush(false, true);
        for (int insertCount = 0; insertCount < 100; ++insertCount) {
            Put p = new Put(Bytes.toBytes("" + insertCount + "row"));
            p.add(cf, qualifier, val);
            t.put(p);
        }
        t.flushCommits();
        Scan s = new Scan();
        s.setBatch(1);
        s.setCaching(1);
        ResultScanner resultScanners = t.getScanner(s);
        for (int nextCount = 0; nextCount < 30; ++nextCount) {
            Result result = resultScanners.next();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)1L, (long)result.size());
        }
        for (HRegionInfo i : t.getRegionLocations().keySet()) {
            MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
            String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
            metricsHelper.assertCounter(prefix + "_scanNextNumOps", 30L, agg);
        }
    }

    static {
        Logger.getLogger("org.apache.hadoop.hbase").setLevel(Level.DEBUG);
    }
}

