/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.DelimitedKeyPrefixRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.KeyPrefixRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionSplitPolicy {
    private Configuration conf;
    private HTableDescriptor htd;
    private HRegion mockRegion;
    private TreeMap<byte[], HStore> stores;
    private static final TableName TABLENAME = TableName.valueOf("t");

    @Before
    public void setupMocks() {
        this.conf = HBaseConfiguration.create();
        HRegionInfo hri = new HRegionInfo(TABLENAME);
        this.htd = new HTableDescriptor(TABLENAME);
        this.mockRegion = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)this.htd).when((Object)this.mockRegion)).getTableDesc();
        ((HRegion)Mockito.doReturn((Object)hri).when((Object)this.mockRegion)).getRegionInfo();
        this.stores = new TreeMap(Bytes.BYTES_COMPARATOR);
        ((HRegion)Mockito.doReturn(this.stores).when((Object)this.mockRegion)).getStores();
    }

    @Test
    public void testIncreasingToUpperBoundRegionSplitPolicy() throws IOException {
        this.conf.set("hbase.regionserver.region.split.policy", IncreasingToUpperBoundRegionSplitPolicy.class.getName());
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        ArrayList<HRegion> regions = new ArrayList<HRegion>();
        Mockito.when(rss.getOnlineRegions(TABLENAME)).thenReturn(regions);
        Mockito.when((Object)this.mockRegion.getRegionServerServices()).thenReturn((Object)rss);
        long maxSplitSize = 1024L;
        this.htd.setMaxFileSize(maxSplitSize);
        long flushSize = maxSplitSize / 8L;
        this.conf.setLong("hbase.hregion.memstore.flush.size", flushSize);
        this.htd.setMemStoreFlushSize(flushSize);
        IncreasingToUpperBoundRegionSplitPolicy policy = (IncreasingToUpperBoundRegionSplitPolicy)RegionSplitPolicy.create(this.mockRegion, this.conf);
        this.doConstantSizePolicyTests(policy);
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        this.stores.put(new byte[]{1}, mockStore);
        Assert.assertTrue((boolean)policy.shouldSplit());
        regions.add(this.mockRegion);
        ((HStore)Mockito.doReturn((Object)flushSize).when((Object)mockStore)).getSize();
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)(flushSize * 2L + 1L)).when((Object)mockStore)).getSize();
        Assert.assertTrue((boolean)policy.shouldSplit());
        regions.add(this.mockRegion);
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)(flushSize * 2L * 2L * 2L + 1L)).when((Object)mockStore)).getSize();
        Assert.assertTrue((boolean)policy.shouldSplit());
        Assert.assertEquals((long)maxSplitSize, (long)policy.getSizeToCheck(1000));
        Assert.assertEquals((long)maxSplitSize, (long)policy.getSizeToCheck(0));
    }

    @Test
    public void testCreateDefault() throws IOException {
        this.conf.setLong("hbase.hregion.max.filesize", 1234L);
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create(this.mockRegion, this.conf);
        Assert.assertEquals((long)1234L, (long)policy.getDesiredMaxFileSize());
        this.htd.setMaxFileSize(9999L);
        policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create(this.mockRegion, this.conf);
        Assert.assertEquals((long)9999L, (long)policy.getDesiredMaxFileSize());
    }

    @Test
    public void testCustomPolicy() throws IOException {
        HTableDescriptor myHtd = new HTableDescriptor();
        myHtd.setValue("SPLIT_POLICY", KeyPrefixRegionSplitPolicy.class.getName());
        myHtd.setValue("KeyPrefixRegionSplitPolicy.prefix_length", String.valueOf(2));
        HRegion myMockRegion = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)myHtd).when((Object)myMockRegion)).getTableDesc();
        ((HRegion)Mockito.doReturn(this.stores).when((Object)myMockRegion)).getStores();
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn((Object)Bytes.toBytes("abcd")).when((Object)mockStore)).getSplitPoint();
        this.stores.put(new byte[]{1}, mockStore);
        KeyPrefixRegionSplitPolicy policy = (KeyPrefixRegionSplitPolicy)RegionSplitPolicy.create(myMockRegion, this.conf);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString(policy.getSplitPoint()));
        ((HRegion)Mockito.doReturn((Object)true).when((Object)myMockRegion)).shouldForceSplit();
        ((HRegion)Mockito.doReturn((Object)Bytes.toBytes("efgh")).when((Object)myMockRegion)).getExplicitSplitPoint();
        policy = (KeyPrefixRegionSplitPolicy)RegionSplitPolicy.create(myMockRegion, this.conf);
        Assert.assertEquals((Object)"ef", (Object)Bytes.toString(policy.getSplitPoint()));
    }

    @Test
    public void testConstantSizePolicy() throws IOException {
        this.htd.setMaxFileSize(1024L);
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create(this.mockRegion, this.conf);
        this.doConstantSizePolicyTests(policy);
    }

    private void doConstantSizePolicyTests(ConstantSizeRegionSplitPolicy policy) {
        Assert.assertFalse((boolean)policy.shouldSplit());
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        this.stores.put(new byte[]{1}, mockStore);
        Assert.assertTrue((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)false).when((Object)mockStore)).canSplit();
        Assert.assertFalse((boolean)policy.shouldSplit());
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HRegion)Mockito.doReturn((Object)true).when((Object)this.mockRegion)).shouldForceSplit();
        ((HStore)Mockito.doReturn((Object)100L).when((Object)mockStore)).getSize();
        Assert.assertTrue((boolean)policy.shouldSplit());
        ((HRegion)Mockito.doReturn((Object)false).when((Object)this.mockRegion)).shouldForceSplit();
        Assert.assertFalse((boolean)policy.shouldSplit());
        this.stores.clear();
    }

    @Test
    public void testGetSplitPoint() throws IOException {
        ConstantSizeRegionSplitPolicy policy = (ConstantSizeRegionSplitPolicy)RegionSplitPolicy.create(this.mockRegion, this.conf);
        Assert.assertFalse((boolean)policy.shouldSplit());
        Assert.assertNull((Object)policy.getSplitPoint());
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn((Object)Bytes.toBytes("store 1 split")).when((Object)mockStore)).getSplitPoint();
        this.stores.put(new byte[]{1}, mockStore);
        Assert.assertEquals((Object)"store 1 split", (Object)Bytes.toString(policy.getSplitPoint()));
        HStore mockStore2 = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)4000L).when((Object)mockStore2)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore2)).canSplit();
        ((HStore)Mockito.doReturn((Object)Bytes.toBytes("store 2 split")).when((Object)mockStore2)).getSplitPoint();
        this.stores.put(new byte[]{2}, mockStore2);
        Assert.assertEquals((Object)"store 2 split", (Object)Bytes.toString(policy.getSplitPoint()));
    }

    @Test
    public void testDelimitedKeyPrefixRegionSplitPolicy() throws IOException {
        HTableDescriptor myHtd = new HTableDescriptor();
        myHtd.setValue("SPLIT_POLICY", DelimitedKeyPrefixRegionSplitPolicy.class.getName());
        myHtd.setValue("DelimitedKeyPrefixRegionSplitPolicy.delimiter", ",");
        HRegion myMockRegion = (HRegion)Mockito.mock(HRegion.class);
        ((HRegion)Mockito.doReturn((Object)myHtd).when((Object)myMockRegion)).getTableDesc();
        ((HRegion)Mockito.doReturn(this.stores).when((Object)myMockRegion)).getStores();
        HStore mockStore = (HStore)Mockito.mock(HStore.class);
        ((HStore)Mockito.doReturn((Object)2000L).when((Object)mockStore)).getSize();
        ((HStore)Mockito.doReturn((Object)true).when((Object)mockStore)).canSplit();
        ((HStore)Mockito.doReturn((Object)Bytes.toBytes("ab,cd")).when((Object)mockStore)).getSplitPoint();
        this.stores.put(new byte[]{1}, mockStore);
        DelimitedKeyPrefixRegionSplitPolicy policy = (DelimitedKeyPrefixRegionSplitPolicy)RegionSplitPolicy.create(myMockRegion, this.conf);
        Assert.assertEquals((Object)"ab", (Object)Bytes.toString(policy.getSplitPoint()));
        ((HRegion)Mockito.doReturn((Object)true).when((Object)myMockRegion)).shouldForceSplit();
        ((HRegion)Mockito.doReturn((Object)Bytes.toBytes("efg,h")).when((Object)myMockRegion)).getExplicitSplitPoint();
        policy = (DelimitedKeyPrefixRegionSplitPolicy)RegionSplitPolicy.create(myMockRegion, this.conf);
        Assert.assertEquals((Object)"efg", (Object)Bytes.toString(policy.getSplitPoint()));
        ((HRegion)Mockito.doReturn((Object)Bytes.toBytes("ijk")).when((Object)myMockRegion)).getExplicitSplitPoint();
        Assert.assertEquals((Object)"ijk", (Object)Bytes.toString(policy.getSplitPoint()));
    }
}

