/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSplitTransactionOnCluster {
    private static final Log LOG = LogFactory.getLog(TestSplitTransactionOnCluster.class);
    private HBaseAdmin admin = null;
    private MiniHBaseCluster cluster = null;
    private static final int NB_SERVERS = 3;
    private static CountDownLatch latch = new CountDownLatch(1);
    private static volatile boolean secondSplit = false;
    private static volatile boolean callRollBack = false;
    private static volatile boolean firstSplitCompleted = false;
    private static final HBaseTestingUtility TESTING_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void before() throws Exception {
        TESTING_UTIL.getConfiguration().setInt("hbase.balancer.period", 60000);
        TESTING_UTIL.getConfiguration().setInt("hbase.master.assignment.timeoutmonitor.timeout", 4000);
        TESTING_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void after() throws Exception {
        TESTING_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TESTING_UTIL.ensureSomeNonStoppedRegionServersAvailable(3);
        this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        this.cluster = TESTING_UTIL.getMiniHBaseCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.admin.close();
    }

    private HRegionInfo getAndCheckSingleTableRegion(List<HRegion> regions) {
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegionInfo hri = regions.get(0).getRegionInfo();
        return this.waitOnRIT(hri);
    }

    private HRegionInfo waitOnRIT(HRegionInfo hri) {
        while (TESTING_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionInTransition(hri)) {
            LOG.info("Waiting on region in transition: " + TESTING_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionTransitionState(hri));
            Threads.sleep(10L);
        }
        return hri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack() throws Exception {
        TableName tableName = TableName.valueOf("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack");
        try {
            HTable t = this.createTableAndWait(tableName.getName(), Bytes.toBytes("cf"));
            List<HRegion> regions = this.cluster.getRegions(tableName);
            HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            final HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName.getName(), this.admin, t);
            t.close();
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            final HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            new Thread(){

                @Override
                public void run() {
                    MockedSplitTransaction st = null;
                    st = new MockedSplitTransaction(region, Bytes.toBytes("row2"));
                    try {
                        st.prepare();
                        st.execute(regionServer, regionServer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            for (int i = 0; !callRollBack && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"Waited too long for rollback", (boolean)callRollBack);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes("row3"));
            try {
                secondSplit = true;
                region.initialize();
                st.prepare();
                st.execute(regionServer, regionServer);
            }
            catch (IOException e) {
                LOG.debug("Rollback started :" + e.getMessage());
                ((SplitTransaction)st).rollback(regionServer, regionServer);
            }
            for (int i = 0; !firstSplitCompleted && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((String)"fist split did not complete", (boolean)firstSplitCompleted);
            RegionStates regionStates = this.cluster.getMaster().getAssignmentManager().getRegionStates();
            Map<String, RegionState> rit = regionStates.getRegionsInTransition();
            for (int i = 0; rit.containsKey(hri.getTable()) && i < 100; ++i) {
                Thread.sleep(100L);
            }
            Assert.assertFalse((String)"region still in transition", (boolean)rit.containsKey(rit.containsKey(hri.getTable())));
            List<HRegion> onlineRegions = regionServer.getOnlineRegions(tableName);
            Assert.assertEquals((String)"The parent region should be splitted", (long)2L, (long)onlineRegions.size());
            List<HRegionInfo> regionsOfTable = this.cluster.getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(tableName);
            Assert.assertEquals((String)"No of regions in master", (long)2L, (long)regionsOfTable.size());
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            secondSplit = false;
            firstSplitCompleted = false;
            callRollBack = false;
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRITStateForRollback() throws Exception {
        TableName tableName = TableName.valueOf("testRITStateForRollback");
        try {
            HTable t = this.createTableAndWait(tableName.getName(), Bytes.toBytes("cf"));
            List<HRegion> regions = this.cluster.getRegions(tableName);
            final HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
            this.insertData(tableName.getName(), this.admin, t);
            t.close();
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            region.getCoprocessorHost().load(FailingSplitRegionObserver.class, 0x3FFFFFFF, region.getBaseConf());
            this.admin.split(region.getRegionName(), new byte[]{42});
            FailingSplitRegionObserver.latch.await();
            LOG.info("Waiting for region to come out of RIT");
            TESTING_UTIL.waitFor(60000L, 1000L, new Waiter.Predicate<Exception>(){

                @Override
                public boolean evaluate() throws Exception {
                    RegionStates regionStates = TestSplitTransactionOnCluster.this.cluster.getMaster().getAssignmentManager().getRegionStates();
                    Map<String, RegionState> rit = regionStates.getRegionsInTransition();
                    return !rit.containsKey(hri.getEncodedName());
                }
            });
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRSSplitEphemeralsDisappearButDaughtersAreOnlinedAfterShutdownHandling() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, DeserializationException, ServiceException {
        byte[] tableName = Bytes.toBytes("testRSSplitEphemeralsDisappearButDaughtersAreOnlinedAfterShutdownHandling");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions(server).size();
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = true;
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName(TESTING_UTIL.getZooKeeperWatcher(), hri.getEncodedName());
            RegionTransition rt = null;
            Stat stats = null;
            for (int i = 0; i < 100; ++i) {
                stats = TESTING_UTIL.getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false);
                rt = RegionTransition.parseFrom(ZKAssign.getData(TESTING_UTIL.getZooKeeperWatcher(), hri.getEncodedName()));
                if (rt.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT)) break;
                Thread.sleep(100L);
            }
            LOG.info("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats);
            Assert.assertTrue((rt != null && rt.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT) ? 1 : 0) != 0);
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion r : regions) {
                Assert.assertTrue((boolean)daughters.contains(r));
            }
            for (int i = 0; i < 100 && (stats = TESTING_UTIL.getZooKeeperWatcher().getRecoverableZooKeeper().exists(path, false)) != null; ++i) {
                Thread.sleep(100L);
            }
            LOG.info("EPHEMERAL NODE AFTER SERVER ABORT, path=" + path + ", stats=" + stats);
            Assert.assertTrue((stats == null ? 1 : 0) != 0);
        }
        finally {
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testExistingZnodeBlocksSplitAndWeRollback() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException {
        byte[] tableName = Bytes.toBytes("testExistingZnodeBlocksSplitAndWeRollback");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions(server).size();
            ServerName fakedServer = ServerName.valueOf("any.old.server", 1234, -1L);
            ZKAssign.createNodeClosing(TESTING_UTIL.getZooKeeperWatcher(), hri, fakedServer);
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            this.admin.split(hri.getRegionNameAsString());
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(100L);
                Assert.assertEquals((long)regionCount, (long)ProtobufUtil.getOnlineRegions(server).size());
            }
            ZKAssign.deleteClosingNode(TESTING_UTIL.getZooKeeperWatcher(), hri, fakedServer);
            this.split(hri, server, regionCount);
            this.checkAndGetDaughters(tableName);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testShutdownFixupWhenDaughterHasSplit() throws IOException, InterruptedException, ServiceException {
        byte[] tableName = Bytes.toBytes("testShutdownFixupWhenDaughterHasSplit");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = ProtobufUtil.getOnlineRegions(server).size();
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.checkAndGetDaughters(tableName);
            regionCount = ProtobufUtil.getOnlineRegions(server).size();
            HRegionInfo daughter = daughters.get(0).getRegionInfo();
            LOG.info("Daughter we are going to split: " + daughter);
            this.admin.compact(daughter.getRegionName());
            daughters = this.cluster.getRegions(tableName);
            HRegion daughterRegion = null;
            for (HRegion r : daughters) {
                if (!r.getRegionInfo().equals(daughter)) continue;
                daughterRegion = r;
                LOG.info("Found matching HRI: " + daughterRegion);
                break;
            }
            Assert.assertTrue((daughterRegion != null ? 1 : 0) != 0);
            for (int i = 0; i < 100 && daughterRegion.hasReferences(); ++i) {
                Threads.sleep(100L);
            }
            Assert.assertFalse((String)"Waiting for reference to be compacted", (boolean)daughterRegion.hasReferences());
            LOG.info("Daughter hri before split (has been compacted): " + daughter);
            this.split(daughter, server, regionCount);
            daughters = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info("Regions before crash: " + d);
            }
            this.cluster.abortRegionServer(tableRegionIndex);
            this.waitUntilRegionServerDead();
            this.awaitDaughters(tableName, daughters.size());
            regions = this.cluster.getRegions(tableName);
            for (HRegion d : daughters) {
                LOG.info("Regions after crash: " + d);
            }
            Assert.assertEquals((long)daughters.size(), (long)regions.size());
            for (HRegion r : regions) {
                LOG.info("Regions post crash " + r);
                Assert.assertTrue((String)("Missing region post crash " + r), (boolean)daughters.contains(r));
            }
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles() throws Exception {
        Configuration conf = TESTING_UTIL.getConfiguration();
        TableName userTableName = TableName.valueOf("testSplitShouldNotThrowNPEEvenARegionHasEmptySplitFiles");
        HTableDescriptor htd = new HTableDescriptor(userTableName);
        HColumnDescriptor hcd = new HColumnDescriptor("col");
        htd.addFamily(hcd);
        this.admin.createTable(htd);
        HTable table = new HTable(conf, userTableName);
        try {
            Put p;
            for (int i = 0; i <= 5; ++i) {
                String row = "row" + i;
                p = new Put(row.getBytes());
                String val = "Val" + i;
                p.add("col".getBytes(), "ql".getBytes(), val.getBytes());
                table.put(p);
                this.admin.flush(userTableName.getName());
                Delete d = new Delete(row.getBytes());
                table.delete(d);
                this.admin.flush(userTableName.getName());
            }
            this.admin.majorCompact(userTableName.getName());
            List<HRegionInfo> regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            HRegionInfo hRegionInfo = regionsOfTable.get(0);
            p = new Put("row6".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            p = new Put("row7".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            p = new Put("row8".getBytes());
            p.add("col".getBytes(), "ql".getBytes(), "val".getBytes());
            table.put(p);
            this.admin.flush(userTableName.getName());
            this.admin.split(hRegionInfo.getRegionName(), "row7".getBytes());
            regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            while (regionsOfTable.size() != 2) {
                Thread.sleep(2000L);
                regionsOfTable = TESTING_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsOfTable(userTableName);
            }
            Assert.assertEquals((long)2L, (long)regionsOfTable.size());
            Scan s = new Scan();
            ResultScanner scanner = table.getScanner(s);
            int mainTableCount = 0;
            Result rr = scanner.next();
            while (rr != null) {
                ++mainTableCount;
                rr = scanner.next();
            }
            Assert.assertEquals((long)3L, (long)mainTableCount);
        }
        finally {
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=400000L)
    public void testMasterRestartWhenSplittingIsPartial() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, DeserializationException, ServiceException {
        byte[] tableName = Bytes.toBytes("testMasterRestartWhenSplittingIsPartial");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(t.getConfiguration(), "testMasterRestartWhenSplittingIsPartial", new UselessTestAbortable());
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = true;
            this.admin.split(hri.getRegionNameAsString());
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName(zkw, hri.getEncodedName());
            Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
            LOG.info("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats);
            byte[] bytes = ZKAssign.getData(zkw, hri.getEncodedName());
            RegionTransition rtd = RegionTransition.parseFrom(bytes);
            Assert.assertTrue((rtd.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLIT) || rtd.getEventType().equals((Object)EventType.RS_ZK_REGION_SPLITTING) ? 1 : 0) != 0);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            ServerName regionServerOfRegion = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion != null ? 1 : 0) != 0);
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            String node = ZKAssign.getNodeName(zkw, hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch(zkw, node, stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch(zkw, node, stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Split parent should be in SPLIT state", (boolean)regionStates.isRegionInState(hri, RegionState.State.SPLIT));
            regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            AssignmentManager.TEST_SKIP_SPLIT_HANDLING = false;
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            zkw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMasterRestartAtRegionSplitPendingCatalogJanitor() throws IOException, InterruptedException, KeeperException.NodeExistsException, KeeperException, ServiceException {
        byte[] tableName = Bytes.toBytes("testMasterRestartAtRegionSplitPendingCatalogJanitor");
        HTable t = this.createTableAndWait(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(t.getConfiguration(), "testMasterRestartAtRegionSplitPendingCatalogJanitor", new UselessTestAbortable());
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY, false);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            this.admin.split(hri.getRegionNameAsString());
            this.checkAndGetDaughters(tableName);
            String path = ZKAssign.getNodeName(zkw, hri.getEncodedName());
            Stat stats = zkw.getRecoverableZooKeeper().exists(path, false);
            LOG.info("EPHEMERAL NODE BEFORE SERVER ABORT, path=" + path + ", stats=" + stats);
            String node = ZKAssign.getNodeName(zkw, hri.getEncodedName());
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch(zkw, node, stat);
            for (int i = 0; data != null && i < 60; ++i) {
                Thread.sleep(1000L);
                data = ZKUtil.getDataNoWatch(zkw, node, stat);
            }
            Assert.assertNull((String)("Waited too long for ZK node to be removed: " + node), (Object)data);
            MockMasterWithoutCatalogJanitor master = this.abortAndWaitForMaster();
            this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
            hri.setOffline(true);
            hri.setSplit(true);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            Assert.assertTrue((String)"Split parent should be in SPLIT state", (boolean)regionStates.isRegionInState(hri, RegionState.State.SPLIT));
            ServerName regionServerOfRegion = regionStates.getRegionServerOfRegion(hri);
            Assert.assertTrue((regionServerOfRegion == null ? 1 : 0) != 0);
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
            zkw.close();
        }
    }

    @Test
    public void testSplitBeforeSettingSplittingInZK() throws Exception, InterruptedException, KeeperException {
        this.testSplitBeforeSettingSplittingInZKInternals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTableExistsIfTheSpecifiedTableRegionIsSplitParent() throws Exception {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TESTING_UTIL);
        TableName tableName = TableName.valueOf("testTableExistsIfTheSpecifiedTableRegionIsSplitParent");
        HTable t = this.createTableAndWait(tableName.getName(), Bytes.toBytes("cf"));
        List<HRegion> regions = null;
        try {
            regions = this.cluster.getRegions(tableName);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            this.insertData(tableName.getName(), this.admin, t);
            this.admin.setBalancerRunning(false, true);
            this.cluster.getMaster().setCatalogJanitorEnabled(false);
            boolean tableExists = MetaReader.tableExists(regionServer.getCatalogTracker(), tableName);
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            SplitTransaction st = new SplitTransaction(region, Bytes.toBytes("row2"));
            try {
                st.prepare();
                st.createDaughters(regionServer, regionServer);
            }
            catch (IOException e) {
                // empty catch block
            }
            tableExists = MetaReader.tableExists(regionServer.getCatalogTracker(), tableName);
            Assert.assertEquals((String)"The specified table should present.", (Object)true, (Object)tableExists);
        }
        finally {
            if (regions != null) {
                String node = ZKAssign.getNodeName(zkw, regions.get(0).getRegionInfo().getEncodedName());
                ZKUtil.deleteNodeFailSilent(zkw, node);
            }
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
            t.close();
        }
    }

    private void insertData(byte[] tableName, HBaseAdmin admin, HTable t) throws IOException, InterruptedException {
        Put p = new Put(Bytes.toBytes("row1"));
        p.add(Bytes.toBytes("cf"), Bytes.toBytes("q1"), Bytes.toBytes("1"));
        t.put(p);
        p = new Put(Bytes.toBytes("row2"));
        p.add(Bytes.toBytes("cf"), Bytes.toBytes("q1"), Bytes.toBytes("2"));
        t.put(p);
        p = new Put(Bytes.toBytes("row3"));
        p.add(Bytes.toBytes("cf"), Bytes.toBytes("q1"), Bytes.toBytes("3"));
        t.put(p);
        p = new Put(Bytes.toBytes("row4"));
        p.add(Bytes.toBytes("cf"), Bytes.toBytes("q1"), Bytes.toBytes("4"));
        t.put(p);
        admin.flush(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitRegionWithNoStoreFiles() throws Exception {
        TableName tableName = TableName.valueOf("testSplitRegionWithNoStoreFiles");
        this.createTableAndWait(tableName.getName(), HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        HRegionInfo hri = this.getAndCheckSingleTableRegion(regions);
        this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
        HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
        this.admin.setBalancerRunning(false, true);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            this.printOutRegions(regionServer, "Initial regions: ");
            Configuration conf = this.cluster.getConfiguration();
            HBaseFsck.debugLsr(conf, new Path("/"));
            Path rootDir = FSUtils.getRootDir(conf);
            FileSystem fs = TESTING_UTIL.getDFSCluster().getFileSystem();
            Map<String, Path> storefiles = FSUtils.getTableStoreFilePathMap(null, fs, rootDir, tableName);
            Assert.assertEquals((String)("Expected nothing but found " + storefiles.toString()), (long)storefiles.size(), (long)0L);
            regions = this.cluster.getRegions(tableName);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes("row2"));
            try {
                st.prepare();
                st.execute(regionServer, regionServer);
            }
            catch (IOException e) {
                Assert.fail((String)"Split execution should have succeeded with no exceptions thrown");
            }
            List<HRegion> daughters = this.cluster.getRegions(tableName);
            Assert.assertTrue((daughters.size() == 2 ? 1 : 0) != 0);
            HBaseFsck.debugLsr(conf, new Path("/"));
            Map<String, Path> storefilesAfter = FSUtils.getTableStoreFilePathMap(null, fs, rootDir, tableName);
            Assert.assertEquals((String)("Expected nothing but found " + storefilesAfter.toString()), (long)storefilesAfter.size(), (long)0L);
            hri = region.getRegionInfo();
            AssignmentManager am = this.cluster.getMaster().getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            long start = EnvironmentEdgeManager.currentTimeMillis();
            while (!regionStates.isRegionInState(hri, RegionState.State.SPLIT)) {
                Assert.assertFalse((String)"Timed out in waiting split parent to be in state SPLIT", (EnvironmentEdgeManager.currentTimeMillis() - start > 60000L ? 1 : 0) != 0);
                Thread.sleep(500L);
            }
            am.assign(hri, true, true);
            Assert.assertFalse((String)"Split region can't be assigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, RegionState.State.SPLIT));
            am.unassign(hri, true, null);
            Assert.assertFalse((String)"Split region can't be unassigned", (boolean)regionStates.isRegionInTransition(hri));
            Assert.assertTrue((boolean)regionStates.isRegionInState(hri, RegionState.State.SPLIT));
        }
        finally {
            this.admin.setBalancerRunning(true, false);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitHooksBeforeAndAfterPONR() throws Exception {
        String firstTable = "testSplitHooksBeforeAndAfterPONR_1";
        String secondTable = "testSplitHooksBeforeAndAfterPONR_2";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(firstTable));
        desc.addCoprocessor(MockedRegionObserver.class.getName());
        HColumnDescriptor hcd = new HColumnDescriptor("cf");
        desc.addFamily(hcd);
        this.admin.createTable(desc);
        desc = new HTableDescriptor(TableName.valueOf(secondTable));
        hcd = new HColumnDescriptor("cf");
        desc.addFamily(hcd);
        this.admin.createTable(desc);
        List<HRegion> firstTableregions = this.cluster.getRegions(TableName.valueOf(firstTable));
        List<HRegion> secondTableRegions = this.cluster.getRegions(TableName.valueOf(secondTable));
        ServerName serverName = this.cluster.getServerHoldingRegion(firstTableregions.get(0).getRegionName());
        this.admin.move(secondTableRegions.get(0).getRegionInfo().getEncodedNameAsBytes(), Bytes.toBytes(serverName.getServerName()));
        HTable table1 = null;
        HTable table2 = null;
        try {
            table1 = new HTable(TESTING_UTIL.getConfiguration(), firstTable);
            table2 = new HTable(TESTING_UTIL.getConfiguration(), firstTable);
            this.insertData(Bytes.toBytes(firstTable), this.admin, table1);
            this.insertData(Bytes.toBytes(secondTable), this.admin, table2);
            this.admin.split(Bytes.toBytes(firstTable), "row2".getBytes());
            firstTableregions = this.cluster.getRegions(Bytes.toBytes(firstTable));
            while (firstTableregions.size() != 2) {
                Thread.sleep(1000L);
                firstTableregions = this.cluster.getRegions(Bytes.toBytes(firstTable));
            }
            Assert.assertEquals((String)"Number of regions after split should be 2.", (long)2L, (long)firstTableregions.size());
            secondTableRegions = this.cluster.getRegions(Bytes.toBytes(secondTable));
            Assert.assertEquals((String)"Number of regions after split should be 2.", (long)2L, (long)secondTableRegions.size());
        }
        finally {
            if (table1 != null) {
                table1.close();
            }
            if (table2 != null) {
                table2.close();
            }
            TESTING_UTIL.deleteTable(firstTable);
            TESTING_UTIL.deleteTable(secondTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSplitBeforeSettingSplittingInZKInternals() throws Exception {
        byte[] tableName = Bytes.toBytes("testSplitBeforeSettingSplittingInZK");
        try {
            this.createTableAndWait(tableName, Bytes.toBytes("cf"));
            List<HRegion> regions = this.awaitTableRegions(tableName);
            Assert.assertTrue((String)"Table not online", (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
            int regionServerIndex = this.cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = this.cluster.getRegionServer(regionServerIndex);
            HRegion region = this.findSplittableRegion(regions);
            Assert.assertTrue((String)"not able to find a splittable region", (region != null ? 1 : 0) != 0);
            MockedSplitTransaction st = new MockedSplitTransaction(region, Bytes.toBytes("row2")){

                @Override
                public PairOfSameType<HRegion> stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
                    throw new SplittingNodeCreationFailedException();
                }
            };
            String node = ZKAssign.getNodeName(regionServer.getZooKeeper(), region.getRegionInfo().getEncodedName());
            regionServer.getZooKeeper().sync(node);
            for (int i = 0; i < 100; ++i) {
                if (ZKUtil.checkExists(regionServer.getZooKeeper(), node) == -1) continue;
                Thread.sleep(100L);
            }
            try {
                st.prepare();
                st.execute(regionServer, regionServer);
            }
            catch (IOException e) {
                Assert.assertTrue((String)"Should be instance of CreateSplittingNodeFailedException", (boolean)(e instanceof SplittingNodeCreationFailedException));
                node = ZKAssign.getNodeName(regionServer.getZooKeeper(), region.getRegionInfo().getEncodedName());
                Assert.assertTrue((ZKUtil.checkExists(regionServer.getZooKeeper(), node) == -1 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)((SplitTransaction)st).rollback(regionServer, regionServer));
                Assert.assertTrue((ZKUtil.checkExists(regionServer.getZooKeeper(), node) == -1 ? 1 : 0) != 0);
            }
        }
        finally {
            TESTING_UTIL.deleteTable(tableName);
        }
    }

    private HRegion findSplittableRegion(List<HRegion> regions) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            for (HRegion r : regions) {
                if (!r.isSplittable()) continue;
                return r;
            }
            Thread.sleep(100L);
        }
        return null;
    }

    private List<HRegion> checkAndGetDaughters(byte[] tableName) throws InterruptedException {
        List<HRegion> daughters = null;
        for (int i = 0; i < 100 && (daughters = this.cluster.getRegions(tableName)).size() < 2; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((daughters.size() >= 2 ? 1 : 0) != 0);
        return daughters;
    }

    private MockMasterWithoutCatalogJanitor abortAndWaitForMaster() throws IOException, InterruptedException {
        this.cluster.abortMaster(0);
        this.cluster.waitOnMaster(0);
        this.cluster.getConfiguration().setClass("hbase.master.impl", MockMasterWithoutCatalogJanitor.class, HMaster.class);
        MockMasterWithoutCatalogJanitor master = null;
        master = (MockMasterWithoutCatalogJanitor)this.cluster.startMaster().getMaster();
        this.cluster.waitForActiveAndReadyMaster();
        return master;
    }

    private void split(HRegionInfo hri, HRegionServer server, int regionCount) throws IOException, InterruptedException {
        this.admin.split(hri.getRegionNameAsString());
        for (int i = 0; ProtobufUtil.getOnlineRegions(server).size() <= regionCount && i < 300; ++i) {
            LOG.debug("Waiting on region to split");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for split", (ProtobufUtil.getOnlineRegions(server).size() <= regionCount ? 1 : 0) != 0);
    }

    private int ensureTableRegionNotOnSameServerAsMeta(HBaseAdmin admin, HRegionInfo hri) throws HBaseIOException, MasterNotRunningException, ZooKeeperConnectionException, InterruptedException {
        int metaServerIndex = this.cluster.getServerWithMeta();
        Assert.assertTrue((metaServerIndex != -1 ? 1 : 0) != 0);
        HRegionServer metaRegionServer = this.cluster.getRegionServer(metaServerIndex);
        int tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        HRegionServer tableRegionServer = this.cluster.getRegionServer(tableRegionIndex);
        if (metaRegionServer.getServerName().equals(tableRegionServer.getServerName())) {
            HRegionServer hrs = this.getOtherRegionServer(this.cluster, metaRegionServer);
            Assert.assertNotNull((Object)hrs);
            Assert.assertNotNull((Object)hri);
            LOG.info("Moving " + hri.getRegionNameAsString() + " from " + metaRegionServer.getServerName() + " to " + hrs.getServerName() + "; metaServerIndex=" + metaServerIndex);
            admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes(hrs.getServerName().toString()));
        }
        for (int i = 0; i < 100 && ((tableRegionIndex = this.cluster.getServerWith(hri.getRegionName())) == -1 || tableRegionIndex == metaServerIndex); ++i) {
            LOG.debug("Waiting on region move off the hbase:meta server; current index " + tableRegionIndex + " and metaServerIndex=" + metaServerIndex);
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)"Region not moved off hbase:meta server", (tableRegionIndex != -1 && tableRegionIndex != metaServerIndex ? 1 : 0) != 0);
        tableRegionIndex = this.cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        Assert.assertNotSame((Object)metaServerIndex, (Object)tableRegionIndex);
        return tableRegionIndex;
    }

    private HRegionServer getOtherRegionServer(MiniHBaseCluster cluster, HRegionServer notThisOne) {
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.getServerName().equals(notThisOne.getServerName()) || hrs.isStopping() || hrs.isStopped()) continue;
            return hrs;
        }
        return null;
    }

    private void printOutRegions(HRegionServer hrs, String prefix) throws IOException {
        List<HRegionInfo> regions = ProtobufUtil.getOnlineRegions(hrs);
        for (HRegionInfo region : regions) {
            LOG.info(prefix + region.getRegionNameAsString());
        }
    }

    private void waitUntilRegionServerDead() throws InterruptedException {
        for (int i = 0; this.cluster.getMaster().getClusterStatus().getServers().size() == 3 && i < 100; ++i) {
            LOG.info("Waiting on server to go down");
            Thread.sleep(100L);
        }
        Assert.assertFalse((String)"Waited too long for RS to die", (this.cluster.getMaster().getClusterStatus().getServers().size() == 3 ? 1 : 0) != 0);
    }

    private void awaitDaughters(byte[] tableName, int numDaughters) throws InterruptedException {
        for (int i = 0; this.cluster.getRegions(tableName).size() < numDaughters && i < 60; ++i) {
            LOG.info("Waiting for repair to happen");
            Thread.sleep(1000L);
        }
        if (this.cluster.getRegions(tableName).size() < numDaughters) {
            Assert.fail((String)"Waiting too long for daughter regions");
        }
    }

    private List<HRegion> awaitTableRegions(byte[] tableName) throws InterruptedException {
        List<HRegion> regions = null;
        for (int i = 0; i < 100 && (regions = this.cluster.getRegions(tableName)).size() <= 0; ++i) {
            Thread.sleep(100L);
        }
        return regions;
    }

    private HTable createTableAndWait(byte[] tableName, byte[] cf) throws IOException, InterruptedException {
        HTable t = TESTING_UTIL.createTable(tableName, cf);
        this.awaitTableRegions(tableName);
        Assert.assertTrue((String)("Table not online: " + Bytes.toString(tableName)), (this.cluster.getRegions(tableName).size() != 0 ? 1 : 0) != 0);
        return t;
    }

    public static class MockedRegionObserver
    extends BaseRegionObserver {
        private SplitTransaction st = null;
        private PairOfSameType<HRegion> daughterRegions = null;

        @Override
        public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
            RegionCoprocessorEnvironment environment = ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            List<HRegion> onlineRegions = rs.getOnlineRegions(TableName.valueOf("testSplitHooksBeforeAndAfterPONR_2"));
            HRegion region = onlineRegions.get(0);
            for (HRegion r : onlineRegions) {
                if (!r.getRegionInfo().containsRow(splitKey)) continue;
                region = r;
                break;
            }
            this.st = new SplitTransaction(region, splitKey);
            if (!this.st.prepare()) {
                LOG.error("Prepare for the table " + region.getTableDesc().getNameAsString() + " failed. So returning null. ");
                ctx.bypass();
                return;
            }
            region.forceSplit(splitKey);
            this.daughterRegions = this.st.stepsBeforePONR(rs, rs, false);
            HRegionInfo copyOfParent = new HRegionInfo(region.getRegionInfo());
            copyOfParent.setOffline(true);
            copyOfParent.setSplit(true);
            Put putParent = MetaEditor.makePutFromRegionInfo(copyOfParent);
            MetaEditor.addDaughtersToPut(putParent, this.daughterRegions.getFirst().getRegionInfo(), this.daughterRegions.getSecond().getRegionInfo());
            metaEntries.add(putParent);
            Put putA = MetaEditor.makePutFromRegionInfo(this.daughterRegions.getFirst().getRegionInfo());
            Put putB = MetaEditor.makePutFromRegionInfo(this.daughterRegions.getSecond().getRegionInfo());
            this.st.addLocation(putA, rs.getServerName(), 1L);
            this.st.addLocation(putB, rs.getServerName(), 1L);
            metaEntries.add(putA);
            metaEntries.add(putB);
        }

        @Override
        public void preSplitAfterPONR(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            RegionCoprocessorEnvironment environment = ctx.getEnvironment();
            HRegionServer rs = (HRegionServer)environment.getRegionServerServices();
            this.st.stepsAfterPONR(rs, rs, this.daughterRegions);
        }
    }

    private static class SplittingNodeCreationFailedException
    extends IOException {
        private static final long serialVersionUID = 1652404976265623004L;
    }

    public static class MockMasterWithoutCatalogJanitor
    extends HMaster {
        public MockMasterWithoutCatalogJanitor(Configuration conf) throws IOException, KeeperException, InterruptedException {
            super(conf);
        }

        @Override
        protected void startCatalogJanitorChore() {
            LOG.debug("Customised master executed.");
        }
    }

    public static class MockedSplitTransaction
    extends SplitTransaction {
        private HRegion currentRegion;

        public MockedSplitTransaction(HRegion r, byte[] splitrow) {
            super(r, splitrow);
            this.currentRegion = r;
        }

        @Override
        void transitionZKNode(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                try {
                    if (!secondSplit) {
                        callRollBack = true;
                        latch.await();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            super.transitionZKNode(server, services, a, b);
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack")) {
                firstSplitCompleted = true;
            }
        }

        @Override
        public boolean rollback(Server server, RegionServerServices services) throws IOException {
            if (this.currentRegion.getRegionInfo().getTable().getNameAsString().equals("testShouldFailSplitIfZNodeDoesNotExistDueToPrevRollBack") && secondSplit) {
                super.rollback(server, services);
                latch.countDown();
                return true;
            }
            return super.rollback(server, services);
        }
    }

    static class UselessTestAbortable
    implements Abortable {
        boolean aborted = false;

        UselessTestAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            LOG.warn("ABORTED (But nothing to abort): why=" + why, e);
            this.aborted = true;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }
    }

    public static class FailingSplitRegionObserver
    extends BaseRegionObserver {
        static volatile CountDownLatch latch = new CountDownLatch(1);

        @Override
        public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
            latch.countDown();
            throw new IOException("Causing rollback of region split");
        }
    }
}

