/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableUtil;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestStoreFileBlockCacheSummary {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TEST_TABLE = "testTable";
    private static final String TEST_TABLE2 = "testTable2";
    private static final String TEST_CF = "testFamily";
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static byte[] VALUE = Bytes.toBytes("testValue");
    private final int TOTAL_ROWS = 4;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private Put createPut(byte[] family, String row) {
        Put put = new Put(Bytes.toBytes(row));
        put.add(family, QUALIFIER, VALUE);
        return put;
    }

    @Test
    public void testBlockCacheSummary() throws Exception {
        HTable ht = TEST_UTIL.createTable(Bytes.toBytes(TEST_TABLE), FAMILY);
        this.addRows(ht, FAMILY);
        HTable ht2 = TEST_UTIL.createTable(Bytes.toBytes(TEST_TABLE2), FAMILY);
        this.addRows(ht2, FAMILY);
        TEST_UTIL.flush();
        this.scan(ht, FAMILY);
        this.scan(ht2, FAMILY);
        BlockCache bc = new CacheConfig(TEST_UTIL.getConfiguration()).getBlockCache();
        List<BlockCacheColumnFamilySummary> bcs = bc.getBlockCacheColumnFamilySummaries(TEST_UTIL.getConfiguration());
        this.LOG.info("blockCacheSummary: " + bcs);
        Assert.assertTrue((String)("blockCache summary has " + bcs.size() + " entries"), (bcs.size() >= 2 ? 1 : 0) != 0);
        BlockCacheColumnFamilySummary e = bcs.get(bcs.size() - 2);
        Assert.assertEquals((String)"table", (Object)TEST_TABLE, (Object)e.getTable());
        Assert.assertEquals((String)"cf", (Object)TEST_CF, (Object)e.getColumnFamily());
        e = bcs.get(bcs.size() - 1);
        Assert.assertEquals((String)"table", (Object)TEST_TABLE2, (Object)e.getTable());
        Assert.assertEquals((String)"cf", (Object)TEST_CF, (Object)e.getColumnFamily());
        ht.close();
        ht2.close();
    }

    private void addRows(HTable ht, byte[] family) throws IOException {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < 4; ++i) {
            rows.add(this.createPut(family, "row" + i));
        }
        HTableUtil.bucketRsBatch(ht, rows);
    }

    private void scan(HTable ht, byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, QUALIFIER);
        int count = 0;
        for (Result result : ht.getScanner(scan)) {
            ++count;
        }
        if (4 != count) {
            throw new IOException("Incorrect number of rows!");
        }
    }
}

