/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestStoreScanner
extends TestCase {
    private static final String CF_STR = "cf";
    final byte[] CF = Bytes.toBytes("cf");
    private ScanInfo scanInfo = new ScanInfo(this.CF, 0, Integer.MAX_VALUE, Long.MAX_VALUE, false, 0L, KeyValue.COMPARATOR);
    private ScanType scanType = ScanType.USER_SCAN;
    private static final KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", "cf", "a", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "b", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "c", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "d", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "e", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "f", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "g", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "h", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "i", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", "cf", "a", 11L, KeyValue.Type.Put, "dont-care")};

    public void setUp() throws Exception {
        super.setUp();
    }

    NavigableSet<byte[]> getCols(String ... strCols) {
        TreeSet<byte[]> cols = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (String col : strCols) {
            byte[] bytes = Bytes.toBytes(col);
            cols.add(bytes);
        }
        return cols;
    }

    public void testScanTimeRange() throws IOException {
        String r1 = "R1";
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create(r1, CF_STR, "a", 1L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create(r1, CF_STR, "a", 2L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create(r1, CF_STR, "a", 3L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create(r1, CF_STR, "a", 4L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create(r1, CF_STR, "a", 5L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanFixture(KeyValue.COMPARATOR, kvs));
        Scan scanSpec = new Scan(Bytes.toBytes(r1));
        scanSpec.setTimeRange(0L, 6L);
        scanSpec.setMaxVersions();
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)5, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        scanSpec = new Scan(Bytes.toBytes(r1));
        scanSpec.setTimeRange(1L, 3L);
        scanSpec.setMaxVersions();
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        scanSpec = new Scan(Bytes.toBytes(r1));
        scanSpec.setTimeRange(5L, 10L);
        scanSpec.setMaxVersions();
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        scanSpec = new Scan(Bytes.toBytes(r1));
        scanSpec.setTimeRange(0L, 10L);
        scanSpec.setMaxVersions(3);
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)3, (int)results.size());
    }

    public void testScanSameTimestamp() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanFixture(KeyValue.COMPARATOR, kvs));
        Scan scanSpec = new Scan(Bytes.toBytes("R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
    }

    public void testWontNextToNext() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 2L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", CF_STR, "a", 1L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes("R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        scan.next(results);
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        results.clear();
        scan.next(results);
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(0));
        results.clear();
        scan.next(results);
        TestStoreScanner.assertEquals((int)0, (int)results.size());
    }

    public void testDeleteVersionSameTimestamp() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Delete, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes("R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertFalse((boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
    }

    public void testDeletedRowThenGoodRow() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Delete, "dont-care"), KeyValueTestUtil.create("R2", CF_STR, "a", 20L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes("R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(0));
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testDeleteVersionMaskingMultiplePuts() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs1 = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", now, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", now, KeyValue.Type.Delete, "dont-care")};
        KeyValue[] kvs2 = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", now - 500L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", now - 100L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", now, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(kvs1, kvs2);
        StoreScanner scan = new StoreScanner(new Scan(Bytes.toBytes("R1")), this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs2[1], results.get(0));
    }

    public void testDeleteVersionsMixedAndMultipleVersionReturn() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs1 = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", now, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", now, KeyValue.Type.Delete, "dont-care")};
        KeyValue[] kvs2 = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", now - 500L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", now + 500L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", now, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", CF_STR, "z", now, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(kvs1, kvs2);
        Scan scanSpec = new Scan(Bytes.toBytes("R1")).setMaxVersions(2);
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs2[1], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs2[0], results.get(1));
    }

    public void testWildCardOneVersionScan() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 2L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "b", 1L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.DeleteColumn, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(Bytes.toBytes("R1")), this.scanInfo, this.scanType, null, scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(1));
    }

    public void testWildCardScannerUnderDeletes() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 2L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.DeleteColumn, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "b", 2L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "b", 1L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "c", 10L, KeyValue.Type.Delete, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "c", 10L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "c", 9L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "d", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "d", 10L, KeyValue.Type.DeleteColumn, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "d", 9L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "d", 8L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan().setMaxVersions(2), this.scanInfo, this.scanType, null, scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)5, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(2));
        TestStoreScanner.assertEquals((Object)kvs[6], results.get(3));
        TestStoreScanner.assertEquals((Object)kvs[7], results.get(4));
    }

    public void testDeleteFamily() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 100L, KeyValue.Type.DeleteFamily, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "b", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "c", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "d", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "e", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "e", 11L, KeyValue.Type.DeleteColumn, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "f", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "g", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "g", 11L, KeyValue.Type.Delete, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "h", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "i", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", CF_STR, "a", 11L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan().setMaxVersions(Integer.MAX_VALUE), this.scanInfo, this.scanType, null, scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testDeleteColumn() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 10L, KeyValue.Type.DeleteColumn, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 9L, KeyValue.Type.Delete, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 8L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "b", 5L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, null, scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(0));
    }

    public void testSkipColumn() throws IOException {
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, this.getCols("a", "d"), scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(1));
        results.clear();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testWildCardTtlScan() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", now - 1000L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "b", now - 10L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "c", now - 200L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "d", now - 10000L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", CF_STR, "a", now, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", CF_STR, "b", now - 10L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", CF_STR, "c", now - 200L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", CF_STR, "c", now - 1000L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scan = new Scan();
        scan.setMaxVersions(1);
        ScanInfo scanInfo = new ScanInfo(this.CF, 0, 1, 500L, false, 0L, KeyValue.COMPARATOR);
        ScanType scanType = ScanType.USER_SCAN;
        StoreScanner scanner = new StoreScanner(scan, scanInfo, scanType, null, scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
        results.clear();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)3, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[4], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[5], results.get(1));
        TestStoreScanner.assertEquals((Object)kvs[6], results.get(2));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scanner.next(results));
    }

    public void testScannerReseekDoesntNPE() throws Exception {
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, this.getCols("a", "d"), scanners);
        scan.updateReaders();
        scan.updateReaders();
        scan.peek();
    }

    public void SKIP_testPeek() throws Exception {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "a", 1L, KeyValue.Type.Delete, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes("R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        TestStoreScanner.assertNull((Object)scan.peek());
    }

    public void testExpiredDeleteFamily() throws Exception {
        long now = System.currentTimeMillis();
        KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes("R1"), Bytes.toBytes(CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create("R1", CF_STR, "a", now - 10L, KeyValue.Type.Put, "dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scan = new Scan();
        scan.setMaxVersions(1);
        ScanInfo scanInfo = new ScanInfo(this.CF, 0, 1, 500L, false, 0L, KeyValue.COMPARATOR);
        ScanType scanType = ScanType.USER_SCAN;
        StoreScanner scanner = new StoreScanner(scan, scanInfo, scanType, null, scanners);
        ArrayList<Cell> results = new ArrayList<Cell>();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(0));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scanner.next(results));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMarkerLongevity() throws Exception {
        try {
            final long now = System.currentTimeMillis();
            EnvironmentEdgeManagerTestHelper.injectEdge(new EnvironmentEdge(){

                @Override
                public long currentTimeMillis() {
                    return now;
                }
            });
            KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes("R1"), Bytes.toBytes(CF_STR), null, now - 100L, KeyValue.Type.DeleteFamily), new KeyValue(Bytes.toBytes("R1"), Bytes.toBytes(CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create("R1", CF_STR, "a", now - 50L, KeyValue.Type.Put, "v3"), KeyValueTestUtil.create("R1", CF_STR, "a", now - 55L, KeyValue.Type.Delete, "dontcare"), KeyValueTestUtil.create("R1", CF_STR, "a", now - 55L, KeyValue.Type.Put, "deleted-version v2"), KeyValueTestUtil.create("R1", CF_STR, "a", now - 60L, KeyValue.Type.Put, "v1"), KeyValueTestUtil.create("R1", CF_STR, "a", now - 65L, KeyValue.Type.Put, "v0"), KeyValueTestUtil.create("R1", CF_STR, "a", now - 100L, KeyValue.Type.DeleteColumn, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "b", now - 600L, KeyValue.Type.DeleteColumn, "dont-care"), KeyValueTestUtil.create("R1", CF_STR, "b", now - 70L, KeyValue.Type.Put, "v2"), KeyValueTestUtil.create("R1", CF_STR, "b", now - 750L, KeyValue.Type.Put, "v1"), KeyValueTestUtil.create("R1", CF_STR, "c", now - 500L, KeyValue.Type.Delete, "dontcare"), KeyValueTestUtil.create("R1", CF_STR, "c", now - 600L, KeyValue.Type.Put, "v1"), KeyValueTestUtil.create("R1", CF_STR, "c", now - 1000L, KeyValue.Type.Delete, "dontcare"), KeyValueTestUtil.create("R1", CF_STR, "d", now - 60L, KeyValue.Type.Put, "expired put"), KeyValueTestUtil.create("R1", CF_STR, "d", now - 100L, KeyValue.Type.Delete, "not-expired delete")};
            List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
            Scan scan = new Scan();
            scan.setMaxVersions(2);
            ScanInfo scanInfo = new ScanInfo(Bytes.toBytes(CF_STR), 0, 2, 500L, false, 200L, KeyValue.COMPARATOR);
            StoreScanner scanner = new StoreScanner(scan, scanInfo, ScanType.COMPACT_DROP_DELETES, null, scanners, Long.MIN_VALUE);
            ArrayList<Cell> results = new ArrayList<Cell>();
            results = new ArrayList();
            TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
            TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
            TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
            TestStoreScanner.assertEquals((Object)kvs[3], results.get(2));
            TestStoreScanner.assertEquals((Object)kvs[5], results.get(3));
            TestStoreScanner.assertEquals((Object)kvs[9], results.get(4));
            TestStoreScanner.assertEquals((Object)kvs[14], results.get(5));
            TestStoreScanner.assertEquals((Object)kvs[15], results.get(6));
            TestStoreScanner.assertEquals((int)7, (int)results.size());
            scanner.close();
        }
        finally {
            EnvironmentEdgeManagerTestHelper.reset();
        }
    }
}

