/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;

@InterfaceAudience.Private
public class DefaultCompactor
extends Compactor {
    public DefaultCompactor(Configuration conf, Store store) {
        super(conf, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Path> compact(CompactionRequest request) throws IOException {
        InternalScanner scanner;
        ArrayList<Path> newFiles;
        StoreFile.Writer writer;
        long smallestReadPoint;
        Compactor.FileDetails fd;
        block10: {
            ArrayList<Path> arrayList;
            block11: {
                fd = this.getFileDetails(request.getFiles(), request.isMajor());
                this.progress = new CompactionProgress(fd.maxKeyCount);
                smallestReadPoint = this.getSmallestReadPoint();
                List<StoreFileScanner> scanners = this.createFileScanners(request.getFiles(), smallestReadPoint);
                writer = null;
                newFiles = new ArrayList<Path>();
                scanner = null;
                ScanType scanType = request.isMajor() ? ScanType.COMPACT_DROP_DELETES : ScanType.COMPACT_RETAIN_DELETES;
                scanner = this.preCreateCoprocScanner(request, scanType, fd.earliestPutTs, scanners);
                if (scanner == null) {
                    scanner = this.createScanner(this.store, scanners, scanType, smallestReadPoint, fd.earliestPutTs);
                }
                if ((scanner = this.postCreateCoprocScanner(request, scanType, scanner)) != null) break block10;
                arrayList = newFiles;
                if (scanner == null) break block11;
                scanner.close();
            }
            if (writer == null) return arrayList;
            writer.appendMetadata(fd.maxSeqId, request.isMajor());
            writer.close();
            newFiles.add(writer.getPath());
            return arrayList;
        }
        try {
            block12: {
                writer = this.store.createWriterInTmp(fd.maxKeyCount, this.compactionCompression, true, fd.maxMVCCReadpoint >= smallestReadPoint, fd.maxTagsLength > 0);
                boolean finished = this.performCompaction(scanner, writer, smallestReadPoint);
                if (!finished) {
                    writer.close();
                    this.store.getFileSystem().delete(writer.getPath(), false);
                    writer = null;
                    throw new InterruptedIOException("Aborting compaction of store " + this.store + " in region " + this.store.getRegionInfo().getRegionNameAsString() + " because it was interrupted.");
                }
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
            if (writer == null) return newFiles;
        }
        catch (Throwable throwable) {
            if (writer == null) throw throwable;
            writer.appendMetadata(fd.maxSeqId, request.isMajor());
            writer.close();
            newFiles.add(writer.getPath());
            throw throwable;
        }
        writer.appendMetadata(fd.maxSeqId, request.isMajor());
        writer.close();
        newFiles.add(writer.getPath());
        return newFiles;
    }

    public List<Path> compactForTesting(Collection<StoreFile> filesToCompact, boolean isMajor) throws IOException {
        CompactionRequest cr = new CompactionRequest(filesToCompact);
        cr.setIsMajor(isMajor);
        return this.compact(cr);
    }
}

