/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.ConsoleReporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public final class HLogPerformanceEvaluation
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog(HLogPerformanceEvaluation.class.getName());
    private final MetricsRegistry metrics = new MetricsRegistry();
    private final Meter syncMeter = this.metrics.newMeter(HLogPerformanceEvaluation.class, "syncMeter", "syncs", TimeUnit.MILLISECONDS);
    private final Meter appendMeter = this.metrics.newMeter(HLogPerformanceEvaluation.class, "append", "bytes", TimeUnit.MILLISECONDS);
    private HBaseTestingUtility TEST_UTIL;
    static final String TABLE_NAME = "HLogPerformanceEvaluation";
    static final String QUALIFIER_PREFIX = "q";
    static final String FAMILY_PREFIX = "cf";
    private int numQualifiers = 1;
    private int valueSize = 512;
    private int keySize = 16;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.TEST_UTIL = new HBaseTestingUtility(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws Exception {
        Path rootRegionDir = null;
        int numThreads = 1;
        long numIterations = 1000000L;
        int numFamilies = 1;
        int syncInterval = 0;
        boolean noSync = false;
        boolean verify = false;
        boolean verbose = false;
        boolean cleanup = true;
        boolean noclosefs = false;
        long roll = Long.MAX_VALUE;
        boolean compress = false;
        String cipher = null;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            try {
                if (cmd.equals("-threads")) {
                    numThreads = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-iterations")) {
                    numIterations = Long.parseLong(args[++i]);
                    continue;
                }
                if (cmd.equals("-path")) {
                    rootRegionDir = new Path(args[++i]);
                    continue;
                }
                if (cmd.equals("-families")) {
                    numFamilies = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-qualifiers")) {
                    this.numQualifiers = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-keySize")) {
                    this.keySize = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-valueSize")) {
                    this.valueSize = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-syncInterval")) {
                    syncInterval = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equals("-nosync")) {
                    noSync = true;
                    continue;
                }
                if (cmd.equals("-verify")) {
                    verify = true;
                    continue;
                }
                if (cmd.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (cmd.equals("-nocleanup")) {
                    cleanup = false;
                    continue;
                }
                if (cmd.equals("-noclosefs")) {
                    noclosefs = true;
                    continue;
                }
                if (cmd.equals("-roll")) {
                    roll = Long.parseLong(args[++i]);
                    continue;
                }
                if (cmd.equals("-compress")) {
                    compress = true;
                    continue;
                }
                if (cmd.equals("-encryption")) {
                    cipher = args[++i];
                    continue;
                }
                if (cmd.equals("-h")) {
                    this.printUsageAndExit();
                    continue;
                }
                if (cmd.equals("--help")) {
                    this.printUsageAndExit();
                    continue;
                }
                System.err.println("UNEXPECTED: " + cmd);
                this.printUsageAndExit();
                continue;
            }
            catch (Exception e) {
                this.printUsageAndExit();
            }
        }
        if (compress) {
            Configuration conf = this.getConf();
            conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        }
        if (cipher != null) {
            Configuration conf = this.getConf();
            conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
            conf.set("hbase.crypto.master.key.name", "hbase");
            conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, HLog.Reader.class);
            conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, HLog.Writer.class);
            conf.setBoolean("hbase.regionserver.wal.encryption", true);
            conf.set("hbase.crypto.wal.algorithm", cipher);
        }
        FSUtils.setFsDefault(this.getConf(), FSUtils.getRootDir(this.getConf()));
        FileSystem fs = FileSystem.get(this.getConf());
        LOG.info("FileSystem: " + fs);
        try {
            if (rootRegionDir == null) {
                rootRegionDir = this.TEST_UTIL.getDataTestDirOnTestFS(TABLE_NAME);
            }
            rootRegionDir = rootRegionDir.makeQualified(fs);
            this.cleanRegionRootDir(fs, rootRegionDir);
            HTableDescriptor htd = HLogPerformanceEvaluation.createHTableDescriptor(numFamilies);
            final long whenToRoll = roll;
            FSHLog hlog = new FSHLog(fs, rootRegionDir, "wals", this.getConf()){
                int appends;
                {
                    super(x0, x1, x2, x3);
                    this.appends = 0;
                }

                @Override
                protected void doWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit, HTableDescriptor htd) throws IOException {
                    ++this.appends;
                    if ((long)this.appends % whenToRoll == 0L) {
                        LOG.info("Rolling after " + this.appends + " edits");
                        this.rollWriter();
                    }
                    super.doWrite(info, logKey, logEdit, htd);
                }

                @Override
                public void postSync() {
                    super.postSync();
                    HLogPerformanceEvaluation.this.syncMeter.mark();
                }

                @Override
                public void postAppend(List<HLog.Entry> entries) {
                    super.postAppend(entries);
                    int size = 0;
                    for (HLog.Entry e : entries) {
                        size = (int)((long)size + e.getEdit().heapSize());
                    }
                    HLogPerformanceEvaluation.this.appendMeter.mark((long)size);
                }
            };
            hlog.rollWriter();
            HRegion region = null;
            try {
                region = this.openRegion(fs, rootRegionDir, htd, hlog);
                ConsoleReporter.enable((MetricsRegistry)this.metrics, (long)1L, (TimeUnit)TimeUnit.SECONDS);
                long putTime = this.runBenchmark(new HLogPutBenchmark(region, htd, numIterations, noSync, syncInterval), numThreads);
                HLogPerformanceEvaluation.logBenchmarkResult("Summary: threads=" + numThreads + ", iterations=" + numIterations + ", syncInterval=" + syncInterval, numIterations * (long)numThreads, putTime);
                if (region != null) {
                    this.closeRegion(region);
                    region = null;
                }
                if (verify) {
                    Path dir = ((FSHLog)hlog).getDir();
                    long editCount = 0L;
                    FileStatus[] fsss = fs.listStatus(dir);
                    if (fsss.length == 0) {
                        throw new IllegalStateException("No WAL found");
                    }
                    for (FileStatus fss : fsss) {
                        Path p = fss.getPath();
                        if (!fs.exists(p)) {
                            throw new IllegalStateException(p.toString());
                        }
                        editCount += this.verify(p, verbose);
                    }
                    long expected = numIterations * (long)numThreads;
                    if (editCount != expected) {
                        throw new IllegalStateException("Counted=" + editCount + ", expected=" + expected);
                    }
                }
            }
            finally {
                if (region != null) {
                    this.closeRegion(region);
                }
                if (cleanup) {
                    this.cleanRegionRootDir(fs, rootRegionDir);
                }
            }
        }
        finally {
            if (!noclosefs) {
                fs.close();
            }
        }
        return 0;
    }

    private static HTableDescriptor createHTableDescriptor(int numFamilies) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(TABLE_NAME));
        for (int i = 0; i < numFamilies; ++i) {
            HColumnDescriptor colDef = new HColumnDescriptor(FAMILY_PREFIX + i);
            htd.addFamily(colDef);
        }
        return htd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long verify(Path wal, boolean verbose) throws IOException {
        HLog.Reader reader = HLogFactory.createReader(wal.getFileSystem(this.getConf()), wal, this.getConf());
        long count = 0L;
        HashMap<String, Long> sequenceIds = new HashMap<String, Long>();
        try {
            while (true) {
                HLog.Entry e;
                if ((e = reader.next()) == null) {
                    LOG.debug("Read count=" + count + " from " + wal);
                    break;
                }
                ++count;
                long seqid = e.getKey().getLogSeqNum();
                if (sequenceIds.containsKey(Bytes.toString(e.getKey().getEncodedRegionName())) && (Long)sequenceIds.get(Bytes.toString(e.getKey().getEncodedRegionName())) >= seqid) {
                    throw new IllegalStateException("wal = " + wal.getName() + ", " + "previous seqid = " + sequenceIds.get(Bytes.toString(e.getKey().getEncodedRegionName())) + ", current seqid = " + seqid);
                }
                sequenceIds.put(Bytes.toString(e.getKey().getEncodedRegionName()), seqid);
                if (!verbose) continue;
                LOG.info("seqid=" + seqid);
            }
        }
        finally {
            reader.close();
        }
        return count;
    }

    private static void logBenchmarkResult(String testName, long numTests, long totalTime) {
        float tsec = (float)totalTime / 1000.0f;
        LOG.info(String.format("%s took %.3fs %.3fops/s", testName, Float.valueOf(tsec), Float.valueOf((float)numTests / tsec)));
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase %s [options]\n", this.getClass().getName());
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help         Show this help and exit.");
        System.err.println("  -threads <N>     Number of threads writing on the WAL.");
        System.err.println("  -iterations <N>  Number of iterations per thread.");
        System.err.println("  -path <PATH>     Path where region's root directory is created.");
        System.err.println("  -families <N>    Number of column families to write.");
        System.err.println("  -qualifiers <N>  Number of qualifiers to write.");
        System.err.println("  -keySize <N>     Row key size in byte.");
        System.err.println("  -valueSize <N>   Row/Col value size in byte.");
        System.err.println("  -nocleanup       Do NOT remove test data when done.");
        System.err.println("  -noclosefs       Do NOT close the filesystem when done.");
        System.err.println("  -nosync          Append without syncing");
        System.err.println("  -syncInterval <N> Append N edits and then sync. Default=0, i.e. sync every edit.");
        System.err.println("  -verify          Verify edits written in sequence");
        System.err.println("  -verbose         Output extra info; e.g. all edit seq ids when verifying");
        System.err.println("  -roll <N>        Roll the way every N appends");
        System.err.println("  -encryption <A>  Encrypt the WAL with algorithm A, e.g. AES");
        System.err.println("");
        System.err.println("Examples:");
        System.err.println("");
        System.err.println(" To run 100 threads on hdfs with log rolling every 10k edits and verification afterward do:");
        System.err.println(" $ ./bin/hbase org.apache.hadoop.hbase.regionserver.wal.HLogPerformanceEvaluation \\");
        System.err.println("    -conf ./core-site.xml -path hdfs://example.org:7000/tmp -threads 100 -roll 10000 -verify");
        System.exit(1);
    }

    private HRegion openRegion(FileSystem fs, Path dir, HTableDescriptor htd, HLog hlog) throws IOException {
        HRegionInfo regionInfo = new HRegionInfo(htd.getTableName());
        return HRegion.createHRegion(regionInfo, dir, this.getConf(), htd, hlog);
    }

    private void closeRegion(HRegion region) throws IOException {
        if (region != null) {
            region.close();
            HLog wal = region.getLog();
            if (wal != null) {
                wal.close();
            }
        }
    }

    private void cleanRegionRootDir(FileSystem fs, Path dir) throws IOException {
        if (fs.exists(dir)) {
            fs.delete(dir, true);
        }
    }

    private Put setupPut(Random rand, byte[] key, byte[] value, int numFamilies) {
        rand.nextBytes(key);
        Put put = new Put(key);
        for (int cf = 0; cf < numFamilies; ++cf) {
            for (int q = 0; q < this.numQualifiers; ++q) {
                rand.nextBytes(value);
                put.add(Bytes.toBytes(FAMILY_PREFIX + cf), Bytes.toBytes(QUALIFIER_PREFIX + q), value);
            }
        }
        return put;
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<Cell>> familyMap, WALEdit walEdit) {
        for (List<Cell> edits : familyMap.values()) {
            for (Cell cell : edits) {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                walEdit.add(kv);
            }
        }
    }

    private long runBenchmark(Runnable runnable, int numThreads) throws InterruptedException {
        Thread[] threads = new Thread[numThreads];
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(runnable, "t" + i);
            threads[i].start();
        }
        for (Thread t : threads) {
            t.join();
        }
        long endTime = System.currentTimeMillis();
        return endTime - startTime;
    }

    static int innerMain(Configuration c, String[] args) throws Exception {
        return ToolRunner.run(c, new HLogPerformanceEvaluation(), args);
    }

    public static void main(String[] args) throws Exception {
        System.exit(HLogPerformanceEvaluation.innerMain(HBaseConfiguration.create(), args));
    }

    class HLogPutBenchmark
    implements Runnable {
        private final long numIterations;
        private final int numFamilies;
        private final boolean noSync;
        private final HRegion region;
        private final int syncInterval;
        private final HTableDescriptor htd;

        HLogPutBenchmark(HRegion region, HTableDescriptor htd, long numIterations, boolean noSync, int syncInterval) {
            this.numIterations = numIterations;
            this.noSync = noSync;
            this.syncInterval = syncInterval;
            this.numFamilies = htd.getColumnFamilies().length;
            this.region = region;
            this.htd = htd;
        }

        @Override
        public void run() {
            byte[] key = new byte[HLogPerformanceEvaluation.this.keySize];
            byte[] value = new byte[HLogPerformanceEvaluation.this.valueSize];
            Random rand = new Random(Thread.currentThread().getId());
            HLog hlog = this.region.getLog();
            ArrayList<UUID> clusters = new ArrayList<UUID>();
            long nonce = 0L;
            try {
                long startTime = System.currentTimeMillis();
                int lastSync = 0;
                int i = 0;
                while ((long)i < this.numIterations) {
                    Put put = HLogPerformanceEvaluation.this.setupPut(rand, key, value, this.numFamilies);
                    long now = System.currentTimeMillis();
                    WALEdit walEdit = new WALEdit();
                    HLogPerformanceEvaluation.this.addFamilyMapToWALEdit(put.getFamilyCellMap(), walEdit);
                    HRegionInfo hri = this.region.getRegionInfo();
                    hlog.appendNoSync(hri, hri.getTable(), walEdit, clusters, now, this.htd, this.region.getSequenceId(), true, nonce, nonce);
                    if (!this.noSync && ++lastSync >= this.syncInterval) {
                        hlog.sync();
                        lastSync = 0;
                    }
                    ++i;
                }
                long totalTime = System.currentTimeMillis() - startTime;
                HLogPerformanceEvaluation.logBenchmarkResult(Thread.currentThread().getName(), this.numIterations, totalTime);
            }
            catch (Exception e) {
                LOG.error(this.getClass().getSimpleName() + " Thread failed", e);
            }
        }
    }
}

