/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.codec.BaseDecoder;
import org.apache.hadoop.hbase.codec.BaseEncoder;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.phoenix.hbase.index.wal.IndexedKeyValue;
import org.apache.phoenix.hbase.index.wal.KeyValueCodec;

public class IndexedWALEditCodec
extends WALCellCodec {
    private static final int REGULAR_KEY_VALUE_MARKER = 0;
    private CompressionContext compression;

    public IndexedWALEditCodec(Configuration conf, CompressionContext compression) {
        super(conf, compression);
        this.compression = compression;
    }

    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        if (this.compression == null) {
            return new IndexKeyValueDecoder(is);
        }
        Codec.Decoder decoder = super.getDecoder(is);
        return new CompressedIndexKeyValueDecoder(is, decoder);
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        if (this.compression == null) {
            return new IndexKeyValueEncoder(os);
        }
        Codec.Encoder encoder = super.getEncoder(os);
        return new CompressedIndexKeyValueEncoder(os, encoder);
    }

    private static class CompressedIndexKeyValueEncoder
    extends BaseEncoder {
        private Codec.Encoder compressedKvEncoder;

        public CompressedIndexKeyValueEncoder(OutputStream os, Codec.Encoder compressedKvEncoder) {
            super(os);
            this.compressedKvEncoder = compressedKvEncoder;
        }

        @Override
        public void flush() throws IOException {
            this.compressedKvEncoder.flush();
            super.flush();
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            int marker = 0;
            if (cell instanceof IndexedKeyValue) {
                marker = -1;
            }
            this.out.write(marker);
            if (marker == 0) {
                this.compressedKvEncoder.write(cell);
            } else {
                KeyValueCodec.write((DataOutput)((Object)this.out), KeyValueUtil.ensureKeyValue(cell));
            }
        }
    }

    private static class IndexKeyValueEncoder
    extends BaseEncoder {
        public IndexKeyValueEncoder(OutputStream os) {
            super(os);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            KeyValueCodec.write((DataOutput)((Object)this.out), KeyValueUtil.ensureKeyValue(cell));
        }
    }

    public class CompressedIndexKeyValueDecoder
    extends BaseDecoder {
        private Codec.Decoder decoder;

        public CompressedIndexKeyValueDecoder(InputStream is, Codec.Decoder compressedDecoder) {
            super(is);
            this.decoder = compressedDecoder;
        }

        @Override
        protected Cell parseCell() throws IOException {
            int marker = this.in.read();
            if (marker < 0) {
                throw new EOFException("Unexepcted end of stream found while reading next (Indexed) KeyValue");
            }
            if (marker == 0) {
                if (!this.decoder.advance()) {
                    throw new IOException("Could not read next key-value from generic KeyValue Decoder!");
                }
                return this.decoder.current();
            }
            return KeyValueCodec.readKeyValue((DataInput)((Object)this.in));
        }
    }

    public class IndexKeyValueDecoder
    extends BaseDecoder {
        public IndexKeyValueDecoder(InputStream is) {
            super(is);
        }

        @Override
        protected KeyValue parseCell() throws IOException {
            return KeyValueCodec.readKeyValue((DataInput)((Object)this.in));
        }
    }
}

