/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.regionserver.wal.WriterBase;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;

@InterfaceAudience.Private
public class SequenceFileLogWriter
extends WriterBase {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private SequenceFile.Writer writer;
    private FSDataOutputStream writer_out;
    private static final Text WAL_VERSION_KEY = new Text("version");
    private static final Text WAL_COMPRESSION_TYPE_KEY = new Text("compression.type");
    private static final Text DICTIONARY_COMPRESSION_TYPE = new Text("dictionary");

    private static SequenceFile.Metadata createMetadata(Configuration conf, boolean compress) {
        TreeMap<Text, Text> metaMap = new TreeMap<Text, Text>();
        metaMap.put(WAL_VERSION_KEY, new Text("1"));
        if (compress) {
            metaMap.put(WAL_COMPRESSION_TYPE_KEY, DICTIONARY_COMPRESSION_TYPE);
        }
        return new SequenceFile.Metadata(metaMap);
    }

    @Override
    public void init(FileSystem fs, Path path, Configuration conf, boolean overwritable) throws IOException {
        super.init(fs, path, conf, overwritable);
        boolean compress = this.initializeCompressionContext(conf, path);
        try {
            this.writer = (SequenceFile.Writer)SequenceFile.class.getMethod("createWriter", FileSystem.class, Configuration.class, Path.class, Class.class, Class.class, Integer.TYPE, Short.TYPE, Long.TYPE, Boolean.TYPE, SequenceFile.CompressionType.class, CompressionCodec.class, SequenceFile.Metadata.class).invoke(null, new Object[]{fs, conf, path, HLogKey.class, WALEdit.class, FSUtils.getDefaultBufferSize(fs), (short)conf.getInt("hbase.regionserver.hlog.replication", FSUtils.getDefaultReplication(fs, path)), conf.getLong("hbase.regionserver.hlog.blocksize", FSUtils.getDefaultBlockSize(fs, path)), false, SequenceFile.CompressionType.NONE, new DefaultCodec(), SequenceFileLogWriter.createMetadata(conf, compress)});
        }
        catch (InvocationTargetException ite) {
            throw new IOException(ite.getCause());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.writer == null) {
            this.LOG.debug("new createWriter -- HADOOP-6840 -- not available");
            this.writer = SequenceFile.createWriter(fs, conf, path, HLogKey.class, WALEdit.class, FSUtils.getDefaultBufferSize(fs), (short)conf.getInt("hbase.regionserver.hlog.replication", FSUtils.getDefaultReplication(fs, path)), conf.getLong("hbase.regionserver.hlog.blocksize", FSUtils.getDefaultBlockSize(fs, path)), SequenceFile.CompressionType.NONE, new DefaultCodec(), null, SequenceFileLogWriter.createMetadata(conf, compress));
        } else if (this.LOG.isTraceEnabled()) {
            this.LOG.trace("Using new createWriter -- HADOOP-6840");
        }
        this.writer_out = this.getSequenceFilePrivateFSDataOutputStreamAccessible();
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace("Path=" + path + ", compression=" + compress);
        }
    }

    private FSDataOutputStream getSequenceFilePrivateFSDataOutputStreamAccessible() throws IOException {
        FSDataOutputStream out = null;
        Field[] fields = this.writer.getClass().getDeclaredFields();
        String fieldName = "out";
        for (int i = 0; i < fields.length; ++i) {
            if (!"out".equals(fields[i].getName())) continue;
            try {
                fields[i].setAccessible(true);
                out = (FSDataOutputStream)fields[i].get(this.writer);
                break;
            }
            catch (IllegalAccessException ex) {
                throw new IOException("Accessing out", ex);
            }
            catch (SecurityException e) {
                this.LOG.warn("Does not have access to out field from FSDataOutputStream", e);
            }
        }
        return out;
    }

    @Override
    public void append(HLog.Entry entry) throws IOException {
        entry.setCompressionContext(this.compressionContext);
        try {
            this.writer.append(entry.getKey(), entry.getEdit());
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (NullPointerException npe) {
                this.LOG.warn(npe);
            }
            this.writer = null;
        }
    }

    @Override
    public void sync() throws IOException {
        try {
            this.writer.syncFs();
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
    }

    @Override
    public long getLength() throws IOException {
        try {
            return this.writer.getLength();
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
    }

    public FSDataOutputStream getWriterFSDataOutputStream() {
        return this.writer_out;
    }

    @Override
    public void setWALTrailer(WALProtos.WALTrailer walTrailer) {
    }
}

