/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.Compressor;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCompressor {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Test
    public void testToShort() {
        int s = 1;
        Assert.assertEquals((long)s, (long)Compressor.toShort((byte)0, (byte)1));
        s = (short)(s << 8);
        Assert.assertEquals((long)s, (long)Compressor.toShort((byte)1, (byte)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeToShort() {
        Compressor.toShort((byte)-1, (byte)-1);
    }

    @Test
    public void testCompressingWithNullDictionaries() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        byte[] blahBytes = Bytes.toBytes("blah");
        Compressor.writeCompressed(blahBytes, 0, blahBytes.length, dos, null);
        dos.close();
        byte[] dosbytes = baos.toByteArray();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dosbytes));
        byte[] product = Compressor.readCompressed(dis, null);
        Assert.assertTrue((boolean)Bytes.equals(blahBytes, product));
    }

    @Test
    public void testCompressingWithClearDictionaries() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        LRUDictionary dictionary = new LRUDictionary();
        dictionary.init(Short.MAX_VALUE);
        byte[] blahBytes = Bytes.toBytes("blah");
        Compressor.writeCompressed(blahBytes, 0, blahBytes.length, dos, dictionary);
        dos.close();
        byte[] dosbytes = baos.toByteArray();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dosbytes));
        dictionary = new LRUDictionary();
        dictionary.init(Short.MAX_VALUE);
        byte[] product = Compressor.readCompressed(dis, dictionary);
        Assert.assertTrue((boolean)Bytes.equals(blahBytes, product));
    }
}

