/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCustomWALCellCodec {
    @Test
    public void testCreatePreparesCodec() throws Exception {
        Configuration conf = new Configuration(false);
        conf.setClass("hbase.regionserver.wal.codec", CustomWALCellCodec.class, WALCellCodec.class);
        CustomWALCellCodec codec = (CustomWALCellCodec)WALCellCodec.create(conf, null);
        Assert.assertEquals((String)"Custom codec didn't get initialized with the right configuration!", (Object)conf, (Object)codec.conf);
        Assert.assertEquals((String)"Custom codec didn't get initialized with the right compression context!", null, (Object)codec.context);
    }

    public static class CustomWALCellCodec
    extends WALCellCodec {
        public Configuration conf;
        public CompressionContext context;

        public CustomWALCellCodec(Configuration conf, CompressionContext compression) {
            super(conf, compression);
            this.conf = conf;
            this.context = compression;
        }
    }
}

