/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogPerformanceEvaluation;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestHLog {
    private static final Log LOG = LogFactory.getLog(TestHLog.class);
    private static Configuration conf;
    private static FileSystem fs;
    private static Path dir;
    private static MiniDFSCluster cluster;
    private static final HBaseTestingUtility TEST_UTIL;
    private static Path hbaseDir;
    private static Path oldLogDir;

    public TestHLog() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog("org.apache.hadoop.hdfs.server.namenode.FSNamesystem")).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)HLog.LOG).getLogger().setLevel(Level.ALL);
    }

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = fs.listStatus(new Path("/"))) {
            fs.delete(dir.getPath(), true);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.broken.append", true);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("heartbeat.recheck.interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.socket.timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.getConfiguration().setInt("ipc.client.connection.maxidletime", 500);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.wal.classes", SampleRegionWALObserver.class.getName());
        TEST_UTIL.startMiniDFSCluster(3);
        conf = TEST_UTIL.getConfiguration();
        cluster = TEST_UTIL.getDFSCluster();
        fs = cluster.getFileSystem();
        hbaseDir = TEST_UTIL.createRootDir();
        oldLogDir = new Path(hbaseDir, "oldWALs");
        dir = new Path(hbaseDir, TestHLog.getName());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static String getName() {
        return "TestHLog";
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        int errCode = HLogPerformanceEvaluation.innerMain(new Configuration(TEST_UTIL.getConfiguration()), new String[]{"-threads", "3", "-verify", "-noclosefs", "-iterations", "3000"});
        Assert.assertEquals((long)0L, (long)errCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplit() throws IOException {
        TableName tableName = TableName.valueOf(TestHLog.getName());
        byte[] rowName = tableName.getName();
        Path logdir = new Path(hbaseDir, "WALs");
        HLog log = HLogFactory.createHLog(fs, hbaseDir, "WALs", conf);
        int howmany = 3;
        HRegionInfo[] infos = new HRegionInfo[3];
        Path tabledir = FSUtils.getTableDir(hbaseDir, tableName);
        fs.mkdirs(tabledir);
        for (int i = 0; i < 3; ++i) {
            infos[i] = new HRegionInfo(tableName, Bytes.toBytes("" + i), Bytes.toBytes("" + (i + 1)), false);
            fs.mkdirs(new Path(tabledir, infos[i].getEncodedName()));
            LOG.info("allo " + new Path(tabledir, infos[i].getEncodedName()).toString());
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor("column"));
        AtomicLong sequenceId = new AtomicLong(1L);
        try {
            for (int ii = 0; ii < 3; ++ii) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        WALEdit edit = new WALEdit();
                        byte[] family = Bytes.toBytes("column");
                        byte[] qualifier = Bytes.toBytes(Integer.toString(j));
                        byte[] column = Bytes.toBytes("column:" + Integer.toString(j));
                        edit.add(new KeyValue(rowName, family, qualifier, System.currentTimeMillis(), column));
                        LOG.info("Region " + i + ": " + edit);
                        log.append(infos[i], tableName, edit, System.currentTimeMillis(), htd, sequenceId);
                    }
                }
                log.rollWriter();
            }
            log.close();
            List<Path> splits = HLogSplitter.split(hbaseDir, logdir, oldLogDir, fs, conf);
            this.verifySplits(splits, 3);
            log = null;
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void Broken_testSync() throws Exception {
        TableName tableName = TableName.valueOf(TestHLog.getName());
        Path p = new Path(dir, TestHLog.getName() + ".fsdos");
        FSDataOutputStream out = fs.create(p);
        out.write(tableName.getName());
        Method syncMethod = null;
        try {
            syncMethod = out.getClass().getMethod("hflush", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                syncMethod = out.getClass().getMethod("sync", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                Assert.fail((String)"This version of Hadoop supports neither Syncable.sync() nor Syncable.hflush().");
            }
        }
        syncMethod.invoke((Object)out, new Object[0]);
        FSDataInputStream in = fs.open(p);
        Assert.assertTrue((in.available() > 0 ? 1 : 0) != 0);
        byte[] buffer = new byte[1024];
        int read = in.read(buffer);
        Assert.assertEquals((long)tableName.getName().length, (long)read);
        out.close();
        in.close();
        HLog wal = HLogFactory.createHLog(fs, dir, "hlogdir", conf);
        AtomicLong sequenceId = new AtomicLong(1L);
        int total = 20;
        HLog.Reader reader = null;
        try {
            HRegionInfo info = new HRegionInfo(tableName, null, null, false);
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor(tableName.getName()));
            for (int i = 0; i < 20; ++i) {
                WALEdit kvs = new WALEdit();
                kvs.add(new KeyValue(Bytes.toBytes(i), tableName.getName(), tableName.getName()));
                wal.append(info, tableName, kvs, System.currentTimeMillis(), htd, sequenceId);
            }
            wal.sync();
            Path walPath = ((FSHLog)wal).computeFilename();
            reader = HLogFactory.createReader(fs, walPath, conf);
            int count = 0;
            HLog.Entry entry = new HLog.Entry();
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertEquals((long)20L, (long)count);
            reader.close();
            for (int i = 0; i < 20; ++i) {
                WALEdit kvs = new WALEdit();
                kvs.add(new KeyValue(Bytes.toBytes(i), tableName.getName(), tableName.getName()));
                wal.append(info, tableName, kvs, System.currentTimeMillis(), htd, sequenceId);
            }
            reader = HLogFactory.createReader(fs, walPath, conf);
            count = 0;
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertTrue((count >= 20 ? 1 : 0) != 0);
            reader.close();
            wal.sync();
            reader = HLogFactory.createReader(fs, walPath, conf);
            count = 0;
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertEquals((long)40L, (long)count);
            byte[] value = new byte[0x100400];
            for (int i = 0; i < 20; ++i) {
                WALEdit kvs = new WALEdit();
                kvs.add(new KeyValue(Bytes.toBytes(i), tableName.getName(), value));
                wal.append(info, tableName, kvs, System.currentTimeMillis(), htd, sequenceId);
            }
            wal.sync();
            reader = HLogFactory.createReader(fs, walPath, conf);
            count = 0;
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertEquals((long)60L, (long)count);
            reader.close();
            wal.close();
            reader = HLogFactory.createReader(fs, walPath, conf);
            count = 0;
            while ((entry = reader.next(entry)) != null) {
                ++count;
            }
            Assert.assertEquals((long)60L, (long)count);
            reader.close();
        }
        finally {
            if (wal != null) {
                wal.closeAndDelete();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySplits(List<Path> splits, int howmany) throws IOException {
        Assert.assertEquals((long)(howmany * howmany), (long)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            LOG.info("Verifying=" + splits.get(i));
            HLog.Reader reader = HLogFactory.createReader(fs, splits.get(i), conf);
            try {
                int count = 0;
                String previousRegion = null;
                long seqno = -1L;
                HLog.Entry entry = new HLog.Entry();
                while ((entry = reader.next(entry)) != null) {
                    HLogKey key = entry.getKey();
                    String region = Bytes.toString(key.getEncodedRegionName());
                    if (previousRegion != null) {
                        Assert.assertEquals(previousRegion, (Object)region);
                    }
                    LOG.info("oldseqno=" + seqno + ", newseqno=" + key.getLogSeqNum());
                    Assert.assertTrue((seqno < key.getLogSeqNum() ? 1 : 0) != 0);
                    seqno = key.getLogSeqNum();
                    previousRegion = region;
                    ++count;
                }
                Assert.assertEquals((long)howmany, (long)count);
                continue;
            }
            finally {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testAppendClose() throws Exception {
        TableName tableName = TableName.valueOf(TestHLog.getName());
        HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false);
        HLog wal = HLogFactory.createHLog(fs, dir, "hlogdir", "hlogdir_archive", conf);
        AtomicLong sequenceId = new AtomicLong(1L);
        int total = 20;
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor(tableName.getName()));
        for (int i = 0; i < 20; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add(new KeyValue(Bytes.toBytes(i), tableName.getName(), tableName.getName()));
            wal.append(regioninfo, tableName, kvs, System.currentTimeMillis(), htd, sequenceId);
        }
        wal.sync();
        int namenodePort = cluster.getNameNodePort();
        final Path walPath = ((FSHLog)wal).computeFilename();
        try {
            DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
            dfs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_ENTER);
            TEST_UTIL.shutdownMiniDFSCluster();
            try {
                wal.close();
            }
            catch (IOException e) {
                LOG.info(e);
            }
            fs.close();
            LOG.info("STOPPED first instance of the cluster");
        }
        finally {
            while (cluster.isClusterUp()) {
                LOG.error("Waiting for cluster to go down");
                Thread.sleep(1000L);
            }
            Assert.assertFalse((boolean)cluster.isClusterUp());
            cluster = null;
            for (int i = 0; i < 100; ++i) {
                try {
                    cluster = TEST_UTIL.startMiniDFSClusterForTestHLog(namenodePort);
                    break;
                }
                catch (BindException e) {
                    LOG.info("Sleeping.  BindException bringing up new cluster");
                    Threads.sleep(1000L);
                    continue;
                }
            }
            cluster.waitActive();
            fs = cluster.getFileSystem();
            LOG.info("STARTED second instance.");
        }
        Method setLeasePeriod = cluster.getClass().getDeclaredMethod("setLeasePeriod", Long.TYPE, Long.TYPE);
        setLeasePeriod.setAccessible(true);
        setLeasePeriod.invoke((Object)cluster, 1000L, 1000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOG.info(e);
        }
        final FileSystem recoveredFs = fs;
        final Configuration rlConf = conf;
        class RecoverLogThread
        extends Thread {
            public Exception exception = null;

            RecoverLogThread() {
            }

            @Override
            public void run() {
                try {
                    FSUtils.getInstance(fs, rlConf).recoverFileLease(recoveredFs, walPath, rlConf, null);
                }
                catch (IOException e) {
                    this.exception = e;
                }
            }
        }
        RecoverLogThread t = new RecoverLogThread();
        t.start();
        t.join(60000L);
        if (t.isAlive()) {
            t.interrupt();
            throw new Exception("Timed out waiting for HLog.recoverLog()");
        }
        if (t.exception != null) {
            throw t.exception;
        }
        HLog.Reader reader = HLogFactory.createReader(fs, walPath, conf);
        int count = 0;
        HLog.Entry entry = new HLog.Entry();
        while (reader.next(entry) != null) {
            ++count;
            Assert.assertTrue((String)"Should be one KeyValue per WALEdit", (entry.getEdit().getKeyValues().size() == 1 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)20L, (long)count);
        reader.close();
        setLeasePeriod.invoke((Object)cluster, new Long(60000L), new Long(3600000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditAdd() throws IOException {
        int COL_COUNT = 10;
        TableName tableName = TableName.valueOf("tablename");
        byte[] row = Bytes.toBytes("row");
        HLog.Reader reader = null;
        HLog log = null;
        try {
            log = HLogFactory.createHLog(fs, hbaseDir, TestHLog.getName(), conf);
            AtomicLong sequenceId = new AtomicLong(1L);
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            for (int i = 0; i < 10; ++i) {
                cols.add(new KeyValue(row, Bytes.toBytes("column"), Bytes.toBytes(Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            }
            HRegionInfo info = new HRegionInfo(tableName, row, Bytes.toBytes(Bytes.toString(row) + "1"), false);
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor("column"));
            log.append(info, tableName, cols, System.currentTimeMillis(), htd, sequenceId);
            log.startCacheFlush(info.getEncodedNameAsBytes());
            log.completeCacheFlush(info.getEncodedNameAsBytes());
            log.close();
            Path filename = ((FSHLog)log).computeFilename();
            log = null;
            reader = HLogFactory.createReader(fs, filename, conf);
            for (int i = 0; i < 1; ++i) {
                HLog.Entry entry = reader.next(null);
                if (entry == null) {
                    break;
                }
                HLogKey key = entry.getKey();
                WALEdit val = entry.getEdit();
                Assert.assertTrue((boolean)Bytes.equals(info.getEncodedNameAsBytes(), key.getEncodedRegionName()));
                Assert.assertTrue((boolean)tableName.equals(key.getTablename()));
                KeyValue kv = val.getKeyValues().get(0);
                Assert.assertTrue((boolean)Bytes.equals(row, kv.getRow()));
                Assert.assertEquals((long)((byte)(i + 48)), (long)kv.getValue()[0]);
                System.out.println(key + " " + val);
            }
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppend() throws IOException {
        int COL_COUNT = 10;
        TableName tableName = TableName.valueOf("tablename");
        byte[] row = Bytes.toBytes("row");
        HLog.Reader reader = null;
        HLog log = HLogFactory.createHLog(fs, hbaseDir, TestHLog.getName(), conf);
        AtomicLong sequenceId = new AtomicLong(1L);
        try {
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            for (int i = 0; i < 10; ++i) {
                cols.add(new KeyValue(row, Bytes.toBytes("column"), Bytes.toBytes(Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            }
            HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor("column"));
            log.append(hri, tableName, cols, System.currentTimeMillis(), htd, sequenceId);
            log.startCacheFlush(hri.getEncodedNameAsBytes());
            log.completeCacheFlush(hri.getEncodedNameAsBytes());
            log.close();
            Path filename = ((FSHLog)log).computeFilename();
            log = null;
            reader = HLogFactory.createReader(fs, filename, conf);
            HLog.Entry entry = reader.next();
            Assert.assertEquals((long)10L, (long)entry.getEdit().size());
            int idx = 0;
            for (KeyValue val : entry.getEdit().getKeyValues()) {
                Assert.assertTrue((boolean)Bytes.equals(hri.getEncodedNameAsBytes(), entry.getKey().getEncodedRegionName()));
                Assert.assertTrue((boolean)tableName.equals(entry.getKey().getTablename()));
                Assert.assertTrue((boolean)Bytes.equals(row, val.getRow()));
                Assert.assertEquals((long)((byte)(idx + 48)), (long)val.getValue()[0]);
                System.out.println(entry.getKey() + " " + val);
                ++idx;
            }
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisitors() throws Exception {
        int COL_COUNT = 10;
        TableName tableName = TableName.valueOf("tablename");
        byte[] row = Bytes.toBytes("row");
        HLog log = HLogFactory.createHLog(fs, hbaseDir, TestHLog.getName(), conf);
        AtomicLong sequenceId = new AtomicLong(1L);
        try {
            DumbWALActionsListener visitor = new DumbWALActionsListener();
            log.registerWALActionsListener(visitor);
            long timestamp = System.currentTimeMillis();
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor("column"));
            HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            for (int i = 0; i < 10; ++i) {
                WALEdit cols = new WALEdit();
                cols.add(new KeyValue(row, Bytes.toBytes("column"), Bytes.toBytes(Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
                log.append(hri, tableName, cols, System.currentTimeMillis(), htd, sequenceId);
            }
            Assert.assertEquals((long)10L, (long)visitor.increments);
            log.unregisterWALActionsListener(visitor);
            WALEdit cols = new WALEdit();
            cols.add(new KeyValue(row, Bytes.toBytes("column"), Bytes.toBytes(Integer.toString(11)), timestamp, new byte[]{59}));
            log.append(hri, tableName, cols, System.currentTimeMillis(), htd, sequenceId);
            Assert.assertEquals((long)10L, (long)visitor.increments);
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogCleaning() throws Exception {
        LOG.info("testLogCleaning");
        TableName tableName = TableName.valueOf("testLogCleaning");
        TableName tableName2 = TableName.valueOf("testLogCleaning2");
        HLog log = HLogFactory.createHLog(fs, hbaseDir, TestHLog.getName(), conf);
        AtomicLong sequenceId = new AtomicLong(1L);
        try {
            HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HRegionInfo hri2 = new HRegionInfo(tableName2, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            this.addEdits(log, hri, tableName, 1, sequenceId);
            log.rollWriter();
            Assert.assertEquals((long)1L, (long)((FSHLog)log).getNumRolledLogFiles());
            this.addEdits(log, hri, tableName, 2, sequenceId);
            log.rollWriter();
            Assert.assertEquals((long)2L, (long)((FSHLog)log).getNumRolledLogFiles());
            this.addEdits(log, hri, tableName, 1, sequenceId);
            this.addEdits(log, hri2, tableName2, 1, sequenceId);
            this.addEdits(log, hri, tableName, 1, sequenceId);
            this.addEdits(log, hri2, tableName2, 1, sequenceId);
            log.rollWriter();
            Assert.assertEquals((long)3L, (long)((FSHLog)log).getNumRolledLogFiles());
            this.addEdits(log, hri2, tableName2, 1, sequenceId);
            log.startCacheFlush(hri.getEncodedNameAsBytes());
            log.completeCacheFlush(hri.getEncodedNameAsBytes());
            log.rollWriter();
            Assert.assertEquals((long)2L, (long)((FSHLog)log).getNumRolledLogFiles());
            this.addEdits(log, hri2, tableName2, 1, sequenceId);
            log.startCacheFlush(hri2.getEncodedNameAsBytes());
            log.completeCacheFlush(hri2.getEncodedNameAsBytes());
            log.rollWriter();
            Assert.assertEquals((long)0L, (long)((FSHLog)log).getNumRolledLogFiles());
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
        }
    }

    @Test
    public void testFailedToCreateHLogIfParentRenamed() throws IOException {
        FSHLog log = (FSHLog)HLogFactory.createHLog(fs, hbaseDir, "testFailedToCreateHLogIfParentRenamed", conf);
        long filenum = System.currentTimeMillis();
        Path path = log.computeFilename(filenum);
        HLogFactory.createWALWriter(fs, path, conf);
        Path parent = path.getParent();
        path = log.computeFilename(filenum + 1L);
        Path newPath = new Path(parent.getParent(), parent.getName() + "-splitting");
        fs.rename(parent, newPath);
        try {
            HLogFactory.createWALWriter(fs, path, conf);
            Assert.fail((String)"It should fail to create the new WAL");
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    @Test
    public void testGetServerNameFromHLogDirectoryName() throws IOException {
        ServerName sn = ServerName.valueOf("hn", 450, 1398L);
        String hl = FSUtils.getRootDir(conf) + "/" + HLogUtil.getHLogDirectoryName(sn.toString());
        Assert.assertNull((Object)HLogUtil.getServerNameFromHLogDirectoryName(conf, null));
        Assert.assertNull((Object)HLogUtil.getServerNameFromHLogDirectoryName(conf, FSUtils.getRootDir(conf).toUri().toString()));
        Assert.assertNull((Object)HLogUtil.getServerNameFromHLogDirectoryName(conf, ""));
        Assert.assertNull((Object)HLogUtil.getServerNameFromHLogDirectoryName(conf, "                  "));
        Assert.assertNull((Object)HLogUtil.getServerNameFromHLogDirectoryName(conf, hl));
        Assert.assertNull((Object)HLogUtil.getServerNameFromHLogDirectoryName(conf, hl + "qdf"));
        Assert.assertNull((Object)HLogUtil.getServerNameFromHLogDirectoryName(conf, "sfqf" + hl + "qdf"));
        String wals = "/WALs/";
        ServerName parsed = HLogUtil.getServerNameFromHLogDirectoryName(conf, FSUtils.getRootDir(conf).toUri().toString() + "/WALs/" + sn + "/localhost%2C32984%2C1343316388997.1343316390417");
        Assert.assertEquals((String)"standard", (Object)sn, (Object)parsed);
        parsed = HLogUtil.getServerNameFromHLogDirectoryName(conf, hl + "/qdf");
        Assert.assertEquals((String)"subdir", (Object)sn, (Object)parsed);
        parsed = HLogUtil.getServerNameFromHLogDirectoryName(conf, FSUtils.getRootDir(conf).toUri().toString() + "/WALs/" + sn + "-splitting/localhost%3A57020.1340474893931");
        Assert.assertEquals((String)"split", (Object)sn, (Object)parsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALCoprocessorLoaded() throws Exception {
        HLog log = HLogFactory.createHLog(fs, hbaseDir, TestHLog.getName(), conf);
        try {
            WALCoprocessorHost host = log.getCoprocessorHost();
            Coprocessor c = host.findCoprocessor(SampleRegionWALObserver.class.getName());
            Assert.assertNotNull((Object)c);
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
        }
    }

    private void addEdits(HLog log, HRegionInfo hri, TableName tableName, int times, AtomicLong sequenceId) throws IOException {
        HTableDescriptor htd = new HTableDescriptor();
        htd.addFamily(new HColumnDescriptor("row"));
        byte[] row = Bytes.toBytes("row");
        for (int i = 0; i < times; ++i) {
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            cols.add(new KeyValue(row, row, row, timestamp, row));
            log.append(hri, tableName, cols, timestamp, htd, sequenceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLegacyLog() throws IOException {
        int columnCount = 5;
        int recordCount = 5;
        TableName tableName = TableName.valueOf("tablename");
        byte[] row = Bytes.toBytes("row");
        long timestamp = System.currentTimeMillis();
        Path path = new Path(dir, "temphlog");
        SequenceFileLogWriter sflw = null;
        HLog.Reader reader = null;
        try {
            int i;
            HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HTableDescriptor htd = new HTableDescriptor(tableName);
            fs.mkdirs(dir);
            sflw = new SequenceFileLogWriter();
            sflw.init(fs, path, conf, false);
            for (i = 0; i < 5; ++i) {
                HLogKey key = new HLogKey(hri.getEncodedNameAsBytes(), tableName, i, timestamp, HConstants.DEFAULT_CLUSTER_ID);
                WALEdit edit = new WALEdit();
                for (int j = 0; j < 5; ++j) {
                    if (i == 0) {
                        htd.addFamily(new HColumnDescriptor("column" + j));
                    }
                    String value = i + "" + j;
                    edit.add(new KeyValue(row, row, row, timestamp, Bytes.toBytes(value)));
                }
                sflw.append(new HLog.Entry(key, edit));
            }
            sflw.sync();
            sflw.close();
            reader = HLogFactory.createReader(fs, path, conf);
            Assert.assertTrue((boolean)(reader instanceof SequenceFileLogReader));
            for (i = 0; i < 5; ++i) {
                HLog.Entry entry = reader.next();
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((long)5L, (long)entry.getEdit().size());
                Assert.assertArrayEquals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName());
                Assert.assertEquals((Object)tableName, (Object)entry.getKey().getTablename());
                int idx = 0;
                for (KeyValue val : entry.getEdit().getKeyValues()) {
                    Assert.assertTrue((boolean)Bytes.equals(row, val.getRow()));
                    String value = i + "" + idx;
                    Assert.assertArrayEquals((byte[])Bytes.toBytes(value), (byte[])val.getValue());
                    ++idx;
                }
            }
            HLog.Entry entry = reader.next();
            Assert.assertNull((Object)entry);
        }
        finally {
            if (sflw != null) {
                sflw.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testWALTrailer() throws IOException {
        this.doRead(true);
        this.doRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(boolean withTrailer) throws IOException {
        int columnCount = 5;
        int recordCount = 5;
        TableName tableName = TableName.valueOf("tablename");
        byte[] row = Bytes.toBytes("row");
        long timestamp = System.currentTimeMillis();
        Path path = new Path(dir, "temphlog");
        fs.delete(path, true);
        HLog.Writer writer = null;
        HLog.Reader reader = null;
        try {
            int i;
            HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HTableDescriptor htd = new HTableDescriptor(tableName);
            fs.mkdirs(dir);
            writer = HLogFactory.createWALWriter(fs, path, conf);
            for (i = 0; i < 5; ++i) {
                HLogKey key = new HLogKey(hri.getEncodedNameAsBytes(), tableName, i, timestamp, HConstants.DEFAULT_CLUSTER_ID);
                WALEdit edit = new WALEdit();
                for (int j = 0; j < 5; ++j) {
                    if (i == 0) {
                        htd.addFamily(new HColumnDescriptor("column" + j));
                    }
                    String value = i + "" + j;
                    edit.add(new KeyValue(row, row, row, timestamp, Bytes.toBytes(value)));
                }
                writer.append(new HLog.Entry(key, edit));
            }
            writer.sync();
            if (withTrailer) {
                writer.close();
            }
            reader = HLogFactory.createReader(fs, path, conf);
            Assert.assertTrue((boolean)(reader instanceof ProtobufLogReader));
            if (withTrailer) {
                Assert.assertNotNull((Object)reader.getWALTrailer());
            } else {
                Assert.assertNull((Object)reader.getWALTrailer());
            }
            for (i = 0; i < 5; ++i) {
                HLog.Entry entry = reader.next();
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((long)5L, (long)entry.getEdit().size());
                Assert.assertArrayEquals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName());
                Assert.assertEquals((Object)tableName, (Object)entry.getKey().getTablename());
                int idx = 0;
                for (KeyValue val : entry.getEdit().getKeyValues()) {
                    Assert.assertTrue((boolean)Bytes.equals(row, val.getRow()));
                    String value = i + "" + idx;
                    Assert.assertArrayEquals((byte[])Bytes.toBytes(value), (byte[])val.getValue());
                    ++idx;
                }
            }
            HLog.Entry entry = reader.next();
            Assert.assertNull((Object)entry);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHLogComparator() throws Exception {
        HLog hlog1 = null;
        HLog hlogMeta = null;
        try {
            hlog1 = HLogFactory.createHLog(fs, FSUtils.getRootDir(conf), dir.toString(), conf);
            LOG.debug("Log obtained is: " + hlog1);
            Comparator<Path> comp = ((FSHLog)hlog1).LOG_NAME_COMPARATOR;
            Path p1 = ((FSHLog)hlog1).computeFilename(11L);
            Path p2 = ((FSHLog)hlog1).computeFilename(12L);
            Assert.assertTrue((comp.compare(p1, p1) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((comp.compare(p1, p2) < 0 ? 1 : 0) != 0);
            hlogMeta = HLogFactory.createMetaHLog(fs, FSUtils.getRootDir(conf), dir.toString(), conf, null, null);
            Comparator<Path> compMeta = ((FSHLog)hlogMeta).LOG_NAME_COMPARATOR;
            Path p1WithMeta = ((FSHLog)hlogMeta).computeFilename(11L);
            Path p2WithMeta = ((FSHLog)hlogMeta).computeFilename(12L);
            Assert.assertTrue((compMeta.compare(p1WithMeta, p1WithMeta) == 0 ? 1 : 0) != 0);
            Assert.assertTrue((compMeta.compare(p1WithMeta, p2WithMeta) < 0 ? 1 : 0) != 0);
            boolean ex = false;
            try {
                comp.compare(p1WithMeta, p2);
            }
            catch (Exception e) {
                ex = true;
            }
            Assert.assertTrue((String)"Comparator doesn't complain while checking meta log files", (boolean)ex);
            boolean exMeta = false;
            try {
                compMeta.compare(p1WithMeta, p2);
            }
            catch (Exception e) {
                exMeta = true;
            }
            Assert.assertTrue((String)"Meta comparator doesn't complain while checking log files", (boolean)exMeta);
        }
        finally {
            if (hlog1 != null) {
                hlog1.close();
            }
            if (hlogMeta != null) {
                hlogMeta.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALArchiving() throws IOException {
        LOG.debug("testWALArchiving");
        TableName table1 = TableName.valueOf("t1");
        TableName table2 = TableName.valueOf("t2");
        HLog hlog = HLogFactory.createHLog(fs, FSUtils.getRootDir(conf), dir.toString(), conf);
        try {
            Assert.assertEquals((long)0L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            HRegionInfo hri1 = new HRegionInfo(table1, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HRegionInfo hri2 = new HRegionInfo(table2, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            hri1.setSplit(false);
            hri2.setSplit(false);
            AtomicLong sequenceId1 = new AtomicLong(1L);
            AtomicLong sequenceId2 = new AtomicLong(1L);
            this.addEdits(hlog, hri1, table1, 1, sequenceId1);
            hlog.rollWriter();
            Assert.assertEquals((long)1L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri1, table1, 1, sequenceId1);
            hlog.rollWriter();
            Assert.assertEquals((long)2L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri1, table1, 3, sequenceId1);
            this.flushRegion(hlog, hri1.getEncodedNameAsBytes());
            hlog.rollWriter();
            Assert.assertEquals((long)0L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri2, table2, 1, sequenceId2);
            hlog.rollWriter();
            Assert.assertEquals((long)1L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri1, table1, 2, sequenceId1);
            hlog.rollWriter();
            Assert.assertEquals((long)2L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri2, table2, 2, sequenceId2);
            this.flushRegion(hlog, hri1.getEncodedNameAsBytes());
            hlog.rollWriter();
            Assert.assertEquals((long)2L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri2, table2, 2, sequenceId2);
            this.flushRegion(hlog, hri2.getEncodedNameAsBytes());
            hlog.rollWriter();
            Assert.assertEquals((long)0L, (long)((FSHLog)hlog).getNumRolledLogFiles());
        }
        finally {
            if (hlog != null) {
                hlog.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindMemStoresEligibleForFlush() throws Exception {
        LOG.debug("testFindMemStoresEligibleForFlush");
        Configuration conf1 = HBaseConfiguration.create(conf);
        conf1.setInt("hbase.regionserver.maxlogs", 1);
        HLog hlog = HLogFactory.createHLog(fs, FSUtils.getRootDir(conf1), dir.toString(), conf1);
        TableName t1 = TableName.valueOf("t1");
        TableName t2 = TableName.valueOf("t2");
        HRegionInfo hri1 = new HRegionInfo(t1, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        HRegionInfo hri2 = new HRegionInfo(t2, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        AtomicLong sequenceId1 = new AtomicLong(1L);
        AtomicLong sequenceId2 = new AtomicLong(1L);
        try {
            this.addEdits(hlog, hri1, t1, 2, sequenceId1);
            hlog.rollWriter();
            this.addEdits(hlog, hri1, t1, 2, sequenceId1);
            hlog.rollWriter();
            Assert.assertTrue((((FSHLog)hlog).getNumRolledLogFiles() == 2 ? 1 : 0) != 0);
            byte[][] regionsToFlush = ((FSHLog)hlog).findRegionsToForceFlush();
            Assert.assertEquals((long)1L, (long)regionsToFlush.length);
            Assert.assertEquals((Object)hri1.getEncodedNameAsBytes(), (Object)regionsToFlush[0]);
            this.addEdits(hlog, hri2, t2, 2, sequenceId2);
            regionsToFlush = ((FSHLog)hlog).findRegionsToForceFlush();
            Assert.assertEquals((long)regionsToFlush.length, (long)1L);
            Assert.assertEquals((Object)hri1.getEncodedNameAsBytes(), (Object)regionsToFlush[0]);
            this.flushRegion(hlog, hri1.getEncodedNameAsBytes());
            hlog.rollWriter();
            Assert.assertEquals((long)1L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.flushRegion(hlog, hri2.getEncodedNameAsBytes());
            hlog.rollWriter(true);
            Assert.assertEquals((long)0L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri1, t1, 2, sequenceId1);
            this.addEdits(hlog, hri2, t2, 2, sequenceId2);
            hlog.rollWriter();
            Assert.assertEquals((long)1L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri1, t1, 2, sequenceId1);
            hlog.rollWriter();
            regionsToFlush = ((FSHLog)hlog).findRegionsToForceFlush();
            Assert.assertEquals((long)2L, (long)regionsToFlush.length);
            this.flushRegion(hlog, hri1.getEncodedNameAsBytes());
            this.flushRegion(hlog, hri2.getEncodedNameAsBytes());
            hlog.rollWriter(true);
            Assert.assertEquals((long)0L, (long)((FSHLog)hlog).getNumRolledLogFiles());
            this.addEdits(hlog, hri1, t1, 2, sequenceId1);
            hlog.startCacheFlush(hri1.getEncodedNameAsBytes());
            hlog.rollWriter();
            hlog.completeCacheFlush(hri1.getEncodedNameAsBytes());
            Assert.assertEquals((long)1L, (long)((FSHLog)hlog).getNumRolledLogFiles());
        }
        finally {
            if (hlog != null) {
                hlog.close();
            }
        }
    }

    @Test
    public void testAllRegionsFlushed() {
        LOG.debug("testAllRegionsFlushed");
        HashMap<byte[], Long> oldestFlushingSeqNo = new HashMap<byte[], Long>();
        HashMap<byte[], Long> oldestUnFlushedSeqNo = new HashMap<byte[], Long>();
        HashMap<byte[], Long> seqNo = new HashMap<byte[], Long>();
        TableName t1 = TableName.valueOf("t1");
        HRegionInfo hri1 = new HRegionInfo(t1, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        AtomicLong sequenceId1 = new AtomicLong(1L);
        Assert.assertTrue((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        seqNo.put(hri1.getEncodedNameAsBytes(), sequenceId1.incrementAndGet());
        oldestUnFlushedSeqNo.put(hri1.getEncodedNameAsBytes(), sequenceId1.get());
        Assert.assertFalse((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        oldestUnFlushedSeqNo.clear();
        oldestFlushingSeqNo.put(hri1.getEncodedNameAsBytes(), sequenceId1.get());
        Assert.assertFalse((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        oldestFlushingSeqNo.clear();
        oldestUnFlushedSeqNo.clear();
        Assert.assertTrue((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        oldestUnFlushedSeqNo.put(hri1.getEncodedNameAsBytes(), 1000L);
        seqNo.put(hri1.getEncodedNameAsBytes(), 1500L);
        Assert.assertFalse((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
        oldestFlushingSeqNo.put(hri1.getEncodedNameAsBytes(), 1200L);
        oldestUnFlushedSeqNo.clear();
        seqNo.put(hri1.getEncodedNameAsBytes(), 1199L);
        Assert.assertTrue((boolean)FSHLog.areAllRegionsFlushed(seqNo, oldestFlushingSeqNo, oldestUnFlushedSeqNo));
    }

    private void flushRegion(HLog hlog, byte[] regionEncodedName) {
        hlog.startCacheFlush(regionEncodedName);
        hlog.completeCacheFlush(regionEncodedName);
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
    }

    static class DumbWALActionsListener
    implements WALActionsListener {
        int increments = 0;

        DumbWALActionsListener() {
        }

        @Override
        public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
            ++this.increments;
        }

        @Override
        public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
            ++this.increments;
        }

        @Override
        public void preLogRoll(Path oldFile, Path newFile) {
        }

        @Override
        public void postLogRoll(Path oldFile, Path newFile) {
        }

        @Override
        public void preLogArchive(Path oldFile, Path newFile) {
        }

        @Override
        public void postLogArchive(Path oldFile, Path newFile) {
        }

        @Override
        public void logRollRequested() {
        }

        @Override
        public void logCloseRequested() {
        }
    }
}

