/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestHLogMethods {
    private static final byte[] TEST_REGION = Bytes.toBytes("test_region");
    private static final TableName TEST_TABLE = TableName.valueOf("test_table");
    private final HBaseTestingUtility util = new HBaseTestingUtility();

    @Test
    public void testGetSplitEditFilesSorted() throws IOException {
        FileSystem fs = FileSystem.get(this.util.getConfiguration());
        Path regiondir = this.util.getDataTestDir("regiondir");
        fs.delete(regiondir, true);
        fs.mkdirs(regiondir);
        Path recoverededits = HLogUtil.getRegionDirRecoveredEditsDir(regiondir);
        String first = HLogSplitter.formatRecoveredEditsFileName(-1L);
        this.createFile(fs, recoverededits, first);
        this.createFile(fs, recoverededits, HLogSplitter.formatRecoveredEditsFileName(0L));
        this.createFile(fs, recoverededits, HLogSplitter.formatRecoveredEditsFileName(1L));
        this.createFile(fs, recoverededits, HLogSplitter.formatRecoveredEditsFileName(11L));
        this.createFile(fs, recoverededits, HLogSplitter.formatRecoveredEditsFileName(2L));
        this.createFile(fs, recoverededits, HLogSplitter.formatRecoveredEditsFileName(50L));
        String last = HLogSplitter.formatRecoveredEditsFileName(Long.MAX_VALUE);
        this.createFile(fs, recoverededits, last);
        this.createFile(fs, recoverededits, Long.toString(Long.MAX_VALUE) + "." + System.currentTimeMillis());
        HLogFactory.createHLog(fs, regiondir, "dummyLogName", this.util.getConfiguration());
        NavigableSet<Path> files = HLogUtil.getSplitEditFilesSorted(fs, regiondir);
        Assert.assertEquals((long)7L, (long)files.size());
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)first);
        Assert.assertEquals((Object)files.pollLast().getName(), (Object)last);
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)HLogSplitter.formatRecoveredEditsFileName(0L));
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)HLogSplitter.formatRecoveredEditsFileName(1L));
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)HLogSplitter.formatRecoveredEditsFileName(2L));
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)HLogSplitter.formatRecoveredEditsFileName(11L));
    }

    private void createFile(FileSystem fs, Path testdir, String name) throws IOException {
        FSDataOutputStream fdos = fs.create(new Path(testdir, name), true);
        fdos.close();
    }

    @Test
    public void testRegionEntryBuffer() throws Exception {
        HLogSplitter.RegionEntryBuffer reb = new HLogSplitter.RegionEntryBuffer(TEST_TABLE, TEST_REGION);
        Assert.assertEquals((long)0L, (long)reb.heapSize());
        reb.appendEntry(this.createTestLogEntry(1));
        Assert.assertTrue((reb.heapSize() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testEntrySink() throws Exception {
        HLogSplitter splitter;
        Configuration conf = new Configuration();
        HLogSplitter hLogSplitter = splitter = new HLogSplitter(conf, (Path)Mockito.mock(Path.class), (FileSystem)Mockito.mock(FileSystem.class), null, null);
        hLogSplitter.getClass();
        HLogSplitter.EntryBuffers sink = hLogSplitter.new HLogSplitter.EntryBuffers(0x100000L);
        for (int i = 0; i < 1000; ++i) {
            HLog.Entry entry = this.createTestLogEntry(i);
            sink.appendEntry(entry);
        }
        Assert.assertTrue((sink.totalBuffered > 0L ? 1 : 0) != 0);
        long amountInChunk = sink.totalBuffered;
        HLogSplitter.RegionEntryBuffer chunk = sink.getChunkToWrite();
        Assert.assertEquals((long)chunk.heapSize(), (long)amountInChunk);
        Assert.assertTrue((boolean)sink.isRegionCurrentlyWriting(TEST_REGION));
        for (int i = 0; i < 500; ++i) {
            HLog.Entry entry = this.createTestLogEntry(i);
            sink.appendEntry(entry);
        }
        Assert.assertNull((Object)sink.getChunkToWrite());
        sink.doneWriting(chunk);
        HLogSplitter.RegionEntryBuffer chunk2 = sink.getChunkToWrite();
        Assert.assertNotNull((Object)chunk2);
        Assert.assertNotSame((Object)chunk, (Object)chunk2);
        long amountInChunk2 = sink.totalBuffered;
        Assert.assertTrue((amountInChunk2 < amountInChunk ? 1 : 0) != 0);
        sink.doneWriting(chunk2);
        Assert.assertEquals((long)0L, (long)sink.totalBuffered);
    }

    private HLog.Entry createTestLogEntry(int i) {
        long seq = i;
        long now = i * 1000;
        WALEdit edit = new WALEdit();
        edit.add(KeyValueTestUtil.create("row", "fam", "qual", 1234L, "val"));
        HLogKey key = new HLogKey(TEST_REGION, TEST_TABLE, seq, now, HConstants.DEFAULT_CLUSTER_ID);
        HLog.Entry entry = new HLog.Entry(key, edit);
        return entry;
    }
}

