/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.KeyValueCompression;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyValueCompression {
    private static final byte[] VALUE = Bytes.toBytes("fake value");
    private static final int BUF_SIZE = 262144;

    @Test
    public void testCountingKVs() throws Exception {
        ArrayList<KeyValue> kvs = Lists.newArrayList();
        for (int i = 0; i < 400; ++i) {
            byte[] row = Bytes.toBytes("row" + i);
            byte[] fam = Bytes.toBytes("fam" + i);
            byte[] qual = Bytes.toBytes("qual" + i);
            kvs.add(new KeyValue(row, fam, qual, 12345L, VALUE));
        }
        this.runTestCycle(kvs);
    }

    @Test
    public void testRepeatingKVs() throws Exception {
        ArrayList<KeyValue> kvs = Lists.newArrayList();
        for (int i = 0; i < 400; ++i) {
            byte[] row = Bytes.toBytes("row" + i % 10);
            byte[] fam = Bytes.toBytes("fam" + i % 127);
            byte[] qual = Bytes.toBytes("qual" + i % 128);
            kvs.add(new KeyValue(row, fam, qual, 12345L, VALUE));
        }
        this.runTestCycle(kvs);
    }

    private void runTestCycle(List<KeyValue> kvs) throws Exception {
        CompressionContext ctx = new CompressionContext(LRUDictionary.class, false, false);
        DataOutputBuffer buf = new DataOutputBuffer(262144);
        for (KeyValue kv : kvs) {
            KeyValueCompression.writeKV(buf, kv, ctx);
        }
        ctx.clear();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf.getData(), 0, buf.getLength()));
        for (KeyValue kv : kvs) {
            KeyValue readBack = KeyValueCompression.readKV(in, ctx);
            Assert.assertEquals((Object)kv, (Object)readBack);
        }
    }

    @Test
    public void testKVWithTags() throws Exception {
        CompressionContext ctx = new CompressionContext(LRUDictionary.class, false, false);
        DataOutputBuffer buf = new DataOutputBuffer(262144);
        KeyValueCompression.writeKV(buf, this.createKV(1), ctx);
        KeyValueCompression.writeKV(buf, this.createKV(0), ctx);
        KeyValueCompression.writeKV(buf, this.createKV(2), ctx);
        ctx.clear();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf.getData(), 0, buf.getLength()));
        KeyValue readBack = KeyValueCompression.readKV(in, ctx);
        List<Tag> tags = readBack.getTags();
        Assert.assertEquals((long)1L, (long)tags.size());
    }

    private KeyValue createKV(int noOfTags) {
        byte[] row = Bytes.toBytes("myRow");
        byte[] cf = Bytes.toBytes("myCF");
        byte[] q = Bytes.toBytes("myQualifier");
        byte[] value = Bytes.toBytes("myValue");
        ArrayList<Tag> tags = new ArrayList<Tag>(noOfTags);
        for (int i = 1; i <= noOfTags; ++i) {
            tags.add(new Tag((byte)i, Bytes.toBytes("tagValue" + i)));
        }
        return new KeyValue(row, cf, q, Long.MAX_VALUE, value, tags);
    }
}

