/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.TestLogRolling;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestLogRollPeriod {
    private static final Log LOG = LogFactory.getLog(TestLogRolling.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final long LOG_ROLL_PERIOD = 4000L;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionsever.info.port", -1);
        TEST_UTIL.getConfiguration().setLong("hbase.regionserver.logroll.period", 4000L);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoEdits() throws Exception {
        String tableName = "TestLogRollPeriodNoEdits";
        TEST_UTIL.createTable("TestLogRollPeriodNoEdits", "cf");
        try {
            HTable table = new HTable(TEST_UTIL.getConfiguration(), "TestLogRollPeriodNoEdits");
            try {
                HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(Bytes.toBytes("TestLogRollPeriodNoEdits"));
                HLog log = server.getWAL();
                this.checkMinLogRolls(log, 5);
            }
            finally {
                table.close();
            }
        }
        finally {
            TEST_UTIL.deleteTable("TestLogRollPeriodNoEdits");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testWithEdits() throws Exception {
        String tableName = "TestLogRollPeriodWithEdits";
        String family = "cf";
        TEST_UTIL.createTable("TestLogRollPeriodWithEdits", "cf");
        try {
            HRegionServer server = TEST_UTIL.getRSForFirstRegionInTable(Bytes.toBytes("TestLogRollPeriodWithEdits"));
            HLog log = server.getWAL();
            final HTable table = new HTable(TEST_UTIL.getConfiguration(), "TestLogRollPeriodWithEdits");
            Thread writerThread = new Thread("writer"){

                @Override
                public void run() {
                    try {
                        long row = 0L;
                        while (!1.interrupted()) {
                            Put p = new Put(Bytes.toBytes(String.format("row%d", row)));
                            p.add(Bytes.toBytes("cf"), Bytes.toBytes("col"), Bytes.toBytes(row));
                            table.put(p);
                            ++row;
                            Thread.sleep(250L);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                    }
                }
            };
            try {
                writerThread.start();
                this.checkMinLogRolls(log, 5);
            }
            finally {
                writerThread.interrupt();
                writerThread.join();
                table.close();
            }
        }
        finally {
            TEST_UTIL.deleteTable("TestLogRollPeriodWithEdits");
        }
    }

    private void checkMinLogRolls(HLog log, int minRolls) throws Exception {
        final ArrayList paths = new ArrayList();
        log.registerWALActionsListener(new WALActionsListener(){

            @Override
            public void preLogRoll(Path oldFile, Path newFile) {
            }

            @Override
            public void postLogRoll(Path oldFile, Path newFile) {
                LOG.debug("postLogRoll: oldFile=" + oldFile + " newFile=" + newFile);
                paths.add(newFile);
            }

            @Override
            public void preLogArchive(Path oldFile, Path newFile) {
            }

            @Override
            public void postLogArchive(Path oldFile, Path newFile) {
            }

            @Override
            public void logRollRequested() {
            }

            @Override
            public void logCloseRequested() {
            }

            @Override
            public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
            }

            @Override
            public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
            }
        });
        long wtime = System.currentTimeMillis();
        Thread.sleep((long)(minRolls + 1) * 4000L);
        int NUM_RETRIES = 1 + 8 * (minRolls - paths.size());
        for (int retry = 0; paths.size() < minRolls && retry < NUM_RETRIES; ++retry) {
            Thread.sleep(1000L);
        }
        wtime = System.currentTimeMillis() - wtime;
        LOG.info(String.format("got %d rolls after %dms (%dms each) - expected at least %d rolls", paths.size(), wtime, wtime / (long)paths.size(), minRolls));
        Assert.assertFalse((paths.size() < minRolls ? 1 : 0) != 0);
    }
}

