/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReadOldRootAndMetaEdits {
    private static final Log LOG = LogFactory.getLog(TestReadOldRootAndMetaEdits.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static FileSystem fs;
    private static Path dir;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setClass("hbase.regionserver.hlog.writer.impl", SequenceFileLogWriter.class, HLog.Writer.class);
        fs = TEST_UTIL.getTestFileSystem();
        dir = new Path(TEST_UTIL.createRootDir(), "testReadOldRootAndMetaEdits");
        fs.mkdirs(dir);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadOldRootAndMetaEdits() throws IOException {
        LOG.debug("testReadOldRootAndMetaEdits");
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.regionserver.hlog.writer.impl", SequenceFileLogWriter.class, HLog.Writer.class);
        byte[] row = Bytes.toBytes("row");
        KeyValue kv = new KeyValue(row, row, row, row);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(kv);
        HLog.Writer writer = null;
        HLog.Reader reader = null;
        TableName t = TableName.valueOf("t");
        HRegionInfo tRegionInfo = null;
        int logCount = 0;
        long timestamp = System.currentTimeMillis();
        Path path = new Path(dir, "t");
        try {
            tRegionInfo = new HRegionInfo(t, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HLog.Entry tEntry = this.createAEntry(new HLogKey(tRegionInfo.getEncodedNameAsBytes(), t, ++logCount, timestamp, HConstants.DEFAULT_CLUSTER_ID), kvs);
            HLog.Entry rootEntry = this.createAEntry(new HLogKey(Bytes.toBytes("-ROOT-"), TableName.OLD_ROOT_TABLE_NAME, ++logCount, timestamp, HConstants.DEFAULT_CLUSTER_ID), kvs);
            HLog.Entry oldMetaEntry = this.createAEntry(new HLogKey(Bytes.toBytes(".META."), TableName.OLD_META_TABLE_NAME, ++logCount, timestamp, HConstants.DEFAULT_CLUSTER_ID), kvs);
            writer = HLogFactory.createWALWriter(fs, path, conf);
            writer.append(tEntry);
            writer.append(rootEntry);
            writer.append(oldMetaEntry);
            writer.sync();
            writer.close();
            reader = HLogFactory.createReader(fs, path, conf);
            HLog.Entry entry = reader.next();
            Assert.assertNotNull((Object)entry);
            Assert.assertTrue((boolean)entry.getKey().getTablename().equals(t));
            Assert.assertEquals((Object)Bytes.toString(entry.getKey().getEncodedRegionName()), (Object)Bytes.toString(tRegionInfo.getEncodedNameAsBytes()));
            entry = reader.next();
            Assert.assertEquals((Object)entry.getKey().getTablename(), (Object)TableName.META_TABLE_NAME);
            Assert.assertNull((Object)reader.next());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private HLog.Entry createAEntry(HLogKey hlogKey, List<KeyValue> kvs) {
        WALEdit edit = new WALEdit();
        for (KeyValue kv : kvs) {
            edit.add(kv);
        }
        return new HLog.Entry(hlogKey, edit);
    }
}

