/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestReplicationDisableInactivePeer
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationDisableInactivePeer.class);

    @Test(timeout=600000L)
    public void testDisableInactivePeer() throws Exception {
        Result res;
        int i;
        admin.enablePeer("2");
        utility2.shutdownMiniHBaseCluster();
        byte[] rowkey = Bytes.toBytes("disable inactive peer");
        Put put = new Put(rowkey);
        put.add(famName, row, row);
        htable1.put(put);
        Thread.sleep(5000L);
        admin.disablePeer("2");
        utility2.startMiniHBaseCluster(1, 2);
        Get get = new Get(rowkey);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (res.size() >= 1) {
                Assert.fail((String)"Replication wasn't disabled");
                continue;
            }
            LOG.info("Row not replicated, let's wait a bit more...");
            Thread.sleep(500L);
        }
        admin.enablePeer("2");
        Thread.sleep(5000L);
        for (i = 0; i < 10; ++i) {
            res = htable2.get(get);
            if (res.size() != 0) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                return;
            }
            LOG.info("Row not available");
            Thread.sleep(5000L);
        }
        Assert.fail((String)"Waited too much time for put replication");
    }
}

