/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSource;

@InterfaceAudience.Private
public class MetricsSink {
    public static final String SINK_AGE_OF_LAST_APPLIED_OP = "sink.ageOfLastAppliedOp";
    public static final String SINK_APPLIED_BATCHES = "sink.appliedBatches";
    public static final String SINK_APPLIED_OPS = "sink.appliedOps";
    private MetricsReplicationSource rms;
    private long lastTimestampForAge = System.currentTimeMillis();

    public MetricsSink() {
        this.rms = CompatibilitySingletonFactory.getInstance(MetricsReplicationSource.class);
    }

    public long setAgeOfLastAppliedOp(long timestamp) {
        this.lastTimestampForAge = timestamp;
        long age = System.currentTimeMillis() - this.lastTimestampForAge;
        this.rms.setGauge(SINK_AGE_OF_LAST_APPLIED_OP, age);
        return age;
    }

    public long refreshAgeOfLastAppliedOp() {
        return this.setAgeOfLastAppliedOp(this.lastTimestampForAge);
    }

    public void applyBatch(long batchSize) {
        this.rms.incCounters(SINK_APPLIED_BATCHES, 1L);
        this.rms.incCounters(SINK_APPLIED_OPS, batchSize);
    }
}

