/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class MetricsSource {
    public static final String SOURCE_SIZE_OF_LOG_QUEUE = "source.sizeOfLogQueue";
    public static final String SOURCE_AGE_OF_LAST_SHIPPED_OP = "source.ageOfLastShippedOp";
    public static final String SOURCE_LOG_EDITS_READ = "source.logEditsRead";
    public static final String SOURCE_LOG_EDITS_FILTERED = "source.logEditsFiltered";
    public static final String SOURCE_SHIPPED_BATCHES = "source.shippedBatches";
    public static final String SOURCE_SHIPPED_OPS = "source.shippedOps";
    public static final String SOURCE_LOG_READ_IN_BYTES = "source.logReadInBytes";
    public static final Log LOG = LogFactory.getLog(MetricsSource.class);
    private String id;
    private long lastTimestamp = 0L;
    private int lastQueueSize = 0;
    private String sizeOfLogQueKey;
    private String ageOfLastShippedOpKey;
    private String logEditsReadKey;
    private String logEditsFilteredKey;
    private final String shippedBatchesKey;
    private final String shippedOpsKey;
    private final String logReadInBytesKey;
    private MetricsReplicationSource rms;

    public MetricsSource(String id) {
        this.id = id;
        this.sizeOfLogQueKey = "source." + id + ".sizeOfLogQueue";
        this.ageOfLastShippedOpKey = "source." + id + ".ageOfLastShippedOp";
        this.logEditsReadKey = "source." + id + ".logEditsRead";
        this.logEditsFilteredKey = "source." + id + ".logEditsFiltered";
        this.shippedBatchesKey = "source." + this.id + ".shippedBatches";
        this.shippedOpsKey = "source." + this.id + ".shippedOps";
        this.logReadInBytesKey = "source." + this.id + ".logReadInBytes";
        this.rms = CompatibilitySingletonFactory.getInstance(MetricsReplicationSource.class);
    }

    public void setAgeOfLastShippedOp(long timestamp) {
        long age = EnvironmentEdgeManager.currentTimeMillis() - timestamp;
        this.rms.setGauge(this.ageOfLastShippedOpKey, age);
        this.rms.setGauge(SOURCE_AGE_OF_LAST_SHIPPED_OP, age);
        this.lastTimestamp = timestamp;
    }

    public void refreshAgeOfLastShippedOp() {
        if (this.lastTimestamp > 0L) {
            this.setAgeOfLastShippedOp(this.lastTimestamp);
        }
    }

    public void setSizeOfLogQueue(int size) {
        this.rms.setGauge(this.sizeOfLogQueKey, size);
        this.rms.incGauge(SOURCE_SIZE_OF_LOG_QUEUE, size - this.lastQueueSize);
        this.lastQueueSize = size;
    }

    private void incrLogEditsRead(long delta) {
        this.rms.incCounters(this.logEditsReadKey, delta);
        this.rms.incCounters(SOURCE_LOG_EDITS_READ, delta);
    }

    public void incrLogEditsRead() {
        this.incrLogEditsRead(1L);
    }

    private void incrLogEditsFiltered(long delta) {
        this.rms.incCounters(this.logEditsFilteredKey, delta);
        this.rms.incCounters(SOURCE_LOG_EDITS_FILTERED, delta);
    }

    public void incrLogEditsFiltered() {
        this.incrLogEditsFiltered(1L);
    }

    public void shipBatch(long batchSize) {
        this.rms.incCounters(this.shippedBatchesKey, 1L);
        this.rms.incCounters(SOURCE_SHIPPED_BATCHES, 1L);
        this.rms.incCounters(this.shippedOpsKey, batchSize);
        this.rms.incCounters(SOURCE_SHIPPED_OPS, batchSize);
    }

    public void incrLogReadInBytes(long readInBytes) {
        this.rms.incCounters(this.logReadInBytesKey, readInBytes);
        this.rms.incCounters(SOURCE_LOG_READ_IN_BYTES, readInBytes);
    }

    public void clear() {
        this.rms.removeMetric(this.sizeOfLogQueKey);
        this.rms.decGauge(SOURCE_SIZE_OF_LOG_QUEUE, this.lastQueueSize);
        this.lastQueueSize = 0;
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.logEditsFilteredKey);
        this.rms.removeMetric(this.logEditsReadKey);
    }
}

