/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;

@InterfaceAudience.Private
public class RESTServletContainer
extends ServletContainer {
    private static final long serialVersionUID = -2474255003443394314L;

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String doAsUserFromQuery = request.getParameter("doAs");
        Configuration conf = RESTServlet.getInstance().getConfiguration();
        boolean proxyConfigured = conf.getBoolean("hbase.rest.support.proxyuser", false);
        if (doAsUserFromQuery != null && !proxyConfigured) {
            throw new ServletException("Support for proxyuser is not configured");
        }
        UserGroupInformation ugi = RESTServlet.getInstance().getRealUser();
        if (doAsUserFromQuery != null) {
            ugi = UserGroupInformation.createProxyUser(doAsUserFromQuery, ugi);
            try {
                ProxyUsers.authorize(ugi, request.getRemoteAddr(), conf);
            }
            catch (AuthorizationException e) {
                throw new ServletException(e.getMessage());
            }
        } else {
            ugi = UserGroupInformation.createProxyUser(request.getRemoteUser(), ugi);
        }
        RESTServlet.getInstance().setEffectiveUser(ugi);
        super.service(request, response);
    }
}

