/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.provider.JacksonProvider;
import org.apache.hadoop.hbase.util.Bytes;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMultiRowResource {
    private static final String TABLE = "TestRowResource";
    private static final String CFA = "a";
    private static final String CFB = "b";
    private static final String COLUMN_1 = "a:1";
    private static final String COLUMN_2 = "b:2";
    private static final String ROW_1 = "testrow5";
    private static final String VALUE_1 = "testvalue5";
    private static final String ROW_2 = "testrow6";
    private static final String VALUE_2 = "testvalue6";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(conf);
        context = JAXBContext.newInstance((Class[])new Class[]{CellModel.class, CellSetModel.class, RowModel.class});
        marshaller = context.createMarshaller();
        unmarshaller = context.createUnmarshaller();
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(TABLE)) {
            return;
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(TABLE));
        htd.addFamily(new HColumnDescriptor(CFA));
        htd.addFamily(new HColumnDescriptor(CFB));
        admin.createTable(htd);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMultiCellGetJSON() throws IOException, JAXBException {
        String row_5_url = "/TestRowResource/testrow5/a:1";
        String row_6_url = "/TestRowResource/testrow6/b:2";
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(ROW_1);
        path.append("&row=");
        path.append(ROW_2);
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes(VALUE_1));
        client.post(row_6_url, "application/octet-stream", Bytes.toBytes(VALUE_2));
        Response response = client.get(path.toString(), "application/json");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        client.delete(row_5_url);
        client.delete(row_6_url);
    }

    @Test
    public void testMultiCellGetXML() throws IOException, JAXBException {
        String row_5_url = "/TestRowResource/testrow5/a:1";
        String row_6_url = "/TestRowResource/testrow6/b:2";
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(ROW_1);
        path.append("&row=");
        path.append(ROW_2);
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes(VALUE_1));
        client.post(row_6_url, "application/octet-stream", Bytes.toBytes(VALUE_2));
        Response response = client.get(path.toString(), "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        client.delete(row_5_url);
        client.delete(row_6_url);
    }

    @Test
    public void testMultiCellGetJSONNotFound() throws IOException, JAXBException {
        String row_5_url = "/TestRowResource/testrow5/a:1";
        StringBuilder path = new StringBuilder();
        path.append("/");
        path.append(TABLE);
        path.append("/multiget/?row=");
        path.append(ROW_1);
        path.append("&row=");
        path.append(ROW_2);
        client.post(row_5_url, "application/octet-stream", Bytes.toBytes(VALUE_1));
        Response response = client.get(path.toString(), "application/json");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        ObjectMapper mapper = new JacksonProvider().locateMapper(CellSetModel.class, MediaType.APPLICATION_JSON_TYPE);
        CellSetModel cellSet = mapper.readValue(response.getBody(), CellSetModel.class);
        Assert.assertEquals((long)1L, (long)cellSet.getRows().size());
        Assert.assertEquals((Object)ROW_1, (Object)Bytes.toString(cellSet.getRows().get(0).getKey()));
        Assert.assertEquals((Object)VALUE_1, (Object)Bytes.toString(cellSet.getRows().get(0).getCells().get(0).getValue()));
        client.delete(row_5_url);
    }
}

