/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.google.protobuf.HBaseZeroCopyByteString;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.protobuf.generated.CellMessage;
import org.apache.hadoop.hbase.rest.protobuf.generated.CellSetMessage;

@XmlRootElement(name="CellSet")
@XmlAccessorType(value=XmlAccessType.FIELD)
@InterfaceAudience.Private
public class CellSetModel
implements Serializable,
ProtobufMessageHandler {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="Row")
    private List<RowModel> rows;

    public CellSetModel() {
        this.rows = new ArrayList<RowModel>();
    }

    public CellSetModel(List<RowModel> rows) {
        this.rows = rows;
    }

    public void addRow(RowModel row) {
        this.rows.add(row);
    }

    public List<RowModel> getRows() {
        return this.rows;
    }

    @Override
    public byte[] createProtobufOutput() {
        CellSetMessage.CellSet.Builder builder = CellSetMessage.CellSet.newBuilder();
        for (RowModel row : this.getRows()) {
            CellSetMessage.CellSet.Row.Builder rowBuilder = CellSetMessage.CellSet.Row.newBuilder();
            rowBuilder.setKey(HBaseZeroCopyByteString.wrap(row.getKey()));
            for (CellModel cell : row.getCells()) {
                CellMessage.Cell.Builder cellBuilder = CellMessage.Cell.newBuilder();
                cellBuilder.setColumn(HBaseZeroCopyByteString.wrap(cell.getColumn()));
                cellBuilder.setData(HBaseZeroCopyByteString.wrap(cell.getValue()));
                if (cell.hasUserTimestamp()) {
                    cellBuilder.setTimestamp(cell.getTimestamp());
                }
                rowBuilder.addValues(cellBuilder);
            }
            builder.addRows(rowBuilder);
        }
        return builder.build().toByteArray();
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(byte[] message) throws IOException {
        CellSetMessage.CellSet.Builder builder = CellSetMessage.CellSet.newBuilder();
        builder.mergeFrom(message);
        for (CellSetMessage.CellSet.Row row : builder.getRowsList()) {
            RowModel rowModel = new RowModel(row.getKey().toByteArray());
            for (CellMessage.Cell cell : row.getValuesList()) {
                long timestamp = Long.MAX_VALUE;
                if (cell.hasTimestamp()) {
                    timestamp = cell.getTimestamp();
                }
                rowModel.addCell(new CellModel(cell.getColumn().toByteArray(), timestamp, cell.getData().toByteArray()));
            }
            this.addRow(rowModel);
        }
        return this;
    }
}

