/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.util.Iterator;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellSetModel
extends TestModelBase<CellSetModel> {
    private static final byte[] ROW1 = Bytes.toBytes("testrow1");
    private static final byte[] COLUMN1 = Bytes.toBytes("testcolumn1");
    private static final byte[] VALUE1 = Bytes.toBytes("testvalue1");
    private static final long TIMESTAMP1 = 1245219839331L;
    private static final byte[] ROW2 = Bytes.toBytes("testrow1");
    private static final byte[] COLUMN2 = Bytes.toBytes("testcolumn2");
    private static final byte[] VALUE2 = Bytes.toBytes("testvalue2");
    private static final long TIMESTAMP2 = 1245239813319L;
    private static final byte[] COLUMN3 = Bytes.toBytes("testcolumn3");
    private static final byte[] VALUE3 = Bytes.toBytes("testvalue3");
    private static final long TIMESTAMP3 = 1245393318192L;

    public TestCellSetModel() throws Exception {
        super(CellSetModel.class);
        this.AS_XML = "<CellSet><Row key=\"dGVzdHJvdzE=\"><Cell timestamp=\"1245219839331\" column=\"dGVzdGNvbHVtbjE=\">dGVzdHZhbHVlMQ==</Cell></Row><Row key=\"dGVzdHJvdzE=\"><Cell timestamp=\"1245239813319\" column=\"dGVzdGNvbHVtbjI=\">dGVzdHZhbHVlMg==</Cell><Cell timestamp=\"1245393318192\" column=\"dGVzdGNvbHVtbjM=\">dGVzdHZhbHVlMw==</Cell></Row></CellSet>";
        this.AS_PB = "CiwKCHRlc3Ryb3cxEiASC3Rlc3Rjb2x1bW4xGOO6i+eeJCIKdGVzdHZhbHVlMQpOCgh0ZXN0cm93MRIgEgt0ZXN0Y29sdW1uMhjHyc7wniQiCnRlc3R2YWx1ZTISIBILdGVzdGNvbHVtbjMYsOLnuZ8kIgp0ZXN0dmFsdWUz";
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><CellSet><Row key=\"dGVzdHJvdzE=\"><Cell column=\"dGVzdGNvbHVtbjE=\" timestamp=\"1245219839331\">dGVzdHZhbHVlMQ==</Cell></Row><Row key=\"dGVzdHJvdzE=\"><Cell column=\"dGVzdGNvbHVtbjI=\" timestamp=\"1245239813319\">dGVzdHZhbHVlMg==</Cell><Cell column=\"dGVzdGNvbHVtbjM=\" timestamp=\"1245393318192\">dGVzdHZhbHVlMw==</Cell></Row></CellSet>";
        this.AS_JSON = "{\"Row\":[{\"key\":\"dGVzdHJvdzE=\",\"Cell\":[{\"column\":\"dGVzdGNvbHVtbjE=\",\"timestamp\":1245219839331,\"$\":\"dGVzdHZhbHVlMQ==\"}]},{\"key\":\"dGVzdHJvdzE=\",\"Cell\":[{\"column\":\"dGVzdGNvbHVtbjI=\",\"timestamp\":1245239813319,\"$\":\"dGVzdHZhbHVlMg==\"},{\"column\":\"dGVzdGNvbHVtbjM=\",\"timestamp\":1245393318192,\"$\":\"dGVzdHZhbHVlMw==\"}]}]}";
    }

    @Override
    protected CellSetModel buildTestModel() {
        CellSetModel model = new CellSetModel();
        RowModel row = new RowModel();
        row.setKey(ROW1);
        row.addCell(new CellModel(COLUMN1, 1245219839331L, VALUE1));
        model.addRow(row);
        row = new RowModel();
        row.setKey(ROW2);
        row.addCell(new CellModel(COLUMN2, 1245239813319L, VALUE2));
        row.addCell(new CellModel(COLUMN3, 1245393318192L, VALUE3));
        model.addRow(row);
        return model;
    }

    @Override
    protected void checkModel(CellSetModel model) {
        Iterator<RowModel> rows = model.getRows().iterator();
        RowModel row = rows.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals(ROW1, row.getKey()));
        Iterator<CellModel> cells = row.getCells().iterator();
        CellModel cell = cells.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals(COLUMN1, cell.getColumn()));
        TestCellSetModel.assertTrue((boolean)Bytes.equals(VALUE1, cell.getValue()));
        TestCellSetModel.assertTrue((boolean)cell.hasUserTimestamp());
        TestCellSetModel.assertEquals((long)cell.getTimestamp(), (long)1245219839331L);
        TestCellSetModel.assertFalse((boolean)cells.hasNext());
        row = rows.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals(ROW2, row.getKey()));
        cells = row.getCells().iterator();
        cell = cells.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals(COLUMN2, cell.getColumn()));
        TestCellSetModel.assertTrue((boolean)Bytes.equals(VALUE2, cell.getValue()));
        TestCellSetModel.assertTrue((boolean)cell.hasUserTimestamp());
        TestCellSetModel.assertEquals((long)cell.getTimestamp(), (long)1245239813319L);
        cell = cells.next();
        TestCellSetModel.assertTrue((boolean)Bytes.equals(COLUMN3, cell.getColumn()));
        TestCellSetModel.assertTrue((boolean)Bytes.equals(VALUE3, cell.getValue()));
        TestCellSetModel.assertTrue((boolean)cell.hasUserTimestamp());
        TestCellSetModel.assertEquals((long)cell.getTimestamp(), (long)1245393318192L);
        TestCellSetModel.assertFalse((boolean)cells.hasNext());
    }

    @Override
    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    @Override
    public void testFromXML() throws Exception {
        this.checkModel((CellSetModel)this.fromXML(this.AS_XML));
    }

    @Override
    public void testFromPB() throws Exception {
        this.checkModel((CellSetModel)this.fromPB(this.AS_PB));
    }
}

