/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;

class HBaseKerberosUtils {
    public static final String KRB_PRINCIPAL = "hbase.regionserver.kerberos.principal";
    public static final String KRB_KEYTAB_FILE = "hbase.regionserver.keytab.file";

    HBaseKerberosUtils() {
    }

    static boolean isKerberosPropertySetted() {
        String krbPrincipal = System.getProperty(KRB_PRINCIPAL);
        String krbKeytab = System.getProperty(KRB_KEYTAB_FILE);
        return !Strings.isNullOrEmpty(krbPrincipal) && !Strings.isNullOrEmpty(krbKeytab);
    }

    static void setPrincipalForTesting(String principal) {
        HBaseKerberosUtils.setSystemProperty(KRB_PRINCIPAL, principal);
    }

    static void setKeytabFileForTesting(String keytabFile) {
        HBaseKerberosUtils.setSystemProperty(KRB_KEYTAB_FILE, keytabFile);
    }

    static void setSystemProperty(String propertyName, String propertyValue) {
        System.setProperty(propertyName, propertyValue);
    }

    static String getKeytabFileForTesting() {
        return System.getProperty(KRB_KEYTAB_FILE);
    }

    static String getPrincipalForTesting() {
        return System.getProperty(KRB_PRINCIPAL);
    }

    static Configuration getConfigurationWoPrincipal() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
        return conf;
    }

    static Configuration getSecuredConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
        conf.set(KRB_KEYTAB_FILE, System.getProperty(KRB_KEYTAB_FILE));
        conf.set(KRB_PRINCIPAL, System.getProperty(KRB_PRINCIPAL));
        return conf;
    }
}

