/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import com.google.common.collect.Lists;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.TestDelayedRpc;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestDelayedRpcProtos;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSecureRPC {
    public static RpcServerInterface rpcServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcCallWithEnabledKerberosSaslAuth() throws Exception {
        Assume.assumeTrue((boolean)HBaseKerberosUtils.isKerberosPropertySetted());
        String krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        String krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        Configuration cnf = new Configuration();
        cnf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration(cnf);
        UserGroupInformation.loginUserFromKeytab(krbPrincipal, krbKeytab);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi, (Object)ugi2);
        Assert.assertEquals((Object)((Object)UserGroupInformation.AuthenticationMethod.KERBEROS), (Object)((Object)ugi.getAuthenticationMethod()));
        Assert.assertEquals((Object)krbPrincipal, (Object)ugi.getUserName());
        Configuration conf = HBaseKerberosUtils.getSecuredConfiguration();
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipal()).thenReturn((Object)"hbase.regionserver.kerberos.principal");
        SecurityInfo.addInfo("TestDelayedService", securityInfoMock);
        boolean delayReturnValue = false;
        InetSocketAddress isa = new InetSocketAddress("localhost", 0);
        TestDelayedRpc.TestDelayedImplementation instance = new TestDelayedRpc.TestDelayedImplementation(delayReturnValue);
        BlockingService service = TestDelayedRpcProtos.TestDelayedService.newReflectiveBlockingService(instance);
        rpcServer = new RpcServer(null, "testSecuredDelayedRpc", Lists.newArrayList(new RpcServer.BlockingServiceAndInterface(service, null)), isa, conf, new FifoRpcScheduler(conf, 1));
        rpcServer.start();
        RpcClient rpcClient = new RpcClient(conf, HConstants.DEFAULT_CLUSTER_ID.toString());
        try {
            BlockingRpcChannel channel = rpcClient.createBlockingRpcChannel(ServerName.valueOf(rpcServer.getListenerAddress().getHostName(), rpcServer.getListenerAddress().getPort(), System.currentTimeMillis()), User.getCurrent(), 1000);
            TestDelayedRpcProtos.TestDelayedService.BlockingInterface stub = TestDelayedRpcProtos.TestDelayedService.newBlockingStub(channel);
            ArrayList<Integer> results = new ArrayList<Integer>();
            TestDelayedRpc.TestThread th1 = new TestDelayedRpc.TestThread(stub, true, results);
            th1.start();
            Thread.sleep(100L);
            th1.join();
            Assert.assertEquals((long)-559038737L, (long)((Integer)results.get(0)).intValue());
        }
        finally {
            rpcClient.stop();
        }
    }
}

