/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestUsersOperationsWithSecureHadoop {
    @Test
    public void testUserLoginInSecureHadoop() throws Exception {
        UserGroupInformation defaultLogin = UserGroupInformation.getLoginUser();
        Configuration conf = HBaseKerberosUtils.getConfigurationWoPrincipal();
        User.login(conf, "hbase.regionserver.keytab.file", "hbase.regionserver.kerberos.principal", "localhost");
        UserGroupInformation failLogin = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"ugi should be the same in case fail login", (boolean)defaultLogin.equals(failLogin));
        Assume.assumeTrue((boolean)HBaseKerberosUtils.isKerberosPropertySetted());
        String nnKeyTab = HBaseKerberosUtils.getKeytabFileForTesting();
        String dnPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        Assert.assertNotNull((String)"KerberosKeytab was not specified", (Object)nnKeyTab);
        Assert.assertNotNull((String)"KerberosPrincipal was not specified", (Object)dnPrincipal);
        conf = HBaseKerberosUtils.getSecuredConfiguration();
        UserGroupInformation.setConfiguration(conf);
        User.login(conf, "hbase.regionserver.keytab.file", "hbase.regionserver.kerberos.principal", "localhost");
        UserGroupInformation successLogin = UserGroupInformation.getLoginUser();
        Assert.assertFalse((String)"ugi should be different in in case success login", (boolean)defaultLogin.equals(successLogin));
    }
}

