/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.HbaseObjectWritableFor96Migration;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;

public class AccessControlLists {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "acl");
    public static final byte[] ACL_GLOBAL_NAME = ACL_TABLE_NAME.getName();
    public static final String ACL_LIST_FAMILY_STR = "l";
    public static final byte[] ACL_LIST_FAMILY = Bytes.toBytes("l");
    public static final byte ACL_TAG_TYPE = 1;
    public static final char NAMESPACE_PREFIX = '@';
    public static final HTableDescriptor ACL_TABLEDESC = new HTableDescriptor(ACL_TABLE_NAME);
    public static final char ACL_KEY_DELIMITER = ',';
    public static final String GROUP_PREFIX = "@";
    public static final String SUPERUSER_CONF_KEY = "hbase.superuser";
    private static Log LOG;

    static void init(MasterServices master) throws IOException {
        if (!MetaReader.tableExists(master.getCatalogTracker(), ACL_TABLE_NAME)) {
            master.createTable(ACL_TABLEDESC, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addUserPermission(Configuration conf, UserPermission userPerm) throws IOException {
        Permission.Action[] actions = userPerm.getActions();
        byte[] rowKey = AccessControlLists.userPermissionRowKey(userPerm);
        Put p = new Put(rowKey);
        byte[] key = AccessControlLists.userPermissionKey(userPerm);
        if (actions == null || actions.length == 0) {
            String msg = "No actions associated with user '" + Bytes.toString(userPerm.getUser()) + "'";
            LOG.warn(msg);
            throw new IOException(msg);
        }
        byte[] value = new byte[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            value[i] = actions[i].code();
        }
        p.addImmutable(ACL_LIST_FAMILY, key, value);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing permission with rowKey " + Bytes.toString(rowKey) + " " + Bytes.toString(key) + ": " + Bytes.toStringBinary(value));
        }
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            acls.put(p);
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeUserPermission(Configuration conf, UserPermission userPerm) throws IOException {
        Delete d = new Delete(AccessControlLists.userPermissionRowKey(userPerm));
        byte[] key = AccessControlLists.userPermissionKey(userPerm);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing permission " + userPerm.toString());
        }
        d.deleteColumns(ACL_LIST_FAMILY, key);
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            acls.delete(d);
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTablePermissions(Configuration conf, TableName tableName) throws IOException {
        Delete d = new Delete(tableName.getName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing permissions of removed table " + tableName);
        }
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            acls.delete(d);
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeNamespacePermissions(Configuration conf, String namespace) throws IOException {
        Delete d = new Delete(Bytes.toBytes(AccessControlLists.toNamespaceEntry(namespace)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing permissions of removed namespace " + namespace);
        }
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            acls.delete(d);
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTablePermissions(Configuration conf, TableName tableName, byte[] column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing permissions of removed column " + Bytes.toString(column) + " from table " + tableName);
        }
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            Scan scan = new Scan();
            scan.addFamily(ACL_LIST_FAMILY);
            String columnName = Bytes.toString(column);
            scan.setFilter(new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(String.format("(%s%s%s)|(%s%s)$", Character.valueOf(','), columnName, Character.valueOf(','), Character.valueOf(','), columnName))));
            TreeSet<byte[]> qualifierSet = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            ResultScanner scanner = acls.getScanner(scan);
            try {
                for (Result res : scanner) {
                    for (byte[] q : res.getFamilyMap(ACL_LIST_FAMILY).navigableKeySet()) {
                        qualifierSet.add(q);
                    }
                }
            }
            finally {
                scanner.close();
            }
            if (qualifierSet.size() > 0) {
                Delete d = new Delete(tableName.getName());
                for (byte[] qualifier : qualifierSet) {
                    d.deleteColumns(ACL_LIST_FAMILY, qualifier);
                }
                acls.delete(d);
            }
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
    }

    static byte[] userPermissionRowKey(UserPermission userPerm) {
        byte[] row = userPerm.hasNamespace() ? Bytes.toBytes(AccessControlLists.toNamespaceEntry(userPerm.getNamespace())) : (userPerm.isGlobal() ? ACL_GLOBAL_NAME : userPerm.getTableName().getName());
        return row;
    }

    static byte[] userPermissionKey(UserPermission userPerm) {
        byte[] qualifier = userPerm.getQualifier();
        byte[] family = userPerm.getFamily();
        byte[] key = userPerm.getUser();
        if (family != null && family.length > 0) {
            key = Bytes.add(key, Bytes.add(new byte[]{44}, family));
            if (qualifier != null && qualifier.length > 0) {
                key = Bytes.add(key, Bytes.add(new byte[]{44}, qualifier));
            }
        }
        return key;
    }

    static boolean isAclRegion(HRegion region) {
        return ACL_TABLE_NAME.equals(region.getTableDesc().getTableName());
    }

    static boolean isAclTable(HTableDescriptor desc) {
        return ACL_TABLE_NAME.equals(desc.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<byte[], ListMultimap<String, TablePermission>> loadAll(HRegion aclRegion) throws IOException {
        if (!AccessControlLists.isAclRegion(aclRegion)) {
            throw new IOException("Can only load permissions from " + ACL_TABLE_NAME);
        }
        TreeMap<byte[], ListMultimap<String, TablePermission>> allPerms = new TreeMap<byte[], ListMultimap<String, TablePermission>>(Bytes.BYTES_RAWCOMPARATOR);
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        RegionScanner iScanner = null;
        try {
            boolean hasNext;
            iScanner = aclRegion.getScanner(scan);
            do {
                ArrayList<Cell> row = new ArrayList<Cell>();
                hasNext = iScanner.next(row);
                ArrayListMultimap<String, TablePermission> perms = ArrayListMultimap.create();
                byte[] entry = null;
                for (Cell kv : row) {
                    Pair<String, TablePermission> permissionsOfUserOnTable;
                    if (entry == null) {
                        entry = CellUtil.cloneRow(kv);
                    }
                    if ((permissionsOfUserOnTable = AccessControlLists.parsePermissionRecord(entry, kv)) == null) continue;
                    String username = permissionsOfUserOnTable.getFirst();
                    TablePermission permissions = permissionsOfUserOnTable.getSecond();
                    perms.put(username, permissions);
                }
                if (entry == null) continue;
                allPerms.put(entry, perms);
            } while (hasNext);
        }
        finally {
            if (iScanner != null) {
                iScanner.close();
            }
        }
        return allPerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<byte[], ListMultimap<String, TablePermission>> loadAll(Configuration conf) throws IOException {
        TreeMap<byte[], ListMultimap<String, TablePermission>> allPerms = new TreeMap<byte[], ListMultimap<String, TablePermission>>(Bytes.BYTES_RAWCOMPARATOR);
        Scan scan = new Scan();
        scan.addFamily(ACL_LIST_FAMILY);
        HTable acls = null;
        ResultScanner scanner = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            scanner = acls.getScanner(scan);
            for (Result row : scanner) {
                ListMultimap<String, TablePermission> resultPerms = AccessControlLists.parsePermissions(row.getRow(), row);
                allPerms.put(row.getRow(), resultPerms);
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (acls != null) {
                acls.close();
            }
        }
        return allPerms;
    }

    static ListMultimap<String, TablePermission> getTablePermissions(Configuration conf, TableName tableName) throws IOException {
        return AccessControlLists.getPermissions(conf, tableName != null ? tableName.getName() : null);
    }

    static ListMultimap<String, TablePermission> getNamespacePermissions(Configuration conf, String namespace) throws IOException {
        return AccessControlLists.getPermissions(conf, Bytes.toBytes(AccessControlLists.toNamespaceEntry(namespace)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ListMultimap<String, TablePermission> getPermissions(Configuration conf, byte[] entryName) throws IOException {
        if (entryName == null) {
            entryName = ACL_TABLE_NAME.getName();
        }
        ArrayListMultimap<String, TablePermission> perms = ArrayListMultimap.create();
        HTable acls = null;
        try {
            acls = new HTable(conf, ACL_TABLE_NAME);
            Get get = new Get(entryName);
            get.addFamily(ACL_LIST_FAMILY);
            Result row = acls.get(get);
            if (!row.isEmpty()) {
                perms = AccessControlLists.parsePermissions(entryName, row);
            } else {
                LOG.info("No permissions found in " + ACL_TABLE_NAME + " for acl entry " + Bytes.toString(entryName));
            }
        }
        finally {
            if (acls != null) {
                acls.close();
            }
        }
        return perms;
    }

    static List<UserPermission> getUserTablePermissions(Configuration conf, TableName tableName) throws IOException {
        return AccessControlLists.getUserPermissions(conf, tableName == null ? null : tableName.getName());
    }

    static List<UserPermission> getUserNamespacePermissions(Configuration conf, String namespace) throws IOException {
        return AccessControlLists.getUserPermissions(conf, Bytes.toBytes(AccessControlLists.toNamespaceEntry(namespace)));
    }

    static List<UserPermission> getUserPermissions(Configuration conf, byte[] entryName) throws IOException {
        ListMultimap<String, TablePermission> allPerms = AccessControlLists.getPermissions(conf, entryName);
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>();
        for (Map.Entry entry : allPerms.entries()) {
            UserPermission up = new UserPermission(Bytes.toBytes((String)entry.getKey()), ((TablePermission)entry.getValue()).getTableName(), ((TablePermission)entry.getValue()).getFamily(), ((TablePermission)entry.getValue()).getQualifier(), ((TablePermission)entry.getValue()).getActions());
            perms.add(up);
        }
        return perms;
    }

    private static ListMultimap<String, TablePermission> parsePermissions(byte[] entryName, Result result) {
        ArrayListMultimap<String, TablePermission> perms = ArrayListMultimap.create();
        if (result != null && result.size() > 0) {
            for (Cell kv : result.rawCells()) {
                Pair<String, TablePermission> permissionsOfUserOnTable = AccessControlLists.parsePermissionRecord(entryName, kv);
                if (permissionsOfUserOnTable == null) continue;
                String username = permissionsOfUserOnTable.getFirst();
                TablePermission permissions = permissionsOfUserOnTable.getSecond();
                perms.put(username, permissions);
            }
        }
        return perms;
    }

    private static Pair<String, TablePermission> parsePermissionRecord(byte[] entryName, Cell kv) {
        byte[] family = CellUtil.cloneFamily(kv);
        if (!Bytes.equals(family, ACL_LIST_FAMILY)) {
            return null;
        }
        byte[] key = CellUtil.cloneQualifier(kv);
        byte[] value = CellUtil.cloneValue(kv);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read acl: kv [" + Bytes.toStringBinary(key) + ": " + Bytes.toStringBinary(value) + "]");
        }
        String username = Bytes.toString(key);
        if (AccessControlLists.isNamespaceEntry(entryName)) {
            return new Pair<String, TablePermission>(username, new TablePermission(Bytes.toString(AccessControlLists.fromNamespaceEntry(entryName)), value));
        }
        int idx = username.indexOf(44);
        byte[] permFamily = null;
        byte[] permQualifier = null;
        if (idx > 0 && idx < username.length() - 1) {
            String remainder = username.substring(idx + 1);
            username = username.substring(0, idx);
            idx = remainder.indexOf(44);
            if (idx > 0 && idx < remainder.length() - 1) {
                permFamily = Bytes.toBytes(remainder.substring(0, idx));
                permQualifier = Bytes.toBytes(remainder.substring(idx + 1));
            } else {
                permFamily = Bytes.toBytes(remainder);
            }
        }
        return new Pair<String, TablePermission>(username, new TablePermission(TableName.valueOf(entryName), permFamily, permQualifier, value));
    }

    public static byte[] writePermissionsAsBytes(ListMultimap<String, TablePermission> perms, Configuration conf) {
        return ProtobufUtil.prependPBMagic(ProtobufUtil.toUserTablePermissions(perms).toByteArray());
    }

    public static ListMultimap<String, TablePermission> readPermissions(byte[] data, Configuration conf) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                AccessControlProtos.UsersAndPermissions perms = ((AccessControlProtos.UsersAndPermissions.Builder)AccessControlProtos.UsersAndPermissions.newBuilder().mergeFrom(data, pblen, data.length - pblen)).build();
                return ProtobufUtil.toUserTablePermissions(perms);
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException(e);
            }
        }
        ArrayListMultimap<String, TablePermission> perms = ArrayListMultimap.create();
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            int length = in.readInt();
            for (int i = 0; i < length; ++i) {
                String user = Text.readString(in);
                List userPerms = (List)HbaseObjectWritableFor96Migration.readObject(in, conf);
                perms.putAll(user, (Iterable<TablePermission>)userPerms);
            }
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return perms;
    }

    public static boolean isGroupPrincipal(String name) {
        return name != null && name.startsWith(GROUP_PREFIX);
    }

    public static String getGroupName(String aclKey) {
        if (!AccessControlLists.isGroupPrincipal(aclKey)) {
            return aclKey;
        }
        return aclKey.substring(GROUP_PREFIX.length());
    }

    public static boolean isNamespaceEntry(String entryName) {
        return entryName.charAt(0) == '@';
    }

    public static boolean isNamespaceEntry(byte[] entryName) {
        return entryName[0] == 64;
    }

    public static String toNamespaceEntry(String namespace) {
        return '@' + namespace;
    }

    public static String fromNamespaceEntry(String namespace) {
        if (namespace.charAt(0) != '@') {
            throw new IllegalArgumentException("Argument is not a valid namespace entry");
        }
        return namespace.substring(1);
    }

    public static byte[] toNamespaceEntry(byte[] namespace) {
        byte[] ret = new byte[namespace.length + 1];
        ret[0] = 64;
        System.arraycopy(namespace, 0, ret, 1, namespace.length);
        return ret;
    }

    public static byte[] fromNamespaceEntry(byte[] namespace) {
        if (namespace[0] != 64) {
            throw new IllegalArgumentException("Argument is not a valid namespace entry: " + Bytes.toString(namespace));
        }
        return Arrays.copyOfRange(namespace, 1, namespace.length);
    }

    public static List<Permission> getCellPermissionsForUser(User user, Cell cell) throws IOException {
        ArrayList<Permission> results = Lists.newArrayList();
        byte[] tags = CellUtil.getTagArray(cell);
        Iterator<Tag> tagsIterator = CellUtil.tagsIterator(tags, 0, tags.length);
        while (tagsIterator.hasNext()) {
            String[] groupNames;
            Tag tag = tagsIterator.next();
            if (tag.getType() != 1) continue;
            ListMultimap<String, Permission> kvPerms = ProtobufUtil.toUsersAndPermissions(((AccessControlProtos.UsersAndPermissions.Builder)AccessControlProtos.UsersAndPermissions.newBuilder().mergeFrom(tag.getBuffer(), tag.getTagOffset(), tag.getTagLength())).build());
            List<Permission> userPerms = kvPerms.get(user.getShortName());
            if (userPerms != null) {
                results.addAll(userPerms);
            }
            if ((groupNames = user.getGroupNames()) == null) continue;
            for (String group : groupNames) {
                List<Permission> groupPerms = kvPerms.get(GROUP_PREFIX + group);
                if (results == null) continue;
                results.addAll(groupPerms);
            }
        }
        return results;
    }

    static {
        ACL_TABLEDESC.addFamily(new HColumnDescriptor(ACL_LIST_FAMILY, 10, Compression.Algorithm.NONE.getName(), true, true, 8192, Integer.MAX_VALUE, BloomType.NONE.toString(), 0));
        LOG = LogFactory.getLog(AccessControlLists.class);
    }
}

