/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class AccessController
extends BaseRegionObserver
implements MasterObserver,
RegionServerObserver,
AccessControlProtos.AccessControlService.Interface,
CoprocessorService,
EndpointObserver {
    public static final Log LOG = LogFactory.getLog(AccessController.class);
    private static final Log AUDITLOG = LogFactory.getLog("SecurityLogger." + AccessController.class.getName());
    static final String EXEC_PERMISSION_CHECKS_KEY = "hbase.security.exec.permission.checks";
    static final boolean DEFAULT_EXEC_PERMISSION_CHECKS = false;
    TableAuthManager authManager = null;
    boolean aclRegion = false;
    private RegionCoprocessorEnvironment regionEnv;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private UserProvider userProvider;
    boolean canPersistCellACLs;
    boolean shouldCheckExecPermissions;
    private volatile boolean initialized = false;

    public HRegion getRegion() {
        return this.regionEnv != null ? this.regionEnv.getRegion() : null;
    }

    public TableAuthManager getAuthManager() {
        return this.authManager;
    }

    void initialize(RegionCoprocessorEnvironment e) throws IOException {
        HRegion region = e.getRegion();
        Map<byte[], ListMultimap<String, TablePermission>> tables = AccessControlLists.loadAll(region);
        for (Map.Entry<byte[], ListMultimap<String, TablePermission>> t : tables.entrySet()) {
            byte[] entry = t.getKey();
            ListMultimap<String, TablePermission> perms = t.getValue();
            byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, e.getConfiguration());
            this.authManager.getZKPermissionWatcher().writeToZookeeper(entry, serialized);
        }
        this.shouldCheckExecPermissions = e.getConfiguration().getBoolean(EXEC_PERMISSION_CHECKS_KEY, false);
        this.initialized = true;
    }

    void updateACL(RegionCoprocessorEnvironment e, Map<byte[], List<Cell>> familyMap) {
        TreeSet<byte[]> entries = new TreeSet<byte[]>(Bytes.BYTES_RAWCOMPARATOR);
        for (Map.Entry<byte[], List<Cell>> f : familyMap.entrySet()) {
            List<Cell> cells = f.getValue();
            for (Cell cell : cells) {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                if (!Bytes.equals(kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), AccessControlLists.ACL_LIST_FAMILY, 0, AccessControlLists.ACL_LIST_FAMILY.length)) continue;
                entries.add(kv.getRow());
            }
        }
        ZKPermissionWatcher zkw = this.authManager.getZKPermissionWatcher();
        Configuration conf = this.regionEnv.getConfiguration();
        for (byte[] entry : entries) {
            try {
                ListMultimap<String, TablePermission> perms = AccessControlLists.getPermissions(conf, entry);
                byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, conf);
                zkw.writeToZookeeper(entry, serialized);
            }
            catch (IOException ex) {
                LOG.error("Failed updating permissions mirror for '" + Bytes.toString(entry) + "'", ex);
            }
        }
    }

    AuthResult permissionGranted(String request, User user, Permission.Action permRequest, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families) {
        HRegionInfo hri = e.getRegion().getRegionInfo();
        TableName tableName = hri.getTable();
        if (hri.isMetaRegion() && permRequest == Permission.Action.READ) {
            return AuthResult.allow(request, "All users allowed", user, permRequest, tableName, families);
        }
        if (user == null) {
            return AuthResult.deny(request, "No user associated with request!", null, permRequest, tableName, families);
        }
        if (permRequest == Permission.Action.WRITE && (hri.isMetaRegion() || Bytes.equals(tableName.getName(), AccessControlLists.ACL_GLOBAL_NAME)) && (this.authManager.authorize(user, Permission.Action.CREATE) || this.authManager.authorize(user, Permission.Action.ADMIN))) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (this.authManager.authorize(user, tableName, (byte[])null, permRequest)) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (families != null && families.size() > 0) {
            for (Map.Entry<byte[], Collection<?>> family : families.entrySet()) {
                if (this.authManager.authorize(user, tableName, family.getKey(), permRequest)) continue;
                if (family.getValue() != null && family.getValue().size() > 0) {
                    if (family.getValue() instanceof Set) {
                        Set familySet = (Set)family.getValue();
                        for (byte[] qualifier : familySet) {
                            if (this.authManager.authorize(user, tableName, family.getKey(), qualifier, permRequest)) continue;
                            return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), qualifier));
                        }
                        continue;
                    }
                    if (!(family.getValue() instanceof List)) continue;
                    List kvList = (List)family.getValue();
                    for (KeyValue kv : kvList) {
                        if (this.authManager.authorize(user, tableName, family.getKey(), kv.getQualifier(), permRequest)) continue;
                        return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), kv.getQualifier()));
                    }
                    continue;
                }
                return AuthResult.deny(request, "Failed family check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), null));
            }
            return AuthResult.allow(request, "All family checks passed", user, permRequest, tableName, families);
        }
        return AuthResult.deny(request, "No families to check and table permission failed", user, permRequest, tableName, families);
    }

    private void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            RequestContext ctx = RequestContext.get();
            InetAddress remoteAddr = null;
            if (ctx != null) {
                remoteAddr = ctx.getRemoteAddress();
            }
            AUDITLOG.trace("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; remote address: " + (remoteAddr != null ? remoteAddr : "") + "; request: " + result.getRequest() + "; context: " + result.toContextString());
        }
    }

    private User getActiveUser() throws IOException {
        User user = RequestContext.getRequestUser();
        if (!RequestContext.isInRequestContext()) {
            user = this.userProvider.getCurrent();
        }
        return user;
    }

    private void requirePermission(String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, family, qualifier, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, family, qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
        }
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private void requirePermission(String request, Permission.Action perm) throws IOException {
        this.requireGlobalPermission(request, perm, null, null);
    }

    private void requirePermission(String request, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<?>> families) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = this.permissionGranted(request, user, perm, env, families);
        this.logResult(result);
        if (!result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + env.getRegion().getTableDesc().getTableName() + (families != null && families.size() > 0 ? ", family: " + result.toFamilyString() : "") + ", action=" + perm.toString() + ")");
        }
    }

    private void requireGlobalPermission(String request, Permission.Action perm, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        User user = this.getActiveUser();
        if (!this.authManager.authorize(user, perm)) {
            this.logResult(AuthResult.deny(request, "Global check failed", user, perm, tableName, familyMap));
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        this.logResult(AuthResult.allow(request, "Global check allowed", user, perm, tableName, familyMap));
    }

    private void requireGlobalPermission(String request, Permission.Action perm, String namespace) throws IOException {
        User user = this.getActiveUser();
        if (!this.authManager.authorize(user, perm)) {
            this.logResult(AuthResult.deny(request, "Global check failed", user, perm, namespace));
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
        }
        this.logResult(AuthResult.allow(request, "Global check allowed", user, perm, namespace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requireCoveringPermission(String request, RegionCoprocessorEnvironment e, byte[] row, Map<byte[], ? extends Collection<?>> familyMap, long timestamp, boolean allVersions, Permission.Action ... actions) throws IOException {
        int i;
        User user = this.getActiveUser();
        ArrayList<Permission.Action> cellCheckActions = Lists.newArrayList();
        AuthResult[] results = new AuthResult[actions.length];
        for (i = 0; i < actions.length; ++i) {
            results[i] = this.permissionGranted(request, user, actions[i], e, familyMap);
            if (results[i].isAllowed()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Got " + results[i] + ", added to cellCheckActions");
            }
            cellCheckActions.add(actions[i]);
        }
        if (cellCheckActions.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("All permissions checks passed, we can early out");
            }
            for (i = 0; i < results.length; ++i) {
                this.logResult(results[i]);
            }
            return;
        }
        int cellsChecked = 0;
        if (this.canPersistCellACLs) {
            Get get = new Get(row);
            if (timestamp != Long.MAX_VALUE) {
                get.setTimeStamp(timestamp);
            }
            if (allVersions) {
                get.setMaxVersions();
            } else {
                get.setMaxVersions(1);
            }
            for (Map.Entry<byte[], Collection<?>> entry : familyMap.entrySet()) {
                byte[] col = entry.getKey();
                if (entry.getValue() instanceof Set) {
                    Set set = (Set)entry.getValue();
                    if (set == null || set.isEmpty()) {
                        get.addFamily(col);
                        continue;
                    }
                    for (byte[] qual : set) {
                        get.addColumn(col, qual);
                    }
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List list = (List)entry.getValue();
                    if (list == null || list.isEmpty()) {
                        get.addFamily(col);
                        continue;
                    }
                    for (Cell cell : list) {
                        get.addColumn(col, CellUtil.cloneQualifier(cell));
                    }
                    continue;
                }
                throw new RuntimeException("Unhandled collection type " + entry.getValue().getClass().getName());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Scanning for cells with " + get);
            }
            RegionScanner scanner = this.getRegion(e).getScanner(new Scan(get));
            ArrayList<Cell> cells = Lists.newArrayList();
            try {
                boolean more = false;
                do {
                    cells.clear();
                    more = scanner.next(cells, 1);
                    for (Cell cell : cells) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Found cell " + cell);
                        }
                        for (Permission.Action action : cellCheckActions) {
                            if (this.authManager.authorize(user, this.getTableName(e), cell, false, action)) continue;
                            AuthResult authResult = AuthResult.deny(request, "Insufficient permissions", user, action, this.getTableName(e), CellUtil.cloneFamily(cell), CellUtil.cloneQualifier(cell));
                            this.logResult(authResult);
                            throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
                        }
                        ++cellsChecked;
                    }
                } while (more);
            }
            catch (AccessDeniedException ex) {
                throw ex;
            }
            catch (IOException ex) {
                LOG.error("Exception while getting cells to calculate covering permission", ex);
            }
            finally {
                scanner.close();
            }
        }
        if (cellsChecked < 1) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No cells found with scan");
            }
            AuthResult authResult = AuthResult.deny(request, "Insufficient permissions", user, (Permission.Action)((Object)cellCheckActions.get(0)), this.getTableName(e), familyMap);
            this.logResult(authResult);
            throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
        }
        for (byte[] family : familyMap.keySet()) {
            for (Permission.Action action : actions) {
                this.logResult(AuthResult.allow(request, "Permission granted", user, action, this.getTableName(e), family, null));
            }
        }
    }

    private void addCellPermissions(byte[] perms, Map<byte[], List<Cell>> familyMap) {
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            ArrayList<KeyValue> newCells = Lists.newArrayList();
            for (Cell cell : e.getValue()) {
                ArrayList<Tag> tags = Lists.newArrayList(new Tag(1, perms));
                byte[] tagBytes = CellUtil.getTagArray(cell);
                Iterator<Tag> tagIterator = CellUtil.tagsIterator(tagBytes, 0, tagBytes.length);
                while (tagIterator.hasNext()) {
                    tags.add(tagIterator.next());
                }
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                byte[] bytes = kv.getBuffer();
                newCells.add(new KeyValue(bytes, kv.getRowOffset(), kv.getRowLength(), bytes, kv.getFamilyOffset(), kv.getFamilyLength(), bytes, kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType(kv.getTypeByte()), bytes, kv.getValueOffset(), kv.getValueLength(), tags));
            }
            e.setValue(newCells);
        }
    }

    private void internalPreRead(ObserverContext<RegionCoprocessorEnvironment> c, Query query) throws IOException {
        TableName tableName = this.getTableName(c.getEnvironment());
        User activeUser = this.getActiveUser();
        Filter filter = query.getFilter();
        boolean cellFirstStrategy = query.getACLStrategy();
        if (filter != null && filter instanceof AccessControlFilter) {
            return;
        }
        Filter newFilter = filter != null ? new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(new AccessControlFilter(this.authManager, activeUser, tableName, cellFirstStrategy), filter)) : new AccessControlFilter(this.authManager, activeUser, tableName, cellFirstStrategy);
        query.setFilter(newFilter);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        boolean bl = this.canPersistCellACLs = HFile.getFormatVersion(env.getConfiguration()) >= 3;
        if (!this.canPersistCellACLs) {
            LOG.info("A minimum HFile version of 3 is required to persist cell ACLs. Consider setting hfile.format.version accordingly.");
        }
        ZooKeeperWatcher zk = null;
        if (env instanceof MasterCoprocessorEnvironment) {
            MasterCoprocessorEnvironment mEnv = (MasterCoprocessorEnvironment)env;
            zk = mEnv.getMasterServices().getZooKeeper();
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            RegionServerCoprocessorEnvironment rsEnv = (RegionServerCoprocessorEnvironment)env;
            zk = rsEnv.getRegionServerServices().getZooKeeper();
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            zk = this.regionEnv.getRegionServerServices().getZooKeeper();
        }
        this.userProvider = UserProvider.instantiate(env.getConfiguration());
        if (zk != null) {
            try {
                this.authManager = TableAuthManager.get(zk, env.getConfiguration());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error obtaining TableAuthManager", ioe);
            }
        } else {
            throw new RuntimeException("Error obtaining TableAuthManager, zk found null.");
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) {
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        Set<byte[]> families = desc.getFamiliesKeys();
        TreeMap<byte[], Object> familyMap = new TreeMap<byte[], Object>(Bytes.BYTES_COMPARATOR);
        for (byte[] family : families) {
            familyMap.put(family, null);
        }
        this.requireGlobalPermission("createTable", Permission.Action.CREATE, desc.getTableName(), familyMap);
    }

    @Override
    public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (!AccessControlLists.isAclTable(desc)) {
            String owner = desc.getOwnerString();
            if (owner == null) {
                owner = this.getActiveUser().getShortName();
            }
            UserPermission userperm = new UserPermission(Bytes.toBytes(owner), desc.getTableName(), null, Permission.Action.values());
            AccessControlLists.addUserPermission(c.getEnvironment().getConfiguration(), userperm);
        }
    }

    @Override
    public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
    }

    @Override
    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission("deleteTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName);
    }

    @Override
    public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        this.requirePermission("modifyTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        String owner = htd.getOwnerString();
        if (owner == null) {
            owner = this.getActiveUser().getShortName();
        }
        UserPermission userperm = new UserPermission(Bytes.toBytes(owner), htd.getTableName(), null, Permission.Action.values());
        AccessControlLists.addUserPermission(c.getEnvironment().getConfiguration(), userperm);
    }

    @Override
    public void postModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
        this.requirePermission("addColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void postAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        this.requirePermission("modifyColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void postModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        this.requirePermission("deleteColumn", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
    }

    @Override
    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        AccessControlLists.removeTablePermissions(c.getEnvironment().getConfiguration(), tableName, col);
    }

    @Override
    public void postDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
    }

    @Override
    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission("enableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (Bytes.equals(tableName.getName(), AccessControlLists.ACL_GLOBAL_NAME)) {
            throw new AccessDeniedException("Not allowed to disable " + AccessControlLists.ACL_TABLE_NAME + " table.");
        }
        this.requirePermission("disableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void postDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
    }

    @Override
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission("move", region.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
    }

    @Override
    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("assign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
        this.requirePermission("unassign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
    }

    @Override
    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("regionOffline", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
    }

    @Override
    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("balance", Permission.Action.ADMIN);
    }

    @Override
    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> c, List<RegionPlan> plans) throws IOException {
    }

    @Override
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission("balanceSwitch", Permission.Action.ADMIN);
        return newValue;
    }

    @Override
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean oldValue, boolean newValue) throws IOException {
    }

    @Override
    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("shutdown", Permission.Action.ADMIN);
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("stopMaster", Permission.Action.ADMIN);
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        AccessControlLists.init(ctx.getEnvironment().getMasterServices());
    }

    @Override
    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("snapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("clone", Permission.Action.ADMIN);
    }

    @Override
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("restore", Permission.Action.ADMIN);
    }

    @Override
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
    }

    @Override
    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        this.requirePermission("deleteSnapshot", Permission.Action.ADMIN);
    }

    @Override
    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
    }

    @Override
    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission("createNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireGlobalPermission("deleteNamespace", Permission.Action.ADMIN, namespace);
    }

    @Override
    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        AccessControlLists.removeNamespacePermissions(ctx.getEnvironment().getConfiguration(), namespace);
        LOG.info(namespace + "entry deleted in " + AccessControlLists.ACL_TABLE_NAME + " table.");
    }

    @Override
    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission("modifyNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
    }

    @Override
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        RegionCoprocessorEnvironment env = e.getEnvironment();
        HRegion region = env.getRegion();
        if (region == null) {
            LOG.error("NULL region from RegionCoprocessorEnvironment in preOpen()");
        } else {
            HRegionInfo regionInfo = region.getRegionInfo();
            if (regionInfo.getTable().isSystemTable()) {
                this.isSystemOrSuperUser(this.regionEnv.getConfiguration());
            } else {
                this.requirePermission("preOpen", Permission.Action.ADMIN);
            }
        }
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        HRegion region = env.getRegion();
        if (region == null) {
            LOG.error("NULL region from RegionCoprocessorEnvironment in postOpen()");
            return;
        }
        if (AccessControlLists.isAclRegion(region)) {
            this.aclRegion = true;
            if (!region.isRecovering()) {
                try {
                    this.initialize(env);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to initialize permissions cache", ex);
                }
            }
        } else {
            this.initialized = true;
        }
    }

    @Override
    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> c) {
        if (this.aclRegion) {
            try {
                this.initialize(c.getEnvironment());
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to initialize permissions cache", ex);
            }
        }
    }

    @Override
    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("flush", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e, byte[] splitRow) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType) throws IOException {
        this.requirePermission("compact", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
        return scanner;
    }

    @Override
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> e, Store store, List<StoreFile> candidates) throws IOException {
        this.requirePermission("compact", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        assert (family != null);
        this.requireCoveringPermission("getClosestRowBefore", c.getEnvironment(), row, this.makeFamilyMap(family, null), Long.MAX_VALUE, false, Permission.Action.READ);
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        this.internalPreRead(c, get);
    }

    @Override
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        this.internalPreRead(c, get);
        return exists;
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        this.requireCoveringPermission("put", c.getEnvironment(), put.getRow(), put.getFamilyCellMap(), put.getTimeStamp(), false, Permission.Action.WRITE);
        byte[] bytes = put.getAttribute("acl");
        if (bytes != null) {
            if (this.canPersistCellACLs) {
                this.addCellPermissions(bytes, put.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
    }

    @Override
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), put.getFamilyCellMap());
        }
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (delete.getAttribute("acl") != null) {
            throw new DoNotRetryIOException("ACL on delete has no effect: " + delete.toString());
        }
        this.requireCoveringPermission("delete", c.getEnvironment(), delete.getRow(), delete.getFamilyCellMap(), delete.getTimeStamp(), true, Permission.Action.WRITE);
    }

    @Override
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), delete.getFamilyCellMap());
        }
    }

    @Override
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        this.requireCoveringPermission("checkAndPut", c.getEnvironment(), row, this.makeFamilyMap(family, qualifier), Long.MAX_VALUE, false, Permission.Action.READ, Permission.Action.WRITE);
        byte[] bytes = put.getAttribute("acl");
        if (bytes != null) {
            if (this.canPersistCellACLs) {
                this.addCellPermissions(bytes, put.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        if (delete.getAttribute("acl") != null) {
            throw new DoNotRetryIOException("ACL on checkAndDelete has no effect: " + delete.toString());
        }
        this.requireCoveringPermission("checkAndDelete", c.getEnvironment(), row, this.makeFamilyMap(family, qualifier), Long.MAX_VALUE, false, Permission.Action.READ, Permission.Action.WRITE);
        return result;
    }

    @Override
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.requireCoveringPermission("incrementColumnValue", c.getEnvironment(), row, this.makeFamilyMap(family, qualifier), Long.MAX_VALUE, false, Permission.Action.WRITE);
        return -1L;
    }

    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        this.requireCoveringPermission("append", c.getEnvironment(), append.getRow(), append.getFamilyCellMap(), append.getTimeStamp(), false, Permission.Action.WRITE);
        byte[] bytes = append.getAttribute("acl");
        if (bytes != null) {
            if (this.canPersistCellACLs) {
                this.addCellPermissions(bytes, append.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return null;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        this.requireCoveringPermission("increment", c.getEnvironment(), increment.getRow(), increment.getFamilyCellMap(), increment.getTimeRange().getMax(), false, Permission.Action.WRITE);
        byte[] bytes = increment.getAttribute("acl");
        if (bytes != null) {
            if (this.canPersistCellACLs) {
                this.addCellPermissions(bytes, increment.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return null;
    }

    @Override
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        byte[] aclBytes;
        if (!this.canPersistCellACLs) {
            return newCell;
        }
        ArrayList<Tag> tags = Lists.newArrayList();
        ArrayListMultimap<String, Permission> perms = ArrayListMultimap.create();
        if (oldCell != null) {
            byte[] tagBytes = CellUtil.getTagArray(oldCell);
            Iterator<Tag> tagIterator = CellUtil.tagsIterator(tagBytes, 0, tagBytes.length);
            while (tagIterator.hasNext()) {
                Tag tag = tagIterator.next();
                if (tag.getType() != 1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Carrying forward tag from " + oldCell + ": type " + tag.getType() + " length " + tag.getValue().length);
                    }
                    tags.add(tag);
                    continue;
                }
                ListMultimap<String, Permission> kvPerms = ProtobufUtil.toUsersAndPermissions(((AccessControlProtos.UsersAndPermissions.Builder)AccessControlProtos.UsersAndPermissions.newBuilder().mergeFrom(tag.getBuffer(), tag.getTagOffset(), tag.getTagLength())).build());
                perms.putAll(kvPerms);
            }
        }
        if ((aclBytes = mutation.getACL()) != null) {
            tags.add(new Tag(1, aclBytes));
        } else if (perms != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Carrying forward ACLs from " + oldCell + ": " + perms);
            }
            tags.add(new Tag(1, ProtobufUtil.toUsersAndPermissions(perms).toByteArray()));
        }
        if (tags.isEmpty()) {
            return newCell;
        }
        KeyValue newKv = KeyValueUtil.ensureKeyValue(newCell);
        byte[] bytes = newKv.getBuffer();
        KeyValue rewriteKv = new KeyValue(bytes, newKv.getRowOffset(), newKv.getRowLength(), bytes, newKv.getFamilyOffset(), newKv.getFamilyLength(), bytes, newKv.getQualifierOffset(), newKv.getQualifierLength(), newKv.getTimestamp(), KeyValue.Type.codeToType(newKv.getTypeByte()), bytes, newKv.getValueOffset(), newKv.getValueLength(), tags);
        rewriteKv.setMvccVersion(newKv.getMvccVersion());
        return rewriteKv;
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        this.internalPreRead(c, scan);
        return s;
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = this.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (RequestContext.isInRequestContext()) {
            String requestUserName = RequestContext.getRequestUserName();
            String owner = this.scannerOwners.get(s);
            if (owner != null && !owner.equals(requestUserName)) {
                throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
            }
        }
    }

    @Override
    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        for (Pair<byte[], String> el : familyPaths) {
            this.requirePermission("preBulkLoadHFile", ctx.getEnvironment().getRegion().getTableDesc().getTableName(), el.getFirst(), null, Permission.Action.WRITE);
        }
    }

    private AuthResult hasSomeAccess(RegionCoprocessorEnvironment e, String method, Permission.Action action) throws IOException {
        User requestUser = this.getActiveUser();
        TableName tableName = e.getRegion().getTableDesc().getTableName();
        AuthResult authResult = this.permissionGranted(method, requestUser, action, e, Collections.EMPTY_MAP);
        if (!authResult.isAllowed()) {
            for (UserPermission userPerm : AccessControlLists.getUserTablePermissions(this.regionEnv.getConfiguration(), tableName)) {
                for (Permission.Action userAction : userPerm.getActions()) {
                    if (!userAction.equals((Object)action)) continue;
                    return AuthResult.allow(method, "Access allowed", requestUser, action, tableName, null, null);
                }
            }
        }
        return authResult;
    }

    public void prePrepareBulkLoad(RegionCoprocessorEnvironment e) throws IOException {
        AuthResult authResult = this.hasSomeAccess(e, "prePrepareBulkLoad", Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getTableName() + ", action=WRITE)");
        }
    }

    public void preCleanupBulkLoad(RegionCoprocessorEnvironment e) throws IOException {
        AuthResult authResult = this.hasSomeAccess(e, "preCleanupBulkLoad", Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions (table=" + e.getRegion().getTableDesc().getTableName() + ", action=WRITE)");
        }
    }

    @Override
    public Message preEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request) throws IOException {
        if (this.shouldCheckExecPermissions && !(service instanceof AccessControlProtos.AccessControlService)) {
            this.requirePermission("invoke(" + service.getDescriptorForType().getName() + "." + methodName + ")", this.getTableName(ctx.getEnvironment()), null, null, Permission.Action.EXEC);
        }
        return request;
    }

    @Override
    public void postEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request, Message.Builder responseBuilder) throws IOException {
    }

    @Override
    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        UserPermission perm = ProtobufUtil.toUserPermission(request.getUserPermission());
        AccessControlProtos.GrantResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received request to grant access permission " + perm.toString());
                }
                switch (request.getUserPermission().getPermission().getType()) {
                    case Global: 
                    case Table: {
                        this.requirePermission("grant", perm.getTableName(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
                        break;
                    }
                    case Namespace: {
                        this.requireGlobalPermission("grant", Permission.Action.ADMIN, perm.getNamespace());
                    }
                }
                AccessControlLists.addUserPermission(this.regionEnv.getConfiguration(), perm);
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace("Granted permission " + perm.toString());
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.GrantResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        UserPermission perm = ProtobufUtil.toUserPermission(request.getUserPermission());
        AccessControlProtos.RevokeResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received request to revoke access permission " + perm.toString());
                }
                switch (request.getUserPermission().getPermission().getType()) {
                    case Global: 
                    case Table: {
                        this.requirePermission("revoke", perm.getTableName(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
                        break;
                    }
                    case Namespace: {
                        this.requireGlobalPermission("revoke", Permission.Action.ADMIN, perm.getNamespace());
                    }
                }
                AccessControlLists.removeUserPermission(this.regionEnv.getConfiguration(), perm);
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace("Revoked permission " + perm.toString());
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.RevokeResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        AccessControlProtos.GetUserPermissionsResponse response = null;
        try {
            List<UserPermission> perms;
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                perms = null;
                if (request.getType() == AccessControlProtos.Permission.Type.Table) {
                    TableName table = null;
                    if (request.hasTableName()) {
                        table = ProtobufUtil.toTableName(request.getTableName());
                    }
                    this.requirePermission("userPermissions", table, null, null, Permission.Action.ADMIN);
                    perms = AccessControlLists.getUserTablePermissions(this.regionEnv.getConfiguration(), table);
                } else {
                    perms = request.getType() == AccessControlProtos.Permission.Type.Namespace ? AccessControlLists.getUserNamespacePermissions(this.regionEnv.getConfiguration(), request.getNamespaceName().toStringUtf8()) : AccessControlLists.getUserPermissions(this.regionEnv.getConfiguration(), null);
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = ResponseConverter.buildGetUserPermissionsResponse(perms);
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        Permission[] permissions = new Permission[request.getPermissionCount()];
        for (int i = 0; i < request.getPermissionCount(); ++i) {
            permissions[i] = ProtobufUtil.toPermission(request.getPermission(i));
        }
        AccessControlProtos.CheckPermissionsResponse response = null;
        try {
            TableName tableName = this.regionEnv.getRegion().getTableDesc().getTableName();
            for (Permission permission : permissions) {
                if (permission instanceof TablePermission) {
                    TablePermission tperm = (TablePermission)permission;
                    for (Permission.Action action : permission.getActions()) {
                        if (!tperm.getTableName().equals(tableName)) {
                            throw new CoprocessorException(AccessController.class, String.format("This method can only execute at the table specified in TablePermission. Table of the region:%s , requested table:%s", tableName, tperm.getTableName()));
                        }
                        TreeMap<byte[], TreeSet<byte[]>> familyMap = new TreeMap<byte[], TreeSet<byte[]>>(Bytes.BYTES_COMPARATOR);
                        if (tperm.getFamily() != null) {
                            if (tperm.getQualifier() != null) {
                                TreeSet<byte[]> qualifiers = Sets.newTreeSet(Bytes.BYTES_COMPARATOR);
                                qualifiers.add(tperm.getQualifier());
                                familyMap.put(tperm.getFamily(), qualifiers);
                            } else {
                                familyMap.put(tperm.getFamily(), null);
                            }
                        }
                        this.requirePermission("checkPermissions", action, this.regionEnv, familyMap);
                    }
                    continue;
                }
                for (Permission.Action action : permission.getActions()) {
                    this.requirePermission("checkPermissions", action);
                }
            }
            response = AccessControlProtos.CheckPermissionsResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public Service getService() {
        return AccessControlProtos.AccessControlService.newReflectiveService(this);
    }

    private HRegion getRegion(RegionCoprocessorEnvironment e) {
        return e.getRegion();
    }

    private TableName getTableName(RegionCoprocessorEnvironment e) {
        HRegionInfo regionInfo;
        HRegion region = e.getRegion();
        TableName tableName = null;
        if (region != null && (regionInfo = region.getRegionInfo()) != null) {
            tableName = regionInfo.getTable();
        }
        return tableName;
    }

    @Override
    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        this.requirePermission("preClose", Permission.Action.ADMIN);
    }

    private void isSystemOrSuperUser(Configuration conf) throws IOException {
        User activeUser;
        User user = this.userProvider.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        String currentUser = user.getShortName();
        List<String> superusers = Lists.asList(currentUser, conf.getStrings("hbase.superuser", new String[0]));
        if (!superusers.contains((activeUser = this.getActiveUser()).getShortName())) {
            throw new AccessDeniedException("User '" + (user != null ? user.getShortName() : "null") + "is not system or super user.");
        }
    }

    @Override
    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        this.requirePermission("preStopRegionServer", Permission.Action.ADMIN);
    }

    private Map<byte[], ? extends Collection<byte[]>> makeFamilyMap(byte[] family, byte[] qualifier) {
        if (family == null) {
            return null;
        }
        TreeMap<byte[], ImmutableSet<byte[]>> familyMap = new TreeMap<byte[], ImmutableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        familyMap.put(family, qualifier != null ? ImmutableSet.of(qualifier) : null);
        return familyMap;
    }

    @Override
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
        if (tableNamesList == null || tableNamesList.isEmpty()) {
            this.requireGlobalPermission("getTableDescriptors", Permission.Action.ADMIN, null, null);
        } else {
            MasterServices masterServices = ctx.getEnvironment().getMasterServices();
            for (TableName tableName : tableNamesList) {
                try {
                    masterServices.checkTableModifiable(tableName);
                }
                catch (TableNotFoundException ex) {
                    continue;
                }
                catch (TableNotDisabledException ex) {
                    // empty catch block
                }
                this.requirePermission("getTableDescriptors", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
            }
        }
    }

    @Override
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
    }

    @Override
    public void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
        this.requirePermission("mergeRegions", regionA.getTableDesc().getTableName(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postMerge(ObserverContext<RegionServerCoprocessorEnvironment> c, HRegion regionA, HRegion regionB, HRegion mergedRegion) throws IOException {
    }

    @Override
    public void preMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB, List<Mutation> metaEntries) throws IOException {
    }

    @Override
    public void postMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB, HRegion mergedRegion) throws IOException {
    }

    @Override
    public void preRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
    }

    @Override
    public void postRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, HRegion regionA, HRegion regionB) throws IOException {
    }
}

