/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.security.SecureBulkLoadUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class SecureBulkLoadEndpoint
extends SecureBulkLoadProtos.SecureBulkLoadService
implements CoprocessorService,
Coprocessor {
    public static final long VERSION = 0L;
    private static final int RANDOM_WIDTH = 320;
    private static final int RANDOM_RADIX = 32;
    private static Log LOG = LogFactory.getLog(SecureBulkLoadEndpoint.class);
    private static final FsPermission PERM_ALL_ACCESS = FsPermission.valueOf("-rwxrwxrwx");
    private static final FsPermission PERM_HIDDEN = FsPermission.valueOf("-rwx--x--x");
    private SecureRandom random;
    private FileSystem fs;
    private Configuration conf;
    private Path baseStagingDir;
    private RegionCoprocessorEnvironment env;
    private UserProvider userProvider;

    @Override
    public void start(CoprocessorEnvironment env) {
        this.env = (RegionCoprocessorEnvironment)env;
        this.random = new SecureRandom();
        this.conf = env.getConfiguration();
        this.baseStagingDir = SecureBulkLoadUtil.getBaseStagingDir(this.conf);
        this.userProvider = UserProvider.instantiate(this.conf);
        try {
            this.fs = FileSystem.get(this.conf);
            this.fs.mkdirs(this.baseStagingDir, PERM_HIDDEN);
            this.fs.setPermission(this.baseStagingDir, PERM_HIDDEN);
            this.fs.mkdirs(new Path(this.baseStagingDir, "DONOTERASE"), PERM_HIDDEN);
            FileStatus status = this.fs.getFileStatus(this.baseStagingDir);
            if (status == null) {
                throw new IllegalStateException("Failed to create staging directory");
            }
            if (!status.getPermission().equals(PERM_HIDDEN)) {
                throw new IllegalStateException("Directory already exists but permissions aren't set to '-rwx--x--x' ");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get FileSystem instance", e);
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public void prepareBulkLoad(RpcController controller, SecureBulkLoadProtos.PrepareBulkLoadRequest request, RpcCallback<SecureBulkLoadProtos.PrepareBulkLoadResponse> done) {
        try {
            this.getAccessController().prePrepareBulkLoad(this.env);
            String bulkToken = this.createStagingDir(this.baseStagingDir, this.getActiveUser(), ProtobufUtil.toTableName(request.getTableName())).toString();
            done.run(SecureBulkLoadProtos.PrepareBulkLoadResponse.newBuilder().setBulkToken(bulkToken).build());
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        done.run(null);
    }

    @Override
    public void cleanupBulkLoad(RpcController controller, SecureBulkLoadProtos.CleanupBulkLoadRequest request, RpcCallback<SecureBulkLoadProtos.CleanupBulkLoadResponse> done) {
        try {
            this.getAccessController().preCleanupBulkLoad(this.env);
            this.fs.delete(this.createStagingDir(this.baseStagingDir, this.getActiveUser(), this.env.getRegion().getTableDesc().getTableName(), new Path(request.getBulkToken()).getName()), true);
            done.run(SecureBulkLoadProtos.CleanupBulkLoadResponse.newBuilder().build());
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        done.run(null);
    }

    @Override
    public void secureBulkLoadHFiles(RpcController controller, SecureBulkLoadProtos.SecureBulkLoadHFilesRequest request, RpcCallback<SecureBulkLoadProtos.SecureBulkLoadHFilesResponse> done) {
        final ArrayList<Pair<byte[], String>> familyPaths = new ArrayList<Pair<byte[], String>>();
        for (ClientProtos.BulkLoadHFileRequest.FamilyPath el : request.getFamilyPathList()) {
            familyPaths.add(new Pair<byte[], String>(el.getFamily().toByteArray(), el.getPath()));
        }
        Token userToken = new Token(request.getFsToken().getIdentifier().toByteArray(), request.getFsToken().getPassword().toByteArray(), new Text(request.getFsToken().getKind()), new Text(request.getFsToken().getService()));
        final String bulkToken = request.getBulkToken();
        User user = this.getActiveUser();
        UserGroupInformation ugi = user.getUGI();
        if (userToken != null) {
            ugi.addToken(userToken);
        } else if (this.userProvider.isHadoopSecurityEnabled()) {
            ResponseConverter.setControllerException(controller, new DoNotRetryIOException("User token cannot be null"));
            return;
        }
        HRegion region = this.env.getRegion();
        boolean bypass = false;
        if (region.getCoprocessorHost() != null) {
            try {
                bypass = region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
            }
            catch (IOException e) {
                ResponseConverter.setControllerException(controller, e);
                done.run(null);
                return;
            }
        }
        boolean loaded = false;
        if (!bypass) {
            loaded = ugi.doAs(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    FileSystem fs = null;
                    try {
                        Configuration conf = SecureBulkLoadEndpoint.this.env.getConfiguration();
                        fs = FileSystem.get(conf);
                        for (Pair el : familyPaths) {
                            Path p = new Path((String)el.getSecond());
                            LOG.trace("Setting permission for: " + p);
                            fs.setPermission(p, PERM_ALL_ACCESS);
                            Path stageFamily = new Path(bulkToken, Bytes.toString((byte[])el.getFirst()));
                            if (fs.exists(stageFamily)) continue;
                            fs.mkdirs(stageFamily);
                            fs.setPermission(stageFamily, PERM_ALL_ACCESS);
                        }
                        return SecureBulkLoadEndpoint.this.env.getRegion().bulkLoadHFiles(familyPaths, true, new SecureBulkLoadListener(fs, bulkToken));
                    }
                    catch (Exception e) {
                        LOG.error("Failed to complete bulk load", e);
                        return false;
                    }
                }
            });
        }
        if (region.getCoprocessorHost() != null) {
            try {
                loaded = region.getCoprocessorHost().postBulkLoadHFile(familyPaths, loaded);
            }
            catch (IOException e) {
                ResponseConverter.setControllerException(controller, e);
                done.run(null);
                return;
            }
        }
        done.run(SecureBulkLoadProtos.SecureBulkLoadHFilesResponse.newBuilder().setLoaded(loaded).build());
    }

    private AccessController getAccessController() {
        return (AccessController)this.env.getRegion().getCoprocessorHost().findCoprocessor(AccessController.class.getName());
    }

    private Path createStagingDir(Path baseDir, User user, TableName tableName) throws IOException {
        String randomDir = user.getShortName() + "__" + tableName + "__" + new BigInteger(320, this.random).toString(32);
        return this.createStagingDir(baseDir, user, tableName, randomDir);
    }

    private Path createStagingDir(Path baseDir, User user, TableName tableName, String randomDir) throws IOException {
        Path p = new Path(baseDir, randomDir);
        this.fs.mkdirs(p, PERM_ALL_ACCESS);
        this.fs.setPermission(p, PERM_ALL_ACCESS);
        return p;
    }

    private User getActiveUser() {
        User user = RequestContext.getRequestUser();
        if (!RequestContext.isInRequestContext()) {
            return null;
        }
        if ("simple".equalsIgnoreCase(this.conf.get("hbase.security.authentication"))) {
            return User.createUserForTesting(this.conf, user.getShortName(), new String[0]);
        }
        return user;
    }

    @Override
    public Service getService() {
        return this;
    }

    private static class SecureBulkLoadListener
    implements HRegion.BulkLoadListener {
        private FileSystem fs;
        private String stagingDir;

        public SecureBulkLoadListener(FileSystem fs, String stagingDir) {
            this.fs = fs;
            this.stagingDir = stagingDir;
        }

        @Override
        public String prepareBulkLoad(byte[] family, String srcPath) throws IOException {
            Path p = new Path(srcPath);
            Path stageP = new Path(this.stagingDir, new Path(Bytes.toString(family), p.getName()));
            if (!this.isFile(p)) {
                throw new IOException("Path does not reference a file: " + p);
            }
            LOG.debug("Moving " + p + " to " + stageP);
            if (!this.fs.rename(p, stageP)) {
                throw new IOException("Failed to move HFile: " + p + " to " + stageP);
            }
            return stageP.toString();
        }

        @Override
        public void doneBulkLoad(byte[] family, String srcPath) throws IOException {
            LOG.debug("Bulk Load done for: " + srcPath);
        }

        @Override
        public void failedBulkLoad(byte[] family, String srcPath) throws IOException {
            Path p = new Path(srcPath);
            Path stageP = new Path(this.stagingDir, new Path(Bytes.toString(family), p.getName()));
            LOG.debug("Moving " + stageP + " back to " + p);
            if (!this.fs.rename(stageP, p)) {
                throw new IOException("Failed to move HFile: " + stageP + " to " + p);
            }
        }

        private boolean isFile(Path p) throws IOException {
            FileStatus status = this.fs.getFileStatus(p);
            boolean isFile = !status.isDir();
            try {
                isFile = isFile && (Boolean)Methods.call(FileStatus.class, status, "isSymlink", null, null) == false;
            }
            catch (Exception e) {
                // empty catch block
            }
            return isFile;
        }
    }
}

