/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ListMultimap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestNamespaceCommands
extends SecureTestUtil {
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static String TestNamespace = "ns1";
    private static Configuration conf;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static User SUPERUSER;
    private static User USER_RW;
    private static User USER_CREATE;
    private static User USER_NSP_WRITE;

    @BeforeClass
    public static void beforeClass() throws Exception {
        conf = UTIL.getConfiguration();
        SecureTestUtil.enableSecurity(conf);
        SUPERUSER = User.createUserForTesting(conf, "admin", new String[]{"supergroup"});
        USER_RW = User.createUserForTesting(conf, "rw_user", new String[0]);
        USER_CREATE = User.createUserForTesting(conf, "create_user", new String[0]);
        USER_NSP_WRITE = User.createUserForTesting(conf, "namespace_write", new String[0]);
        UTIL.startMiniCluster();
        UTIL.waitTableAvailable(AccessControlLists.ACL_TABLE_NAME.getName(), 30000L);
        ACCESS_CONTROLLER = (AccessController)UTIL.getMiniHBaseCluster().getMaster().getCoprocessorHost().findCoprocessor(AccessController.class.getName());
        UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create(TestNamespace).build());
        SecureTestUtil.grantOnNamespace(UTIL, USER_NSP_WRITE.getShortName(), TestNamespace, Permission.Action.WRITE);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.getHBaseAdmin().deleteNamespace(TestNamespace);
        UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAclTableEntries() throws Exception {
        String userTestNamespace = "userTestNsp";
        HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
        try {
            SecureTestUtil.grantOnNamespace(UTIL, userTestNamespace, TestNamespace, Permission.Action.WRITE);
            Result result = acl.get(new Get(Bytes.toBytes(userTestNamespace)));
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            ListMultimap<String, TablePermission> perms = AccessControlLists.getNamespacePermissions(conf, TestNamespace);
            Assert.assertEquals((long)2L, (long)perms.size());
            List<TablePermission> namespacePerms = perms.get(userTestNamespace);
            Assert.assertTrue((boolean)perms.containsKey(userTestNamespace));
            Assert.assertEquals((long)1L, (long)namespacePerms.size());
            Assert.assertEquals((Object)TestNamespace, (Object)namespacePerms.get(0).getNamespace());
            Assert.assertEquals(null, (Object)namespacePerms.get(0).getFamily());
            Assert.assertEquals(null, (Object)namespacePerms.get(0).getQualifier());
            Assert.assertEquals((long)1L, (long)namespacePerms.get(0).getActions().length);
            Assert.assertEquals((Object)((Object)Permission.Action.WRITE), (Object)((Object)namespacePerms.get(0).getActions()[0]));
            SecureTestUtil.revokeFromNamespace(UTIL, userTestNamespace, TestNamespace, Permission.Action.WRITE);
            perms = AccessControlLists.getNamespacePermissions(conf, TestNamespace);
            Assert.assertEquals((long)1L, (long)perms.size());
        }
        finally {
            acl.close();
        }
    }

    @Test
    public void testModifyNamespace() throws Exception {
        SecureTestUtil.AccessTestAction modifyNamespace = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preModifyNamespace(ObserverContext.createAndPrepare(CP_ENV, null), NamespaceDescriptor.create(TestNamespace).addConfiguration("abc", "156").build());
                return null;
            }
        };
        this.verifyAllowed(modifyNamespace, SUPERUSER);
        this.verifyDenied(modifyNamespace, USER_NSP_WRITE, USER_CREATE, USER_RW);
    }

    @Test
    public void testGrantRevoke() throws Exception {
        String testUser = "testUser";
        SecureTestUtil.AccessTestAction grantAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.grant(protocol, "testUser", TestNamespace, Permission.Action.WRITE);
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable acl = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub(service);
                    ProtobufUtil.revoke(protocol, "testUser", TestNamespace, Permission.Action.WRITE);
                }
                finally {
                    acl.close();
                }
                return null;
            }
        };
        this.verifyAllowed(grantAction, SUPERUSER);
        this.verifyDenied(grantAction, USER_CREATE, USER_RW);
        this.verifyAllowed(revokeAction, SUPERUSER);
        this.verifyDenied(revokeAction, USER_CREATE, USER_RW);
    }
}

