/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.crypto.SecretKey;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class AuthenticationKey
implements Writable {
    private int id;
    private long expirationDate;
    private SecretKey secret;

    public AuthenticationKey() {
    }

    public AuthenticationKey(int keyId, long expirationDate, SecretKey key) {
        this.id = keyId;
        this.expirationDate = expirationDate;
        this.secret = key;
    }

    public int getKeyId() {
        return this.id;
    }

    public long getExpiration() {
        return this.expirationDate;
    }

    public void setExpiration(long timestamp) {
        this.expirationDate = timestamp;
    }

    SecretKey getKey() {
        return this.secret;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AuthenticationKey)) {
            return false;
        }
        AuthenticationKey other = (AuthenticationKey)obj;
        return this.id == other.getKeyId() && this.expirationDate == other.getExpiration() && (this.secret == null ? other.getKey() == null : other.getKey() != null && Bytes.equals(this.secret.getEncoded(), other.getKey().getEncoded()));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("AuthenticationKey[ ").append("id=").append(this.id).append(", expiration=").append(this.expirationDate).append(" ]");
        return buf.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.id);
        WritableUtils.writeVLong(out, this.expirationDate);
        if (this.secret == null) {
            WritableUtils.writeVInt(out, -1);
        } else {
            byte[] keyBytes = this.secret.getEncoded();
            WritableUtils.writeVInt(out, keyBytes.length);
            out.write(keyBytes);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.id = WritableUtils.readVInt(in);
        this.expirationDate = WritableUtils.readVLong(in);
        int keyLength = WritableUtils.readVInt(in);
        if (keyLength < 0) {
            this.secret = null;
        } else {
            byte[] keyBytes = new byte[keyLength];
            in.readFully(keyBytes);
            this.secret = AuthenticationTokenSecretManager.createSecretKey(keyBytes);
        }
    }
}

