/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.token.AuthenticationKey;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.zookeeper.KeeperException;

public class ZKSecretWatcher
extends ZooKeeperListener {
    private static final String DEFAULT_ROOT_NODE = "tokenauth";
    private static final String DEFAULT_KEYS_PARENT = "keys";
    private static Log LOG = LogFactory.getLog(ZKSecretWatcher.class);
    private AuthenticationTokenSecretManager secretManager;
    private String baseKeyZNode;
    private String keysParentZNode;

    public ZKSecretWatcher(Configuration conf, ZooKeeperWatcher watcher, AuthenticationTokenSecretManager secretManager) {
        super(watcher);
        this.secretManager = secretManager;
        String keyZNodeParent = conf.get("zookeeper.znode.tokenauth.parent", DEFAULT_ROOT_NODE);
        this.baseKeyZNode = ZKUtil.joinZNode(watcher.baseZNode, keyZNodeParent);
        this.keysParentZNode = ZKUtil.joinZNode(this.baseKeyZNode, DEFAULT_KEYS_PARENT);
    }

    public void start() throws KeeperException {
        this.watcher.registerListener(this);
        ZKUtil.createWithParents(this.watcher, this.keysParentZNode);
        if (ZKUtil.watchAndCheckExists(this.watcher, this.keysParentZNode)) {
            List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.keysParentZNode);
            this.refreshNodes(nodes);
        }
    }

    @Override
    public void nodeCreated(String path) {
        if (path.equals(this.keysParentZNode)) {
            try {
                List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.keysParentZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.fatal("Error reading data from zookeeper", ke);
                this.watcher.abort("Error reading new key znode " + path, ke);
            }
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (this.keysParentZNode.equals(ZKUtil.getParent(path))) {
            String keyId = ZKUtil.getNodeName(path);
            try {
                Integer id = new Integer(keyId);
                this.secretManager.removeKey(id);
            }
            catch (NumberFormatException nfe) {
                LOG.error("Invalid znode name for key ID '" + keyId + "'", nfe);
            }
        }
    }

    @Override
    public void nodeDataChanged(String path) {
        if (this.keysParentZNode.equals(ZKUtil.getParent(path))) {
            try {
                byte[] data = ZKUtil.getDataAndWatch(this.watcher, path);
                if (data == null || data.length == 0) {
                    LOG.debug("Ignoring empty node " + path);
                    return;
                }
                AuthenticationKey key = (AuthenticationKey)Writables.getWritable(data, new AuthenticationKey());
                this.secretManager.addKey(key);
            }
            catch (KeeperException ke) {
                LOG.fatal("Error reading data from zookeeper", ke);
                this.watcher.abort("Error reading updated key znode " + path, ke);
            }
            catch (IOException ioe) {
                LOG.fatal("Error reading key writables", ioe);
                this.watcher.abort("Error reading key writables from znode " + path, ioe);
            }
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.keysParentZNode)) {
            try {
                List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.keysParentZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.fatal("Error reading data from zookeeper", ke);
                this.watcher.abort("Error reading changed keys from zookeeper", ke);
            }
        }
    }

    public String getRootKeyZNode() {
        return this.baseKeyZNode;
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes) {
        for (ZKUtil.NodeAndData n : nodes) {
            String path = n.getNode();
            String keyId = ZKUtil.getNodeName(path);
            try {
                byte[] data = n.getData();
                if (data == null || data.length == 0) {
                    LOG.debug("Ignoring empty node " + path);
                    continue;
                }
                AuthenticationKey key = (AuthenticationKey)Writables.getWritable(data, new AuthenticationKey());
                this.secretManager.addKey(key);
            }
            catch (IOException ioe) {
                LOG.fatal("Failed reading new secret key for id '" + keyId + "' from zk", ioe);
                this.watcher.abort("Error deserializing key from znode " + path, ioe);
            }
        }
    }

    private String getKeyNode(int keyId) {
        return ZKUtil.joinZNode(this.keysParentZNode, Integer.toString(keyId));
    }

    public void removeKeyFromZK(AuthenticationKey key) {
        String keyZNode = this.getKeyNode(key.getKeyId());
        try {
            ZKUtil.deleteNode(this.watcher, keyZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.error("Non-existent znode " + keyZNode + " for key " + key.getKeyId(), nne);
        }
        catch (KeeperException ke) {
            LOG.fatal("Failed removing znode " + keyZNode + " for key " + key.getKeyId(), ke);
            this.watcher.abort("Unhandled zookeeper error removing znode " + keyZNode + " for key " + key.getKeyId(), ke);
        }
    }

    public void addKeyToZK(AuthenticationKey key) {
        String keyZNode = this.getKeyNode(key.getKeyId());
        try {
            byte[] keyData = Writables.getBytes((Writable)key);
            ZKUtil.createSetData(this.watcher, keyZNode, keyData);
        }
        catch (KeeperException ke) {
            LOG.fatal("Unable to synchronize master key " + key.getKeyId() + " to znode " + keyZNode, ke);
            this.watcher.abort("Unable to synchronize secret key " + key.getKeyId() + " in zookeeper", ke);
        }
        catch (IOException ioe) {
            this.watcher.abort("Failed serializing key " + key.getKeyId(), ioe);
        }
    }

    public void updateKeyInZK(AuthenticationKey key) {
        String keyZNode = this.getKeyNode(key.getKeyId());
        try {
            byte[] keyData = Writables.getBytes((Writable)key);
            try {
                ZKUtil.updateExistingNodeData(this.watcher, keyZNode, keyData, -1);
            }
            catch (KeeperException.NoNodeException ne) {
                ZKUtil.createSetData(this.watcher, keyZNode, keyData);
            }
        }
        catch (KeeperException ke) {
            LOG.fatal("Unable to update master key " + key.getKeyId() + " in znode " + keyZNode);
            this.watcher.abort("Unable to synchronize secret key " + key.getKeyId() + " in zookeeper", ke);
        }
        catch (IOException ioe) {
            this.watcher.abort("Failed serializing key " + key.getKeyId(), ioe);
        }
    }
}

