/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.security.visibility.ExpressionParser;
import org.apache.hadoop.hbase.security.visibility.ParseException;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestExpressionParser {
    private ExpressionParser parser = new ExpressionParser();

    @Test
    public void testPositiveCases() throws Exception {
        ExpressionNode node = this.parser.parse("abc");
        Assert.assertTrue((boolean)(node instanceof LeafExpressionNode));
        Assert.assertEquals((Object)"abc", (Object)((LeafExpressionNode)node).getIdentifier());
        node = this.parser.parse("a&b|c&d");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        NonLeafExpressionNode nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        node = this.parser.parse("(a)");
        Assert.assertTrue((boolean)(node instanceof LeafExpressionNode));
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)node).getIdentifier());
        node = this.parser.parse(" ( a & b )");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        node = this.parser.parse("((((a&b))))");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        node = this.parser.parse("( a | b ) & (cc|def)");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        NonLeafExpressionNode nlNodeLeft = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        NonLeafExpressionNode nlNodeRight = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNodeLeft.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNodeLeft.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNodeLeft.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNodeLeft.getChildExps().get(1)).getIdentifier());
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNodeRight.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNodeRight.getChildExps().size());
        Assert.assertEquals((Object)"cc", (Object)((LeafExpressionNode)nlNodeRight.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"def", (Object)((LeafExpressionNode)nlNodeRight.getChildExps().get(1)).getIdentifier());
        node = this.parser.parse("a&(cc|de)");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"cc", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"de", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        node = this.parser.parse("(a&b)|c");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        node = this.parser.parse("(a&b&c)|d");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        node = this.parser.parse("a&(b|(c|d))");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"d", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        node = this.parser.parse("(!a)");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        node = this.parser.parse("a&(!b)");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        node = this.parser.parse("!a&b");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        node = this.parser.parse("!a&(!b)");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNodeLeft = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        nlNodeRight = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNodeLeft.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNodeLeft.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNodeLeft.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNodeRight.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNodeRight.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNodeRight.getChildExps().get(0)).getIdentifier());
        node = this.parser.parse("!a&!b");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNodeLeft = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        nlNodeRight = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNodeLeft.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNodeLeft.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNodeLeft.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNodeRight.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNodeRight.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNodeRight.getChildExps().get(0)).getIdentifier());
        node = this.parser.parse("!(a&b)");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNode.getChildExps().size());
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(1)).getIdentifier());
        node = this.parser.parse("a&!b");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNode.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNode.getChildExps().get(0)).getIdentifier());
        node = this.parser.parse("!((a | b) & !(c & !b))");
        Assert.assertTrue((boolean)(node instanceof NonLeafExpressionNode));
        nlNode = (NonLeafExpressionNode)node;
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNode.getChildExps().size());
        nlNode = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNode.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNode.getChildExps().size());
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(0) instanceof NonLeafExpressionNode));
        Assert.assertTrue((boolean)(nlNode.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNodeLeft = (NonLeafExpressionNode)nlNode.getChildExps().get(0);
        nlNodeRight = (NonLeafExpressionNode)nlNode.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.OR), (Object)((Object)nlNodeLeft.getOperator()));
        Assert.assertEquals((Object)"a", (Object)((LeafExpressionNode)nlNodeLeft.getChildExps().get(0)).getIdentifier());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNodeLeft.getChildExps().get(1)).getIdentifier());
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNodeRight.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNodeRight.getChildExps().size());
        nlNodeRight = (NonLeafExpressionNode)nlNodeRight.getChildExps().get(0);
        Assert.assertEquals((Object)((Object)Operator.AND), (Object)((Object)nlNodeRight.getOperator()));
        Assert.assertEquals((long)2L, (long)nlNodeRight.getChildExps().size());
        Assert.assertEquals((Object)"c", (Object)((LeafExpressionNode)nlNodeRight.getChildExps().get(0)).getIdentifier());
        Assert.assertTrue((boolean)(nlNodeRight.getChildExps().get(1) instanceof NonLeafExpressionNode));
        nlNodeRight = (NonLeafExpressionNode)nlNodeRight.getChildExps().get(1);
        Assert.assertEquals((Object)((Object)Operator.NOT), (Object)((Object)nlNodeRight.getOperator()));
        Assert.assertEquals((long)1L, (long)nlNodeRight.getChildExps().size());
        Assert.assertEquals((Object)"b", (Object)((LeafExpressionNode)nlNodeRight.getChildExps().get(0)).getIdentifier());
    }

    @Test
    public void testNegativeCases() throws Exception {
        this.executeNegativeCase("(");
        this.executeNegativeCase(")");
        this.executeNegativeCase("()");
        this.executeNegativeCase("(a");
        this.executeNegativeCase("a&");
        this.executeNegativeCase("a&|b");
        this.executeNegativeCase("!");
        this.executeNegativeCase("a!");
        this.executeNegativeCase("a!&");
        this.executeNegativeCase("&");
        this.executeNegativeCase("|");
        this.executeNegativeCase("!(a|(b&c)&!b");
        this.executeNegativeCase("!!a");
        this.executeNegativeCase("( a & b ) | ( c & d e)");
        this.executeNegativeCase("! a");
    }

    private void executeNegativeCase(String exp) {
        try {
            this.parser.parse(exp);
            Assert.fail((String)("Expected ParseException for expression " + exp));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

