/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityLabels {
    private static final String TOPSECRET = "topsecret";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes("row1");
    private static final byte[] row2 = Bytes.toBytes("row2");
    private static final byte[] row3 = Bytes.toBytes("row3");
    private static final byte[] row4 = Bytes.toBytes("row4");
    private static final byte[] fam = Bytes.toBytes("info");
    private static final byte[] qual = Bytes.toBytes("qual");
    private static final byte[] value = Bytes.toBytes("value");
    public static Configuration conf;
    private volatile boolean killedRS = false;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        conf.setBoolean("hbase.online.schema.update.enable", true);
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting(conf, "admin", new String[]{"supergroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityLabels.addLabels();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.killedRS = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleVisibilityLabels() throws Exception {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "secret|confidential", "private|confidential");
        try {
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(SECRET, CONFIDENTIAL, PRIVATE));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), row1, 0, row1.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), row2, 0, row2.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithComplexLabels() throws Exception {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)&!topsecret", "(private&confidential&secret)", "(private&confidential&secret)", "(private&confidential&secret)");
        try {
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(TOPSECRET, CONFIDENTIAL, PRIVATE, PUBLIC, SECRET));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(4);
            Assert.assertEquals((long)3L, (long)next.length);
            CellScanner cellScanner = next[0].cellScanner();
            cellScanner.advance();
            Cell current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), row2, 0, row2.length));
            cellScanner = next[1].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), row3, 0, row3.length));
            cellScanner = next[2].cellScanner();
            cellScanner.advance();
            current = cellScanner.current();
            Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), row4, 0, row4.length));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsThatDoesNotPassTheCriteria() throws Exception {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", PRIVATE);
        try {
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(PUBLIC));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 0 ? 1 : 0) != 0);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    @Test
    public void testVisibilityLabelsInPutsThatDoesNotMatchAnyDefinedLabels() throws Exception {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        try {
            TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "SAMPLE_LABEL", "TEST");
            Assert.fail((String)"Should have failed with failed sanity check exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsInScanThatDoesNotMatchAnyDefinedLabels() throws Exception {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", PRIVATE);
        try {
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations("SAMPLE"));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 0 ? 1 : 0) != 0);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsWithGet() throws Exception {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "secret&confidential&!private", "secret&confidential&private");
        try {
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations(SECRET, CONFIDENTIAL));
            Result result = table.get(get);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Cell cell = result.getColumnLatestCell(fam, qual);
            Assert.assertTrue((boolean)Bytes.equals(value, 0, value.length, cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsOnKillingOfRSContainingLabelsTable() throws Exception {
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        int liveRS = 0;
        for (JVMClusterUtil.RegionServerThread rsThreads : regionServerThreads) {
            if (rsThreads.getRegionServer().isAborted()) continue;
            ++liveRS;
        }
        if (liveRS == 1) {
            TEST_UTIL.getHBaseCluster().startRegionServer();
        }
        Thread t1 = new Thread(){

            @Override
            public void run() {
                List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
                for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
                    List<HRegion> onlineRegions = rsThread.getRegionServer().getOnlineRegions(VisibilityConstants.LABELS_TABLE_NAME);
                    if (onlineRegions.size() <= 0) continue;
                    rsThread.getRegionServer().abort("Aborting ");
                    TestVisibilityLabels.this.killedRS = true;
                    break;
                }
            }
        };
        t1.start();
        final TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    while (!TestVisibilityLabels.this.killedRS) {
                        Thread.sleep(1L);
                    }
                    TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, new String[]{"(secret|confidential)", TestVisibilityLabels.PRIVATE});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        while (!this.killedRS) {
            Thread.sleep(10L);
        }
        regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
            List<HRegion> onlineRegions;
            while (!rsThread.getRegionServer().isAborted() && (onlineRegions = rsThread.getRegionServer().getOnlineRegions(VisibilityConstants.LABELS_TABLE_NAME)).size() <= 0) {
                Thread.sleep(10L);
            }
        }
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        t.join();
        HTable table = null;
        try {
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(SECRET));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testVisibilityLabelsOnRSRestart() throws Exception {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", PRIVATE);
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
            rsThread.getRegionServer().abort("Aborting ");
        }
        JVMClusterUtil.RegionServerThread rs = TEST_UTIL.getHBaseCluster().startRegionServer();
        this.waitForLabelsRegionAvailability(rs.getRegionServer());
        try {
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(SECRET));
            ResultScanner scanner = table.getScanner(s);
            Result[] next = scanner.next(3);
            Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAddVisibilityLabelsOnRSRestart() throws Exception {
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = TEST_UTIL.getHBaseCluster().getRegionServerThreads();
        for (JVMClusterUtil.RegionServerThread rsThread : regionServerThreads) {
            rsThread.getRegionServer().abort("Aborting ");
        }
        JVMClusterUtil.RegionServerThread rs = TEST_UTIL.getHBaseCluster().startRegionServer();
        this.waitForLabelsRegionAvailability(rs.getRegionServer());
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.CONFIDENTIAL, TestVisibilityLabels.PRIVATE, "ABC", "XYZ"};
                try {
                    VisibilityClient.addLabels(conf, labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs(action);
        Scan s = new Scan();
        s.setAuthorizations(new Authorizations("system"));
        HTable ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME.getName());
        int i = 0;
        try {
            Result next;
            ResultScanner scanner = ht.getScanner(s);
            while ((next = scanner.next()) != null) {
                ++i;
            }
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
        Assert.assertEquals((String)"The count should be 8", (long)8L, (long)i);
    }

    private void waitForLabelsRegionAvailability(HRegionServer regionServer) {
        while (!regionServer.isOnline()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        while (regionServer.getOnlineRegions(VisibilityConstants.LABELS_TABLE_NAME).isEmpty()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        HRegion labelsTableRegion = regionServer.getOnlineRegions(VisibilityConstants.LABELS_TABLE_NAME).get(0);
        while (labelsTableRegion.isRecovering()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVisibilityLabelsInGetThatDoesNotMatchAnyDefinedLabels() throws Exception {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = TestVisibilityLabels.createTableAndWriteDataWithLabels(tableName, "(secret|confidential)", PRIVATE);
        try {
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations("SAMPLE"));
            Result result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    @Test
    public void testAddLabels() throws Throwable {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{"L1", TestVisibilityLabels.SECRET, "L2", "invalid~", "L3"};
                VisibilityLabelsProtos.VisibilityLabelsResponse response = null;
                try {
                    response = VisibilityClient.addLabels(conf, labels);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have thrown exception");
                }
                List<ClientProtos.RegionActionResult> resultList = response.getResultList();
                Assert.assertEquals((long)5L, (long)resultList.size());
                Assert.assertTrue((boolean)resultList.get(0).getException().getValue().isEmpty());
                Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.visibility.LabelAlreadyExistsException", (Object)resultList.get(1).getException().getName());
                Assert.assertTrue((boolean)resultList.get(2).getException().getValue().isEmpty());
                Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.visibility.InvalidLabelException", (Object)resultList.get(3).getException().getName());
                Assert.assertTrue((boolean)resultList.get(4).getException().getValue().isEmpty());
                return null;
            }
        };
        SUPERUSER.runAs(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetAndGetUserAuths() throws Throwable {
        String user = "user1";
        PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String[] auths = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.CONFIDENTIAL};
                try {
                    VisibilityClient.setAuths(conf, auths, "user1");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        };
        SUPERUSER.runAs(action);
        HTable ht = null;
        try {
            ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME);
            Scan scan = new Scan();
            scan.setAuthorizations(new Authorizations("system"));
            ResultScanner scanner = ht.getScanner(scan);
            Result result = null;
            while ((result = scanner.next()) != null) {
                Cell label = result.getColumnLatestCell(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
                Cell userAuth = result.getColumnLatestCell(VisibilityConstants.LABELS_TABLE_FAMILY, "user1".getBytes());
                if (Bytes.equals(SECRET.getBytes(), 0, SECRET.getBytes().length, label.getValueArray(), label.getValueOffset(), label.getValueLength()) || Bytes.equals(CONFIDENTIAL.getBytes(), 0, CONFIDENTIAL.getBytes().length, label.getValueArray(), label.getValueOffset(), label.getValueLength())) {
                    Assert.assertNotNull((Object)userAuth);
                    continue;
                }
                Assert.assertNull((Object)userAuth);
            }
        }
        finally {
            if (ht != null) {
                ht.close();
            }
        }
        action = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    authsResponse = VisibilityClient.getAuths(conf, "user1");
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString(authBS.toByteArray()));
                }
                Assert.assertEquals((long)2L, (long)authsList.size());
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.SECRET));
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.CONFIDENTIAL));
                return null;
            }
        };
        SUPERUSER.runAs(action);
        action = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String[] auths1 = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.CONFIDENTIAL};
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    VisibilityClient.setAuths(conf, auths1, "user1");
                    try {
                        authsResponse = VisibilityClient.getAuths(conf, "user1");
                    }
                    catch (Throwable e) {
                        Assert.fail((String)"Should not have failed");
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString(authBS.toByteArray()));
                }
                Assert.assertEquals((long)2L, (long)authsList.size());
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.SECRET));
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.CONFIDENTIAL));
                return null;
            }
        };
        SUPERUSER.runAs(action);
    }

    @Test
    public void testClearUserAuths() throws Throwable {
        PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                String[] auths = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.CONFIDENTIAL, TestVisibilityLabels.PRIVATE};
                String user = "testUser";
                try {
                    VisibilityClient.setAuths(conf, auths, user);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                auths = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.PUBLIC, TestVisibilityLabels.CONFIDENTIAL};
                VisibilityLabelsProtos.VisibilityLabelsResponse response = null;
                try {
                    response = VisibilityClient.clearAuths(conf, auths, user);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                List<ClientProtos.RegionActionResult> resultList = response.getResultList();
                Assert.assertEquals((long)3L, (long)resultList.size());
                Assert.assertTrue((boolean)resultList.get(0).getException().getValue().isEmpty());
                Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.visibility.InvalidLabelException", (Object)resultList.get(1).getException().getName());
                Assert.assertTrue((boolean)resultList.get(2).getException().getValue().isEmpty());
                HTable ht = null;
                try {
                    ht = new HTable(conf, VisibilityConstants.LABELS_TABLE_NAME);
                    ResultScanner scanner = ht.getScanner(new Scan());
                    Result result = null;
                    while ((result = scanner.next()) != null) {
                        Cell label = result.getColumnLatestCell(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
                        Cell userAuth = result.getColumnLatestCell(VisibilityConstants.LABELS_TABLE_FAMILY, user.getBytes());
                        if (Bytes.equals(TestVisibilityLabels.PRIVATE.getBytes(), 0, TestVisibilityLabels.PRIVATE.getBytes().length, label.getValueArray(), label.getValueOffset(), label.getValueLength())) {
                            Assert.assertNotNull((Object)userAuth);
                            continue;
                        }
                        Assert.assertNull((Object)userAuth);
                    }
                }
                finally {
                    if (ht != null) {
                        ht.close();
                    }
                }
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    authsResponse = VisibilityClient.getAuths(conf, user);
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString(authBS.toByteArray()));
                }
                Assert.assertEquals((long)1L, (long)authsList.size());
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLabels.PRIVATE));
                return null;
            }
        };
        SUPERUSER.runAs(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLabelsWithCheckAndPut() throws Throwable {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = TEST_UTIL.createTable(tableName, fam);
            byte[] row1 = Bytes.toBytes("row1");
            Put put = new Put(row1);
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility("secret & confidential"));
            table.checkAndPut(row1, fam, qual, null, put);
            byte[] row2 = Bytes.toBytes("row2");
            put = new Put(row2);
            put.add(fam, qual, Long.MAX_VALUE, value);
            put.setCellVisibility(new CellVisibility(SECRET));
            table.checkAndPut(row2, fam, qual, null, put);
            Scan scan = new Scan();
            scan.setAuthorizations(new Authorizations(SECRET));
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals(row2, result.getRow()));
            result = scanner.next();
            Assert.assertNull((Object)result);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLabelsWithIncrement() throws Throwable {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = TEST_UTIL.createTable(tableName, fam);
            byte[] row1 = Bytes.toBytes("row1");
            byte[] val = Bytes.toBytes(1L);
            Put put = new Put(row1);
            put.add(fam, qual, Long.MAX_VALUE, val);
            put.setCellVisibility(new CellVisibility("secret & confidential"));
            table.put(put);
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations(SECRET));
            Result result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
            table.incrementColumnValue(row1, fam, qual, 2L);
            result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
            Increment increment = new Increment(row1);
            increment.addColumn(fam, qual, 2L);
            increment.setCellVisibility(new CellVisibility(SECRET));
            table.increment(increment);
            result = table.get(get);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLabelsWithAppend() throws Throwable {
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = TEST_UTIL.createTable(tableName, fam);
            byte[] row1 = Bytes.toBytes("row1");
            byte[] val = Bytes.toBytes("a");
            Put put = new Put(row1);
            put.add(fam, qual, Long.MAX_VALUE, val);
            put.setCellVisibility(new CellVisibility("secret & confidential"));
            table.put(put);
            Get get = new Get(row1);
            get.setAuthorizations(new Authorizations(SECRET));
            Result result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
            Append append = new Append(row1);
            append.add(fam, qual, Bytes.toBytes("b"));
            table.append(append);
            result = table.get(get);
            Assert.assertTrue((boolean)result.isEmpty());
            append = new Append(row1);
            append.add(fam, qual, Bytes.toBytes("c"));
            append.setCellVisibility(new CellVisibility(SECRET));
            table.append(append);
            result = table.get(get);
            Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    @Test
    public void testUserShouldNotDoDDLOpOnLabelsTable() throws Exception {
        HColumnDescriptor hcd;
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        try {
            admin.disableTable(VisibilityConstants.LABELS_TABLE_NAME);
            Assert.fail((String)"Lables table should not get disabled by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            admin.deleteTable(VisibilityConstants.LABELS_TABLE_NAME);
            Assert.fail((String)"Lables table should not get disabled by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            hcd = new HColumnDescriptor("testFamily");
            admin.addColumn(VisibilityConstants.LABELS_TABLE_NAME, hcd);
            Assert.fail((String)"Lables table should not get altered by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            admin.deleteColumn(VisibilityConstants.LABELS_TABLE_NAME, VisibilityConstants.LABELS_TABLE_FAMILY);
            Assert.fail((String)"Lables table should not get altered by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            hcd = new HColumnDescriptor(VisibilityConstants.LABELS_TABLE_FAMILY);
            hcd.setBloomFilterType(BloomType.ROWCOL);
            admin.modifyColumn(VisibilityConstants.LABELS_TABLE_NAME, hcd);
            Assert.fail((String)"Lables table should not get altered by user.");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            HTableDescriptor htd = new HTableDescriptor(VisibilityConstants.LABELS_TABLE_NAME);
            htd.addFamily(new HColumnDescriptor("f1"));
            htd.addFamily(new HColumnDescriptor("f2"));
            admin.modifyTable(VisibilityConstants.LABELS_TABLE_NAME, htd);
            Assert.fail((String)"Lables table should not get altered by user.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HTable createTableAndWriteDataWithLabels(TableName tableName, String ... labelExps) throws Exception {
        HTable table = null;
        try {
            table = TEST_UTIL.createTable(tableName, fam);
            int i = 1;
            ArrayList<Put> puts = new ArrayList<Put>();
            for (String labelExp : labelExps) {
                Put put = new Put(Bytes.toBytes("row" + i));
                put.add(fam, qual, Long.MAX_VALUE, value);
                put.setCellVisibility(new CellVisibility(labelExp));
                puts.add(put);
                ++i;
            }
            table.put(puts);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
        return table;
    }

    public static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityLabels.SECRET, TestVisibilityLabels.TOPSECRET, TestVisibilityLabels.CONFIDENTIAL, TestVisibilityLabels.PUBLIC, TestVisibilityLabels.PRIVATE};
                try {
                    VisibilityClient.addLabels(conf, labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs(action);
    }
}

